/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.uima.test.junit_extension.ExceptionPrinter;
import org.junit.Assert;

public class JUnitExtension {
    public static File getFile(String aRelativeFilePath) {
        URL url = JUnitExtension.class.getClassLoader().getResource(aRelativeFilePath);
        File file = null;
        if (url != null) {
            try {
                String fileURL = URLDecoder.decode(url.getFile(), "UTF-8");
                file = new File(fileURL);
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }
        return file;
    }

    public static URL getURL(String aRelativeFilePath) {
        return JUnitExtension.class.getClassLoader().getResource(aRelativeFilePath);
    }

    public static void handleException(Exception e) throws Exception {
        if (!System.getProperty("isCommandLine", "false").equals("true")) {
            throw e;
        }
        ExceptionPrinter.printException(e);
        Assert.fail((String)e.getMessage());
    }
}

