/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class ManageOutputDevice {
    private static PrintStream sysOutPS = System.out;
    private static PrintStream sysErrPS = System.err;

    public static void setSysOutToFile(String descriptor) throws FileNotFoundException {
        File f = new File(descriptor);
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)), true);
        System.setOut(printStream);
    }

    public static void setSysOutToDefault() {
        System.setOut(sysOutPS);
    }

    public static void setSysOutToNirvana() {
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
    }

    public static void setSysErrToFile(String descriptor) throws FileNotFoundException {
        File f = new File(descriptor);
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)), true);
        System.setErr(printStream);
    }

    public static void setSysErrToDefault() {
        System.setErr(sysErrPS);
    }

    public static void setSysErrToNirvana() {
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
    }

    public static void setAllSystemOutputToNirvana() {
        ManageOutputDevice.setSysErrToNirvana();
        ManageOutputDevice.setSysOutToNirvana();
    }

    public static void setAllSystemOutputToDefault() {
        ManageOutputDevice.setSysErrToDefault();
        ManageOutputDevice.setSysOutToDefault();
    }
}

