/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.util.XMLInputSource;

public class SimpleRunCPE
extends Thread {
    private CollectionProcessingEngine mCPE;
    private long mStartTime = System.currentTimeMillis();
    private long mInitCompleteTime;

    public SimpleRunCPE(String[] args) throws Exception {
        String line;
        if (args.length < 1) {
            SimpleRunCPE.printUsageMessage();
            System.exit(1);
        }
        System.out.println("Parsing CPE Descriptor");
        CpeDescription cpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(args[0]));
        System.out.println("Instantiating CPE");
        this.mCPE = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)cpeDesc);
        this.mCPE.addStatusCallbackListener((StatusCallbackListener)new StatusCallbackListenerImpl());
        System.out.println("Running CPE");
        this.mCPE.process();
        System.out.println("To abort processing, type \"abort\" and press enter.");
        while (!"abort".equals(line = new BufferedReader(new InputStreamReader(System.in)).readLine()) || !this.mCPE.isProcessing()) {
        }
        System.out.println("Aborting...");
        this.mCPE.stop();
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \nargs[0] : path to CPE descriptor file");
    }

    public static void main(String[] args) throws Exception {
        new SimpleRunCPE(args);
    }

    class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        int entityCount = 0;
        long size = 0L;

        StatusCallbackListenerImpl() {
        }

        public void initializationComplete() {
            System.out.println("CPM Initialization Complete");
            SimpleRunCPE.this.mInitCompleteTime = System.currentTimeMillis();
        }

        public void batchProcessComplete() {
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.currentTimeMillis() - SimpleRunCPE.this.mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
        }

        public void collectionProcessComplete() {
            long time = System.currentTimeMillis();
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long initTime = SimpleRunCPE.this.mInitCompleteTime - SimpleRunCPE.this.mStartTime;
            long processingTime = time - SimpleRunCPE.this.mInitCompleteTime;
            long elapsedTime = initTime + processingTime;
            System.out.println("Total Time Elapsed: " + elapsedTime + " ms ");
            System.out.println("Initialization Time: " + initTime + " ms");
            System.out.println("Processing Time: " + processingTime + " ms");
            System.out.println("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
            System.out.println(SimpleRunCPE.this.mCPE.getPerformanceReport().toString());
            System.exit(1);
        }

        public void paused() {
            System.out.println("Paused");
        }

        public void resumed() {
            System.out.println("Resumed");
        }

        public void aborted() {
            System.out.println("Aborted");
            System.exit(1);
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus.isException()) {
                List exceptions = aStatus.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    ((Throwable)exceptions.get(i)).printStackTrace();
                }
                return;
            }
            ++this.entityCount;
            String docText = aCas.getDocumentText();
            if (docText != null) {
                this.size += (long)docText.length();
            }
        }
    }
}

