/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FileChooserBugWorkarounds {
    public static void fix() {
        int MAX_ATTEMPTS = 20;
        JFileChooser fileChooser = null;
        int attempts = 0;
        while (fileChooser == null) {
            try {
                fileChooser = new JFileChooser();
            }
            catch (NullPointerException e) {
                if (attempts >= 20) break;
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e2) {}
            }
        }
        if (fileChooser == null) {
            System.err.println("Encountered Java bug #4711700.  Setting Look & Feel to default.");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Could not set default look & feel.  Application may be unstable.");
                e.printStackTrace();
            }
        }
    }

    public static void setCurrentDirectory(final JFileChooser aFileChooser, final File aDir) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                aFileChooser.setCurrentDirectory(aDir);
            }
        });
    }
}

