/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class IntegerArray
extends TOP
implements IntArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private IntegerArray() {
    }

    public IntegerArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public IntegerArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createArray(jcas.getType((int)IntegerArray.typeIndexID).casTypeCode, length), jcas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(length);
    }

    public int get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i);
    }

    public void set(int i, int v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i, v);
    }

    public void copyFromArray(int[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int srcOffset, int[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i + srcOffset);
        }
    }

    public int[] toArray() {
        int size = this.size();
        int[] outArray = new int[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Integer.toString(this.jcasType.ll_cas.ll_getIntArrayValue(this.addr, i + srcOffset));
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setIntArrayValue(this.addr, i + destOffset, Integer.parseInt(src[i + srcOffset]));
        }
    }

    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(IntegerArray.class);
    }
}

