/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import java.util.List;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.impl.metadata.cpe.CpeResourceManagerConfigurationImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeTimerImpl;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeResourceManagerConfiguration;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;

public class CpeDescriptionImpl
extends MetaDataObject_impl
implements CpeDescription {
    private static final long serialVersionUID = -8068920415609241198L;
    private CpeCollectionReader collectionReader;
    private CpeCasProcessors casProcessors;
    private CpeConfiguration cpeConfiguration;
    private CpeResourceManagerConfiguration resourceMgrConfig;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("cpeDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("allCollectionCollectionReaders", null), new PropertyXmlInfo("cpeCasProcessors", null), new PropertyXmlInfo("cpeConfig", null), new PropertyXmlInfo("cpeResourceManagerConfiguration", null)});

    public CpeDescriptionImpl() {
    }

    public CpeDescriptionImpl(XMLInputSource aInput) throws InvalidXMLException {
        try {
            CpeCasProcessors cps;
            CpeCollectionReader[] readers;
            CpeDescription descriptor = CpeDescriptorFactory.produceDescriptor(aInput);
            if (descriptor.getResourceManagerConfiguration() != null) {
                this.resourceMgrConfig = descriptor.getResourceManagerConfiguration();
            }
            if (descriptor.getCpeConfiguration() != null) {
                this.setCpeConfig(descriptor.getCpeConfiguration());
            }
            if ((readers = descriptor.getAllCollectionCollectionReaders()) != null && readers.length > 0 && readers[0] != null) {
                this.addCollectionReader(readers[0]);
            }
            if ((cps = descriptor.getCpeCasProcessors()) != null) {
                CpeCasProcessor[] casProcessors = cps.getAllCpeCasProcessors();
                for (int i = 0; casProcessors != null && i < casProcessors.length; ++i) {
                    this.addCasProcessor(casProcessors[i]);
                }
                if (this.getCpeCasProcessors() != null) {
                    if (cps.getConcurrentPUCount() > 0) {
                        this.getCpeCasProcessors().setConcurrentPUCount(cps.getConcurrentPUCount());
                    }
                    if (cps.getCasPoolSize() > 0) {
                        this.getCpeCasProcessors().setPoolSize(cps.getCasPoolSize());
                    }
                    if (cps.getInputQueueSize() > 0) {
                        this.getCpeCasProcessors().setInputQueueSize(cps.getInputQueueSize());
                    }
                    if (cps.getOutputQueueSize() > 0) {
                        this.getCpeCasProcessors().setOutputQueueSize(cps.getOutputQueueSize());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new InvalidXMLException(e);
        }
    }

    public void addCollectionReader(CpeCollectionReader aCollectionReader) throws CpeDescriptorException {
        this.collectionReader = aCollectionReader;
    }

    public CpeCollectionReader addCollectionReader(String aCollectionReaderPath) throws CpeDescriptorException {
        if (this.collectionReader == null) {
            this.collectionReader = CpeDescriptorFactory.produceCollectionReader(aCollectionReaderPath);
        } else {
            this.collectionReader.getDescriptor().getInclude().set(aCollectionReaderPath);
        }
        return this.collectionReader;
    }

    @Deprecated
    public CpeCollectionReaderCasInitializer addCasInitializer(String aInitializerDescriptorPath) throws CpeDescriptorException {
        if (this.collectionReader == null) {
            this.collectionReader = CpeDescriptorFactory.produceCollectionReader();
        }
        if (this.collectionReader.getCasInitializer() == null) {
            this.collectionReader.setCasInitializer(CpeDescriptorFactory.produceCollectionReaderCasInitializer(aInitializerDescriptorPath, this));
        } else {
            this.collectionReader.getCasInitializer().getDescriptor().getInclude().set(aInitializerDescriptorPath);
        }
        return this.collectionReader.getCasInitializer();
    }

    public CpeCollectionReader[] getAllCollectionCollectionReaders() throws CpeDescriptorException {
        if (this.collectionReader == null) {
            return new CpeCollectionReader[0];
        }
        CpeCollectionReader[] readers = new CpeCollectionReader[]{this.collectionReader};
        return readers;
    }

    public void setAllCollectionCollectionReaders(CpeCollectionReader[] areaders) throws CpeDescriptorException {
        this.collectionReader = areaders == null || areaders.length == 0 ? null : areaders[0];
    }

    public void setResourceManagerConfiguration(String aResMgrConfPagth) {
        if (this.resourceMgrConfig != null) {
            this.resourceMgrConfig.set(aResMgrConfPagth);
        }
    }

    public void setCpeResourceManagerConfiguration(CpeResourceManagerConfiguration aResMgrConfPagth) {
        this.resourceMgrConfig = aResMgrConfPagth;
    }

    public CpeResourceManagerConfiguration getCpeResourceManagerConfiguration() {
        return this.resourceMgrConfig;
    }

    @Deprecated
    public void setInputQueueSize(int aSize) throws CpeDescriptorException {
        if (this.casProcessors == null) {
            this.casProcessors = CpeDescriptorFactory.produceCasProcessors();
        }
        this.casProcessors.setInputQueueSize(aSize);
    }

    public void setProcessingUnitThreadCount(int aSize) throws CpeDescriptorException {
        if (this.casProcessors == null) {
            this.casProcessors = CpeDescriptorFactory.produceCasProcessors();
        }
        this.casProcessors.setConcurrentPUCount(aSize);
    }

    @Deprecated
    public void setOutputQueueSize(int aSize) throws CpeDescriptorException {
        if (this.casProcessors == null) {
            this.casProcessors = CpeDescriptorFactory.produceCasProcessors();
        }
        this.casProcessors.setOutputQueueSize(aSize);
    }

    public void setCpeCasProcessors(CpeCasProcessors aCasProcessors) {
        this.casProcessors = aCasProcessors;
    }

    public CpeCasProcessors getCpeCasProcessors() throws CpeDescriptorException {
        return this.casProcessors;
    }

    public void addCasProcessor(CpeCasProcessor aCasProcessor) throws CpeDescriptorException {
        if (this.casProcessors == null) {
            this.casProcessors = CpeDescriptorFactory.produceCasProcessors();
        }
        this.casProcessors.addCpeCasProcessor(aCasProcessor);
    }

    public void addCasProcessor(int index, CpeCasProcessor aCasProcessor) throws CpeDescriptorException {
        if (this.casProcessors == null) {
            this.casProcessors = CpeDescriptorFactory.produceCasProcessors();
        }
        this.casProcessors.addCpeCasProcessor(aCasProcessor, index);
    }

    public void setCpeConfiguration(CpeConfiguration aConfiguration) {
        this.cpeConfiguration = aConfiguration;
    }

    public CpeConfiguration getCpeConfiguration() throws CpeDescriptorException {
        return this.cpeConfiguration;
    }

    public void setCpeConfig(CpeConfiguration aConfiguration) {
        this.cpeConfiguration = aConfiguration;
    }

    public CpeConfiguration getCpeConfig() throws CpeDescriptorException {
        return this.cpeConfiguration;
    }

    public void setCheckpoint(String aCheckpointFile, int aFrequency) {
        if (this.cpeConfiguration != null) {
            try {
                this.cpeConfiguration.getCheckpoint().setFilePath(aCheckpointFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cpeConfiguration.getCheckpoint().setFrequency(aFrequency, true);
        }
    }

    public void setDeployment(String aDeployMode) {
        if (this.cpeConfiguration != null) {
            try {
                this.cpeConfiguration.setDeployment(aDeployMode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setNumToProcess(long aEntityCount) {
        if (this.cpeConfiguration != null) {
            try {
                this.cpeConfiguration.setNumToProcess((int)aEntityCount);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setStartingEntityId(String aStartEntityId) {
        if (this.cpeConfiguration != null) {
            try {
                this.cpeConfiguration.setStartingEntityId(aStartEntityId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setTimer(String aTimerClass) {
        if (this.cpeConfiguration != null) {
            try {
                this.cpeConfiguration.setCpeTimer(new CpeTimerImpl(aTimerClass));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CpeResourceManagerConfiguration getResourceManagerConfiguration() {
        return this.resourceMgrConfig;
    }

    protected void readUnknownPropertyValueFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions, List aKnownPropertyNames) throws InvalidXMLException {
        if (aElement.getNodeName().equals("resourceManagerConfiguration")) {
            this.resourceMgrConfig = new CpeResourceManagerConfigurationImpl();
            this.resourceMgrConfig.buildFromXMLElement(aElement, aParser, aOptions);
        } else {
            super.readUnknownPropertyValueFromXMLElement(aElement, aParser, aOptions, aKnownPropertyNames);
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

