/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.merger;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.FileUtil;

public class PMControllerHelper {
    static final String MAIN_ROOT = "$main_root";
    static final String MAIN_ROOT_REGEX = "\\$main_root";
    static final String STANDARD_PATH_SEPARATOR = ";";
    static final char STANDARD_PATH_SEPARATOR_CHAR = ';';

    private static InstallationDescriptor.ActionInfo createEnvAction(String envVarName, String envVarValue) {
        InstallationDescriptor.ActionInfo action = new InstallationDescriptor.ActionInfo("set_env_variable");
        action.params.setProperty("VAR_NAME", envVarName);
        action.params.setProperty("VAR_VALUE", envVarValue);
        return action;
    }

    private static InstallationDescriptor.ActionInfo createFileAction(String filePath, String macroPath) {
        InstallationDescriptor.ActionInfo action = new InstallationDescriptor.ActionInfo("find_and_replace_path");
        action.params.setProperty("FILE", filePath);
        action.params.setProperty("FIND_STRING", macroPath);
        action.params.setProperty("REPLACE_WITH", macroPath);
        return action;
    }

    static InstallationDescriptor generateMergedInstallationDescriptor(File rootDir, String aggCompName, File aggDescFile, InstallationDescriptor[] dlgInstDescs, File[] dlgRootDirs) throws IOException {
        File aggInsdFile = new File(rootDir, PackageBrowser.INSTALLATION_DESCRIPTOR_FILE);
        InstallationDescriptor aggInsdObject = new InstallationDescriptor(aggInsdFile);
        aggInsdObject.setMainComponent(aggCompName);
        String aggDescPath = "$main_root/" + FileUtil.getRelativePath(rootDir, aggDescFile.getAbsolutePath());
        aggInsdObject.setMainComponentDesc(aggDescPath);
        for (int i = 0; i < dlgInstDescs.length; ++i) {
            File dlgBinDir;
            InstallationDescriptor dlgInsdObject = dlgInstDescs[i];
            File dlgRootDir = dlgRootDirs[i];
            String adjMainRoot = "$main_root/" + dlgRootDir.getName();
            StringBuffer cpBuffer = new StringBuffer();
            File dlgLibDir = new File(dlgRootDir, PackageBrowser.LIBRARY_DIR);
            if (dlgLibDir.isDirectory()) {
                File[] jarFiles = dlgLibDir.listFiles(new FileUtil.ExtFilenameFilter(".jar"));
                cpBuffer.setLength(0);
                for (int n = 0; n < jarFiles.length; ++n) {
                    if (cpBuffer.length() > 0) {
                        cpBuffer.append(';');
                    }
                    cpBuffer.append(adjMainRoot + "/" + FileUtil.getRelativePath(dlgRootDir, jarFiles[n].getAbsolutePath()));
                }
                if (cpBuffer.length() > 0) {
                    aggInsdObject.addInstallationAction(PMControllerHelper.createEnvAction("CLASSPATH", cpBuffer.toString()));
                }
            }
            if ((dlgBinDir = new File(dlgRootDir, PackageBrowser.BINARY_DIR)).isDirectory()) {
                String adjBinDirPath = adjMainRoot + "/" + FileUtil.getRelativePath(dlgRootDir, dlgBinDir.getAbsolutePath());
                aggInsdObject.addInstallationAction(PMControllerHelper.createEnvAction("CLASSPATH", adjBinDirPath));
                aggInsdObject.addInstallationAction(PMControllerHelper.createEnvAction("PATH", adjBinDirPath));
            }
            Collection<InstallationDescriptor.ActionInfo> dlgInstActs = dlgInsdObject.getInstallationActions();
            Iterator<InstallationDescriptor.ActionInfo> list = dlgInstActs.iterator();
            while (list.hasNext()) {
                aggInsdObject.addInstallationAction(list.next());
            }
        }
        InstallationDescriptorHandler.saveInstallationDescriptor(aggInsdObject, aggInsdFile);
        return aggInsdObject;
    }

    static InstallationDescriptor processDescriptors(File rootDir) throws IOException {
        String adjMainRoot = "$main_root/" + rootDir.getName();
        File insdFile = new File(rootDir, "metadata/install.xml");
        FileUtil.replaceStringInFile(insdFile, MAIN_ROOT_REGEX, adjMainRoot);
        InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
        try {
            insdHandler.parse(insdFile);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        InstallationDescriptor insdObject = insdHandler.getInstallationDescriptor();
        insdObject.addInstallationAction(PMControllerHelper.createFileAction(adjMainRoot + "/" + "metadata/install.xml", MAIN_ROOT));
        PMControllerHelper.processFiles(rootDir, PackageBrowser.DESCRIPTORS_DIR, insdObject);
        PMControllerHelper.processFiles(rootDir, PackageBrowser.CONFIGURATION_DIR, insdObject);
        return insdObject;
    }

    static void processFiles(File rootDir, String targetDirName, InstallationDescriptor insdObject) throws IOException {
        String adjMainRoot = "$main_root/" + rootDir.getName();
        File targetDir = new File(rootDir, targetDirName);
        if (!targetDir.isDirectory()) {
            return;
        }
        for (File file : FileUtil.createFileList(targetDir, true)) {
            int counter = FileUtil.replaceStringInFile(file, MAIN_ROOT_REGEX, adjMainRoot);
            if (counter <= 0) continue;
            String relFilePath = FileUtil.getRelativePath(rootDir, file.getAbsolutePath());
            insdObject.addInstallationAction(PMControllerHelper.createFileAction(adjMainRoot + "/" + relFilePath, MAIN_ROOT));
        }
    }
}

