/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.internal.util.ResourcePool;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisEnginePool {
    private ResourcePool mPool;

    public AnalysisEnginePool(String aName, int aNumInstances, ResourceSpecifier aResourceSpecifier) throws ResourceInitializationException {
        this(aName, aNumInstances, aResourceSpecifier, null);
    }

    public AnalysisEnginePool(String aName, int aNumInstances, ResourceSpecifier aResourceSpecifier, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        aResourceInitParams = aResourceInitParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aResourceInitParams);
        this.mPool = new ResourcePool(aNumInstances, aResourceSpecifier, this.getResourceClass(), aResourceInitParams);
    }

    public AnalysisEngine getAnalysisEngine() {
        return (AnalysisEngine)this.mPool.getResource();
    }

    public void releaseAnalysisEngine(AnalysisEngine aAE) {
        this.mPool.releaseResource(aAE);
    }

    public AnalysisEngine getAnalysisEngine(long aTimeout) {
        return (AnalysisEngine)this.mPool.getResource(aTimeout);
    }

    public synchronized void destroy() {
        this.mPool.destroy();
    }

    public AnalysisEngineMetaData getMetaData() {
        return (AnalysisEngineMetaData)this.mPool.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSpecification(ResultSpecification aResultSpec) {
        Vector<Resource> allInstances = this.mPool.getAllInstances();
        for (int i = 0; i < this.mPool.getSize(); ++i) {
            AnalysisEngine ae = (AnalysisEngine)allInstances.get(i);
            this.mPool.checkoutSpecificResource(ae);
            try {
                ae.setResultSpecification(aResultSpec);
                continue;
            }
            finally {
                this.mPool.releaseResource(ae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reconfigure() throws ResourceConfigurationException {
        ArrayList<AnalysisEngine> toRelease = new ArrayList<AnalysisEngine>();
        try {
            for (int i = 0; i < this.mPool.getSize(); ++i) {
                AnalysisEngine ae = (AnalysisEngine)this.mPool.getResource(0L);
                toRelease.add(ae);
                ae.reconfigure();
            }
        }
        finally {
            Iterator it = toRelease.iterator();
            while (it.hasNext()) {
                this.mPool.releaseResource((Resource)it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void batchProcessComplete() throws AnalysisEngineProcessException {
        ArrayList<AnalysisEngine> toRelease = new ArrayList<AnalysisEngine>();
        try {
            for (int i = 0; i < this.mPool.getSize(); ++i) {
                AnalysisEngine ae = (AnalysisEngine)this.mPool.getResource(0L);
                toRelease.add(ae);
                ae.batchProcessComplete();
            }
        }
        finally {
            Iterator it = toRelease.iterator();
            while (it.hasNext()) {
                this.mPool.releaseResource((Resource)it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collectionProcessComplete() throws AnalysisEngineProcessException {
        ArrayList<AnalysisEngine> toRelease = new ArrayList<AnalysisEngine>();
        try {
            for (int i = 0; i < this.mPool.getSize(); ++i) {
                AnalysisEngine ae = (AnalysisEngine)this.mPool.getResource(0L);
                toRelease.add(ae);
                ae.collectionProcessComplete();
            }
        }
        finally {
            Iterator it = toRelease.iterator();
            while (it.hasNext()) {
                this.mPool.releaseResource((Resource)it.next());
            }
        }
    }

    public int getSize() {
        return this.mPool.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLogger(Logger aLogger) {
        ArrayList<AnalysisEngine> toRelease = new ArrayList<AnalysisEngine>();
        try {
            for (int i = 0; i < this.mPool.getSize(); ++i) {
                AnalysisEngine ae = (AnalysisEngine)this.mPool.getResource(0L);
                toRelease.add(ae);
                ae.setLogger(aLogger);
            }
        }
        finally {
            Iterator it = toRelease.iterator();
            while (it.hasNext()) {
                this.mPool.releaseResource((Resource)it.next());
            }
        }
    }

    protected Class<AnalysisEngine> getResourceClass() {
        return AnalysisEngine.class;
    }
}

