/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer;

import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.deployer.CPEDeployerDefaultImpl;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.ProcessControllerAdapter;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.SocketCasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.container.deployer.vinci.VinciCasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.util.XMLInputSource;

public class DeployFactory {
    public static final DeployFactory instance = new DeployFactory();

    private DeployFactory() {
    }

    public static CasProcessorDeployer getDeployer(CPEFactory aCpeFactory, CpeCasProcessor aCasProcessorConfig, ProcessControllerAdapter aPca) throws ResourceConfigurationException {
        String deployMode = aCasProcessorConfig.getDeployment();
        if ("local".equals(deployMode)) {
            return new VinciCasProcessorDeployer(aCpeFactory);
        }
        if ("remote".equals(deployMode)) {
            String protocol = DeployFactory.getProtocol(aCasProcessorConfig, aCpeFactory.getResourceManager());
            if (protocol == null || protocol.trim().length() == 0) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_service_descriptor__SEVERE", new Object[]{Thread.currentThread().getName(), "<uriSpecifier>", "<protocol>"}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_service_descriptor__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName()})));
            }
            if ("socket".equalsIgnoreCase(protocol)) {
                if (aPca == null) {
                    throw new ResourceConfigurationException("config_setting_absent", new Object[]{"ProcessControllerAdapter"});
                }
                return new SocketCasProcessorDeployer(aPca, aCpeFactory);
            }
            return new VinciCasProcessorDeployer(aCpeFactory);
        }
        if ("integrated".equals(deployMode)) {
            return new CPEDeployerDefaultImpl(aCpeFactory);
        }
        throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"deployment", "casProcessor"}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_Exception_invalid_deployment__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName(), deployMode})));
    }

    public static String getProtocol(CpeCasProcessor aCasProcessorConfig, ResourceManager aResourceManager) throws ResourceConfigurationException {
        try {
            URL clientServiceDescriptor = aCasProcessorConfig.getCpeComponentDescriptor().findAbsoluteUrl(aResourceManager);
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(clientServiceDescriptor));
            if (resourceSpecifier instanceof URISpecifier) {
                return ((URISpecifier)resourceSpecifier).getProtocol();
            }
        }
        catch (Exception e) {
            throw new ResourceConfigurationException(e);
        }
        return null;
    }
}

