/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.collection.base_cpm.CasObjectProcessor;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.SocketTransport;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParam;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.impl.ProcessingResourceMetaData_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;

public class CasObjectNetworkCasProcessorImpl
implements CasObjectProcessor {
    private SocketTransport transport = null;
    private String name = null;
    private Socket socket = null;
    private long timeout = 0L;
    private ProcessingResourceMetaData metadata = null;

    public CasObjectNetworkCasProcessorImpl(CpeCasProcessor aCasProcessor) throws ResourceConfigurationException {
        if (aCasProcessor.getDeploymentParams() != null) {
            CasProcessorDeploymentParams params = aCasProcessor.getDeploymentParams();
            try {
                CasProcessorDeploymentParam transportParameter = params.get("transport");
                this.transport = this.pluginTransport(transportParameter.getParameterValue());
            }
            catch (Exception e) {
                throw new ResourceConfigurationException("invalid_class", new Object[]{"transport"}, e);
            }
            CasProcessorDeploymentParam[] deployParameters = params.getAll();
            for (int i = 0; deployParameters != null && i < deployParameters.length; ++i) {
                try {
                    if (!"transport".equalsIgnoreCase(deployParameters[i].getParameterName())) continue;
                    String transportClass = deployParameters[i].getParameterValue();
                    this.transport = this.pluginTransport(transportClass);
                    break;
                }
                catch (Exception e) {
                    throw new ResourceConfigurationException("invalid_class", new Object[]{"transport"}, e);
                }
            }
        } else {
            throw new ResourceConfigurationException("invalid_cpe_descriptor", new Object[]{"transport"}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_transport__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        this.timeout = aCasProcessor.getErrorHandling().getTimeout().get();
        this.metadata = new ProcessingResourceMetaData_impl();
        this.name = aCasProcessor.getName();
        this.metadata.setName(this.name);
    }

    private SocketTransport pluginTransport(String aTransportClass) throws Exception {
        Object instance = Class.forName(aTransportClass).newInstance();
        if (instance instanceof SocketTransport) {
            return (SocketTransport)instance;
        }
        return null;
    }

    public URL getEndpoint() {
        if (this.socket != null) {
            try {
                return new URL("http", this.socket.getInetAddress().getHostName(), this.socket.getPort(), "");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public void connect(URL aURL) throws ResourceInitializationException {
        try {
            this.socket = this.transport.connect(aURL, this.timeout);
        }
        catch (SocketException e) {
            throw new ResourceInitializationException(e);
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        try {
            this.transport.process(this.socket, aCAS);
        }
        catch (SocketException e) {
            throw new ResourceProcessException(new ServiceConnectionException(e));
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
    }

    public void processCas(CAS[] aCASes) throws ResourceProcessException {
        try {
            for (int i = 0; i < aCASes.length; ++i) {
                this.transport.process(this.socket, aCASes[i]);
            }
        }
        catch (SocketException e) {
            throw new ResourceProcessException(new ServiceConnectionException(e));
        }
        catch (SocketTimeoutException e) {
            throw new ResourceProcessException(e);
        }
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws ResourceInitializationException {
    }

    public boolean isStateless() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        if (this.socket == null) {
            return this.metadata;
        }
        try {
            ProcessingResourceMetaData serviceMetaData = this.transport.getProcessingResourceMetaData(this.socket);
            if (serviceMetaData == null) {
                return this.metadata;
            }
            return serviceMetaData;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }
    }

    public void batchProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
    }

    public void collectionProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stopping_cp__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.socket = null;
        this.metadata = null;
    }
}

