/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.ConvertSafely;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.ComponentHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdReservation;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.JdReservationBean;
import org.apache.uima.ducc.ws.Distiller;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.DuccMachinesDataHelper;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.ReservationInfo;
import org.apache.uima.ducc.ws.cli.json.MachineFactsList;
import org.apache.uima.ducc.ws.cli.json.NodePidList;
import org.apache.uima.ducc.ws.cli.json.ReservationFacts;
import org.apache.uima.ducc.ws.cli.json.ReservationFactsList;
import org.apache.uima.ducc.ws.helper.BrokerHelper;
import org.apache.uima.ducc.ws.helper.DatabaseHelper;
import org.apache.uima.ducc.ws.registry.ServiceInterpreter;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.ServicesHelper;
import org.apache.uima.ducc.ws.registry.sort.ServicesSortCache;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccHandlerUtils;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebServerHelper;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.server.Helper;
import org.apache.uima.ducc.ws.server.HelperSpecifications;
import org.apache.uima.ducc.ws.server.IWebMonitor;
import org.apache.uima.ducc.ws.server.JsonHelper;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.apache.uima.ducc.ws.utils.HandlersHelper;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;
import org.apache.uima.ducc.ws.utils.alien.FileInfo;
import org.eclipse.jetty.server.Request;

public class DuccHandlerJsonFormat
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccHandlerJsonFormat.class);
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    private static BrokerHelper brokerHelper = BrokerHelper.getInstance();
    private static DatabaseHelper databaseHelper = DatabaseHelper.getInstance();
    private HelperSpecifications helperSpecifications = HelperSpecifications.getInstance();
    private Gson gson = new Gson();
    private static JsonHelper jh = new JsonHelper();
    private final String jsonFormatJobsAaData = "/ducc-servlet/json-format-aaData-jobs";
    private final String jsonFormatReservationsAaData = "/ducc-servlet/json-format-aaData-reservations";
    private final String jsonFormatServicesAaData = "/ducc-servlet/json-format-aaData-services";
    private final String jsonFormatMachinesAaData = "/ducc-servlet/json-format-aaData-machines";
    private final String jsonFormatBrokerAaData = "/ducc-servlet/json-format-aaData-broker";
    private final String jsonFormatClassesAaData = "/ducc-servlet/json-format-aaData-classes";
    private final String jsonFormatDaemonsAaData = "/ducc-servlet/json-format-aaData-daemons";
    private final String jsonFormatDaemonsAaDataAll = "/ducc-servlet/json-format-aaData-daemons-all";
    private final String jsonFormatJobProcessesData = "/ducc-servlet/json-format-job-processes";
    private final String jsonFormatJobSpecificationData = "/ducc-servlet/json-format-job-specification";
    private final String jsonFormatManagedReservationSpecificationData = "/ducc-servlet/json-format-managed-reservation-specification";
    private final String jsonFormatMachines = "/ducc-servlet/json-format-machines";
    private final String jsonFormatReservations = "/ducc-servlet/json-format-reservations";
    private static DecimalFormat formatter1 = new DecimalFormat("##0.0");
    private static DecimalFormat formatter3 = new DecimalFormat("##0.000");

    public DuccHandlerJsonFormat(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    public String getFileName() {
        return this.dir_home + File.separator + this.dir_resources + File.separator + this.getDuccWebServer().getClassDefinitionFile();
    }

    private JsonArray buildJobRow(HttpServletRequest request, IDuccWorkJob job, DuccData duccData, long now, ServicesRegistry servicesRegistry) {
        String decoratedDuration;
        String duration;
        EffectiveUser eu = EffectiveUser.create(request);
        JsonArray row = new JsonArray();
        DuccId duccId = job.getDuccId();
        StringBuffer sb = new StringBuffer();
        String id = this.normalize(duccId);
        sb.append("<span class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !job.isFinished()) {
            sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_job(" + id + ")\" value=\"Terminate\" " + this.getDisabledWithHover(request, (IDuccWork)job) + "/>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append("<a href=\"job.details.html?id=" + id + "\">" + id + "</a>");
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, job.getDuccId(), job.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        if (job.isCompleted()) {
            duration = this.getDuration(request, (IDuccWork)job, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span>");
            sb.append(decoratedDuration);
            sb.append("</span>");
        } else {
            duration = this.getDuration(request, (IDuccWork)job, now, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span class=\"health_green\">");
            sb.append(decoratedDuration);
            sb.append("</span>");
            String projection = this.getProjection(request, job, FormatHelper.Precision.Whole);
            sb.append(projection);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String title = "";
        String submitter = job.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\" ";
        }
        sb.append("<span " + title + ">");
        sb.append(job.getStandardInfo().getUser());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String schedulingClass = this.stringNormalize(job.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"));
        long debugPortDriver = job.getDebugPortDriver();
        long debugPortProcess = job.getDebugPortProcess();
        title = "debug ports:";
        if (debugPortDriver >= 0L) {
            title = title + " driver=" + debugPortDriver;
        }
        if (debugPortProcess >= 0L) {
            title = title + " process=" + debugPortProcess;
        }
        switch (DuccCookies.getDisplayStyle(request)) {
            default: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\">DEBUG</div>");
                sb.append("</span>");
                break;
            }
            case Visual: {
                String key = "bug";
                String bugFile = DuccWebServerHelper.getImageFileName(key);
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                if (bugFile != null) {
                    sb.append("<div title=\"" + title + "\"><img src=\"" + bugFile + "\"></div>");
                }
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String state = job.getStateObject().toString();
        sb.append("<span>");
        if (duccData.isLive(duccId)) {
            if (job.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
            sb.append(state);
            sb.append("</span>");
        } else {
            sb.append("<span class=\"historic_state\">");
            sb.append(state);
            sb.append("</span>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = this.getReason(job, IWebMonitor.MonitorType.Job);
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append(this.evaluateServices(job, servicesRegistry));
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (duccData.isLive(duccId)) {
            sb.append(job.getProcessMap().getAliveProcessCount());
        } else {
            sb.append("0");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        long initFails = job.getProcessInitFailureCount();
        if (initFails > 0L) {
            if (job.getSchedulingInfo().getLongProcessesMax() < 0L) {
                DuccCookies.DisplayStyle style = DuccCookies.getDisplayStyle(request);
                String key = "cap.small";
                String capFile = DuccWebServerHelper.getImageFileName(key);
                switch (style) {
                    case Visual: {
                        if (capFile != null) break;
                        style = DuccCookies.DisplayStyle.Textual;
                        break;
                    }
                }
                switch (style) {
                    default: {
                        sb.append(this.buildInitializeFailuresLink(job));
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<sup>");
                        sb.append("<small>");
                        sb.append("capped");
                        sb.append("</small>");
                        sb.append("<sup>");
                        sb.append("</span>");
                        sb.append("<br>");
                        break;
                    }
                    case Visual: {
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<img src=\"" + capFile + "\">");
                        sb.append("</span>");
                        sb.append("<br>");
                        sb.append(this.buildInitializeFailuresLink(job));
                        break;
                    }
                }
            } else {
                sb.append(this.buildInitializeFailuresLink(job));
            }
        } else {
            sb.append("" + initFails);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(this.buildRuntimeFailuresLink(job));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        long faults = 0L;
        try {
            faults = job.getPgInCount();
        }
        catch (Exception capFile) {
            // empty catch block
        }
        int ifaults = (int)faults;
        switch (ifaults) {
            case -3: {
                sb.append("<span title=\"incomplete\" class=\"health_red\">");
                sb.append("INC");
                break;
            }
            case -2: {
                sb.append("<span title=\"incomplete\" class=\"health_black\">");
                sb.append("INC");
                break;
            }
            case -1: {
                sb.append("<span title=\"not available\" class=\"health_black\">");
                sb.append(this.notAvailable);
                break;
            }
            default: {
                double swapping = job.getSwapUsageGbMax();
                if (swapping * (double)faults > 0.0) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_black\">");
                }
                sb.append(faults);
            }
        }
        sb.append("</span>");
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        String swapSizeDisplay = "";
        String swapSizeHover = "";
        title = "";
        double swap = 0.0;
        swap = job.isCompleted() ? job.getSwapUsageGbMax() : job.getSwapUsageGb();
        int iswap = (int)swap;
        switch (iswap) {
            case -3: {
                sb.append("<span title=\"incomplete\" class=\"health_red\">");
                sb.append("INC");
                break;
            }
            case -2: {
                sb.append("<span title=\"incomplete\" class=\"health_black\">");
                sb.append("INC");
                break;
            }
            case -1: {
                sb.append("<span title=\"not available\" class=\"health_black\">");
                sb.append(this.notAvailable);
                break;
            }
            default: {
                double swapBytes = swap * DuccHandlerUtils.GB;
                swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                title = "title=\"" + swapSizeHover + "\"";
                if (swapBytes > 0.0) {
                    sb.append("<span " + title + " class=\"health_red\">");
                } else {
                    sb.append("<span " + title + " class=\"health_black\">");
                }
                sb.append(swapSizeDisplay);
            }
        }
        sb.append("</span>");
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        IDuccSchedulingInfo si = job.getSchedulingInfo();
        SizeBytes sizeBytes = new SizeBytes(SizeBytes.Type.Bytes, si.getMemorySizeAllocatedInBytes());
        String actual = this.getProcessMemorySize(duccId, sizeBytes);
        sizeBytes = new SizeBytes(si.getMemoryUnits().name(), Long.parseLong(si.getMemorySizeRequested()));
        String requested = this.getProcessMemorySize(duccId, sizeBytes);
        sb.append("<span title=\"requested: " + requested + "\">");
        sb.append(actual);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsTotal());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        IDuccPerWorkItemStatistics perWorkItemStatistics = job.getSchedulingInfo().getPerWorkItemStatistics();
        String done = job.getSchedulingInfo().getWorkItemsCompleted();
        if (perWorkItemStatistics != null) {
            double max = (double)Math.round(perWorkItemStatistics.getMax() / 100.0) / 10.0;
            double min = (double)Math.round(perWorkItemStatistics.getMin() / 100.0) / 10.0;
            double avg = (double)Math.round(perWorkItemStatistics.getMean() / 100.0) / 10.0;
            double dev = (double)Math.round(perWorkItemStatistics.getStandardDeviation() / 100.0) / 10.0;
            done = "<span title=\"seconds-per-work-item Max:" + max + " Min:" + min + " Avg:" + avg + " StdDev:" + dev + "\">" + done + "</span>";
        }
        sb.append(done);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(this.buildErrorLink(eu, job));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String d0 = "<span>";
        String d1 = "0";
        String d2 = "</span>";
        if (duccData.isLive(duccId)) {
            int dispatch = 0;
            int unassigned = job.getSchedulingInfo().getCasQueuedMap().size();
            try {
                dispatch = Integer.parseInt(job.getSchedulingInfo().getWorkItemsDispatched()) - unassigned;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dispatch < 0) {
                d0 = "<span class=\"health_red\" title=\"unassigned location count: " + (0 - dispatch) + "\">";
            } else {
                d1 = "" + dispatch;
            }
        }
        sb.append(d0);
        sb.append(d1);
        sb.append(d2);
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsRetry());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsPreempt());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String description = this.stringNormalize(job.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        return row;
    }

    private void handleServletJsonFormatJobsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatJobsAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        long now = System.currentTimeMillis();
        int maxRecords = this.getJobsMax(request);
        ArrayList<String> users = this.getJobsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = duccData.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, (IDuccWork)job);
                if (!list) continue;
                ++counter;
                JsonArray row = this.buildJobRow(request, (IDuccWorkJob)job, duccData, now, servicesRegistry);
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            if (DuccData.getInstance().isPublished()) {
                row.add((JsonElement)new JsonPrimitive("no jobs"));
            } else {
                row.add((JsonElement)new JsonPrimitive("no data"));
            }
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private JsonHelper.JobProcess create(DuccWorkJob job, IDuccProcess process, Helper.AllocationType type, Map<String, FileInfo> fileInfoMap) {
        JsonHelper.JobProcess jsonProcess = new JsonHelper.JobProcess(jh);
        jsonProcess.process_number = "" + process.getDuccId().getFriendly();
        jsonProcess.log_file = Helper.getLogFileName((IDuccWorkJob)job, process, type);
        jsonProcess.log_size = Helper.getLogFileSize((IDuccWorkJob)job, process, jsonProcess.log_file, fileInfoMap);
        jsonProcess.host_name = Helper.getHostname((IDuccWorkJob)job, process);
        jsonProcess.pid = Helper.getPid((IDuccWorkJob)job, process);
        jsonProcess.scheduler_state = Helper.getSchedulerState((IDuccWorkJob)job, process);
        jsonProcess.scheduler_state_reason = Helper.getSchedulerReason((IDuccWorkJob)job, process);
        jsonProcess.agent_state = Helper.getAgentState((IDuccWorkJob)job, process);
        jsonProcess.agent_state_reason = Helper.getAgentReason((IDuccWorkJob)job, process);
        jsonProcess.exit = Helper.getExit((IDuccWorkJob)job, process);
        jsonProcess.time_init = Helper.getTimeInit((IDuccWorkJob)job, process, type);
        jsonProcess.time_run = Helper.getTimeRun((IDuccWorkJob)job, process, type);
        jsonProcess.time_gc = Helper.getTimeGC((IDuccWorkJob)job, process, type);
        jsonProcess.swap = Helper.getSwap((IDuccWorkJob)job, process, type);
        jsonProcess.swap_max = Helper.getSwapMax((IDuccWorkJob)job, process, type);
        jsonProcess.pct_cpu_overall = Helper.getPctCpuOverall((IDuccWorkJob)job, process, type);
        jsonProcess.pct_cpu_current = Helper.getPctCpuCurrent((IDuccWorkJob)job, process, type);
        jsonProcess.rss = Helper.getRss((IDuccWorkJob)job, process, type);
        jsonProcess.rss_max = Helper.getRssMax((IDuccWorkJob)job, process, type);
        jsonProcess.wi_time_avg = Helper.getWiTimeAvg((IDuccWorkJob)job, process, type);
        jsonProcess.wi_time_max = Helper.getWiTimeMax((IDuccWorkJob)job, process, type);
        jsonProcess.wi_time_min = Helper.getWiTimeMin((IDuccWorkJob)job, process, type);
        jsonProcess.wi_done = Helper.getWiDone((IDuccWorkJob)job, process, type);
        jsonProcess.wi_error = Helper.getWiError((IDuccWorkJob)job, process, type);
        jsonProcess.wi_dispatch = Helper.getWiDispatch((IDuccWorkJob)job, process, type);
        jsonProcess.wi_retry = Helper.getWiRetry((IDuccWorkJob)job, process, type);
        jsonProcess.wi_preempt = Helper.getWiPreempt((IDuccWorkJob)job, process, type);
        jsonProcess.jconsole_url = Helper.getJConsoleUrl((IDuccWorkJob)job, process, type);
        return jsonProcess;
    }

    private void handleServletJsonFormatJobProcessesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatJobProcessesData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        EffectiveUser eu = EffectiveUser.create(request);
        DuccWorkJob job = null;
        String jobno = request.getParameter("id");
        if (jobno != null) {
            IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
            if (duccWorkMap.getJobKeySet().size() > 0) {
                Iterator iterator = null;
                for (DuccId jobId : duccWorkMap.getJobKeySet()) {
                    String fid = "" + jobId.getFriendly();
                    if (!jobno.equals(fid)) continue;
                    job = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                    break;
                }
            }
        } else {
            jobno = "id=?";
        }
        JsonHelper.JobProcessList jpl = new JsonHelper.JobProcessList(jh);
        jpl.log_directory = Helper.getLogFileDirectory(job);
        jpl.set_job_number(jobno);
        if (job != null) {
            JsonHelper.JobProcess jsonJobProcess;
            IDuccProcess duccProcess;
            String directory = job.getLogDirectory() + File.separator + job.getId();
            Map<String, FileInfo> fileInfoMap = Helper.getFileInfoMap(eu, directory);
            Iterator iterator = null;
            for (DuccId processId : job.getDriver().getProcessMap().keySet()) {
                duccProcess = (IDuccProcess)job.getDriver().getProcessMap().get((Object)processId);
                jsonJobProcess = this.create(job, duccProcess, Helper.AllocationType.JD, fileInfoMap);
                jpl.addJobProcess(jsonJobProcess);
            }
            for (DuccId processId : job.getProcessMap().keySet()) {
                duccProcess = (IDuccProcess)job.getProcessMap().get((Object)processId);
                jsonJobProcess = this.create(job, duccProcess, Helper.AllocationType.UIMA, fileInfoMap);
                jpl.addJobProcess(jsonJobProcess);
            }
        }
        String json = jpl.toJson();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatJobSpecificationData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatJobSpecificationData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        String json = "{}";
        String jobNo = request.getParameter("id");
        duccLogger.debug(methodName, jobid, new Object[]{"jobNo=" + jobNo});
        if (jobNo == null) {
            response.setStatus(400);
        } else {
            DuccWorkJob dwj = Helper.getJob(jobNo);
            duccLogger.debug(methodName, jobid, new Object[]{"dwj=" + dwj});
            if (dwj == null) {
                response.setStatus(404);
            } else {
                String resOwner = dwj.getStandardInfo().getUser();
                duccLogger.debug(methodName, jobid, new Object[]{"resOwner=" + resOwner});
                if (resOwner == null) {
                    response.setStatus(204);
                } else {
                    Map<String, Properties> properties;
                    EffectiveUser eu = EffectiveUser.create(request);
                    String reqUser = eu.get();
                    duccLogger.debug(methodName, jobid, new Object[]{"reqUser=" + reqUser});
                    if (reqUser == null) {
                        response.setStatus(406);
                    } else if (HandlersHelper.isResourceAuthorized(resOwner, reqUser) && (properties = this.helperSpecifications.getJobSpecificationProperties(dwj, eu)) != null && !properties.isEmpty()) {
                        properties = this.helperSpecifications.convertAllToSystem(properties);
                        json = this.gson.toJson(properties);
                    }
                }
            }
        }
        duccLogger.debug(methodName, jobid, new Object[]{"json=" + json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatManagedReservationSpecificationData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatManagedReservationSpecificationData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        String json = "{}";
        String resNo = request.getParameter("id");
        duccLogger.debug(methodName, jobid, new Object[]{"resNo=" + resNo});
        if (resNo == null) {
            response.setStatus(400);
        } else {
            DuccWorkJob mr = Helper.getManagedReservation(resNo);
            duccLogger.debug(methodName, jobid, new Object[]{"mr=" + mr});
            if (mr == null) {
                response.setStatus(404);
            } else {
                String resOwner = mr.getStandardInfo().getUser();
                duccLogger.debug(methodName, jobid, new Object[]{"resOwner=" + resOwner});
                if (resOwner == null) {
                    response.setStatus(204);
                } else {
                    Map<String, Properties> properties;
                    EffectiveUser eu = EffectiveUser.create(request);
                    String reqUser = eu.get();
                    duccLogger.debug(methodName, jobid, new Object[]{"reqUser=" + reqUser});
                    if (reqUser == null) {
                        response.setStatus(406);
                    } else if (HandlersHelper.isResourceAuthorized(resOwner, reqUser) && (properties = this.helperSpecifications.getManagedReservationSpecificationProperties(mr, eu)) != null && !properties.isEmpty()) {
                        properties = this.helperSpecifications.convertAllToSystem(properties);
                        json = this.gson.toJson(properties);
                    }
                }
            }
        }
        duccLogger.debug(methodName, jobid, new Object[]{"json=" + json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private JsonArray buildReservationRow(HttpServletRequest request, IDuccWork duccwork, DuccData duccData, long now) {
        DuccWorkJob job;
        Object rationale;
        Object jdReservation;
        UserId userId;
        String title;
        StringBuffer sb;
        DuccId duccId;
        JsonArray row;
        block83: {
            block82: {
                String decoratedDuration;
                String duration;
                row = new JsonArray();
                String reservationType = "Unmanaged";
                if (duccwork instanceof DuccWorkJob) {
                    reservationType = "Managed";
                }
                duccId = duccwork.getDuccId();
                sb = new StringBuffer();
                String id = this.normalize(duccId);
                sb.append("<span class=\"ducc-col-terminate\">");
                if (this.terminateEnabled && !duccwork.isCompleted()) {
                    DuccPropertiesResolver dpr;
                    String jdHostUser;
                    String disabled = this.getDisabledWithHover(request, duccwork);
                    String user = duccwork.getStandardInfo().getUser();
                    if (user != null && user.equals(jdHostUser = (dpr = DuccPropertiesResolver.getInstance()).getCachedProperty("ducc.jd.host.user"))) {
                        disabled = "disabled=\"disabled\"";
                    }
                    sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_reservation(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
                }
                sb.append("</span>");
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                if (reservationType.equals("Managed")) {
                    sb.append("<span>");
                    sb.append("<a href=\"reservation.details.html?id=" + id + "\">" + id + "</a>");
                    sb.append("</span>");
                } else {
                    sb.append("<span>");
                    sb.append(id);
                    sb.append("</span>");
                }
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
                sb.append(this.getTimeStamp(request, duccwork.getDuccId(), duccwork.getStandardInfo().getDateOfSubmission()));
                sb.append("</span>");
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                if (duccwork instanceof DuccWorkReservation) {
                    DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
                    switch (reservation.getReservationState()) {
                        case Completed: {
                            sb.append("<span>");
                            duration = this.getDuration(request, (IDuccWork)reservation, FormatHelper.Precision.Whole);
                            decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                            sb.append(decoratedDuration);
                            sb.append("</span>");
                            break;
                        }
                        default: {
                            sb.append("<span class=\"health_green\">");
                            duration = this.getDuration(request, (IDuccWork)reservation, now, FormatHelper.Precision.Whole);
                            decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                            sb.append(decoratedDuration);
                            sb.append("</span>");
                            break;
                        }
                    }
                } else if (duccwork instanceof DuccWorkJob) {
                    DuccWorkJob job2 = (DuccWorkJob)duccwork;
                    switch (job2.getJobState()) {
                        case Completed: {
                            sb.append("<span>");
                            duration = this.getDuration(request, (IDuccWork)job2, FormatHelper.Precision.Whole);
                            decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job2, duration, FormatHelper.Precision.Whole);
                            sb.append(decoratedDuration);
                            sb.append("</span>");
                            break;
                        }
                        default: {
                            sb.append("<span class=\"health_green\">");
                            duration = this.getDuration(request, (IDuccWork)job2, now, FormatHelper.Precision.Whole);
                            decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job2, duration, FormatHelper.Precision.Whole);
                            sb.append(decoratedDuration);
                            sb.append("</span>");
                        }
                    }
                }
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                title = "";
                String submitter = duccwork.getStandardInfo().getSubmitter();
                if (submitter != null) {
                    title = "title=\"submitter PID@host: " + submitter + "\"";
                }
                sb.append("<span " + title + ">");
                userId = new UserId(duccwork.getStandardInfo().getUser());
                sb.append(userId.toString());
                sb.append("</span>");
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                row.add((JsonElement)new JsonPrimitive(this.stringNormalize(duccwork.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"))));
                sb = new StringBuffer();
                sb.append(reservationType);
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                String state = duccwork.getStateObject().toString();
                sb.append("<span>");
                if (duccData.isLive(duccId)) {
                    if (duccwork.isOperational()) {
                        sb.append("<span class=\"active_state\">");
                    } else {
                        sb.append("<span class=\"completed_state\">");
                    }
                    sb.append(state);
                    sb.append("</span>");
                } else {
                    sb.append("<span class=\"historic_state\">");
                    sb.append(state);
                    sb.append("</span>");
                }
                sb.append("</span>");
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                sb = new StringBuffer();
                if (!(duccwork instanceof DuccWorkReservation)) break block82;
                DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
                block8 : switch (reservation.getReservationState()) {
                    case WaitingForResources: {
                        String rmReason = reservation.getRmReason();
                        if (rmReason != null) {
                            sb.append("<span>");
                            sb.append(rmReason);
                            sb.append("</span>");
                            break;
                        }
                        break block83;
                    }
                    case Assigned: {
                        List list = reservation.getJdReservationBeanList();
                        long inuse = 0L;
                        long total = 0L;
                        if (list != null) {
                            for (JdReservationBean jdReservationBean : list) {
                                jdReservation = (JdReservation)jdReservationBean;
                                inuse += jdReservation.getSlicesInuse().longValue();
                                total += jdReservation.getSlicesTotal().longValue();
                            }
                            title = "title=\"the number of job driver allocations inuse for this reservation\"";
                            sb.append("<span " + title + ">");
                            sb.append("inuse: " + inuse);
                            sb.append("</span>");
                            sb.append(" ");
                            title = "title=\"the number of job driver allocations maximum capacity for this reservation\"";
                            sb.append("<span " + title + ">");
                            sb.append("limit: " + total);
                            sb.append("</span>");
                            break;
                        }
                        break block83;
                    }
                    default: {
                        switch (reservation.getCompletionType()) {
                            case Undefined: {
                                break block8;
                            }
                            case CanceledByUser: 
                            case CanceledByAdmin: {
                                try {
                                    String cancelUser = duccwork.getStandardInfo().getCancelUser();
                                    if (cancelUser != null) {
                                        sb.append("<span title=\"canceled by " + cancelUser + "\">");
                                        sb.append(duccwork.getCompletionTypeObject().toString());
                                        sb.append("</span>");
                                        break block8;
                                    }
                                    rationale = reservation.getCompletionRationale();
                                    if (rationale != null) {
                                        sb.append("<span title=" + rationale.getTextQuoted() + ">");
                                        sb.append(duccwork.getCompletionTypeObject().toString());
                                        sb.append("</span>");
                                        break block8;
                                    }
                                    sb.append(duccwork.getCompletionTypeObject().toString());
                                }
                                catch (Exception e) {
                                    rationale = reservation.getCompletionRationale();
                                    if (rationale != null) {
                                        sb.append("<span title=" + rationale.getTextQuoted() + ">");
                                        sb.append(duccwork.getCompletionTypeObject().toString());
                                        sb.append("</span>");
                                        break block8;
                                    }
                                    sb.append(duccwork.getCompletionTypeObject().toString());
                                }
                                break block8;
                            }
                        }
                        IRationale rationale2 = reservation.getCompletionRationale();
                        if (rationale2 != null) {
                            sb.append("<span title=" + rationale2.getTextQuoted() + ">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        sb.append(duccwork.getCompletionTypeObject().toString());
                        break;
                    }
                }
                break block83;
            }
            if (duccwork instanceof DuccWorkJob) {
                DuccWorkJob job3 = (DuccWorkJob)duccwork;
                sb = this.getReason((IDuccWorkJob)job3, IWebMonitor.MonitorType.ManagedReservation);
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        TreeMap<String, Integer> nodeMap = new TreeMap<String, Integer>();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            if (!reservation.getReservationMap().isEmpty()) {
                IDuccReservationMap map = reservation.getReservationMap();
                for (DuccId key : map.keySet()) {
                    IDuccReservation value = (IDuccReservation)reservation.getReservationMap().get((Object)key);
                    String node = value.getNodeIdentity().getName();
                    if (!nodeMap.containsKey(node)) {
                        nodeMap.put(node, new Integer(0));
                    }
                    Integer count = (Integer)nodeMap.get(node);
                    rationale = count;
                    count = count + 1;
                    jdReservation = count;
                    nodeMap.put(node, count);
                }
            }
            boolean qualify = false;
            if (!nodeMap.isEmpty() && nodeMap.keySet().size() > 1) {
                qualify = true;
            }
            ArrayList<String> qualifiedPids = new ArrayList<String>();
            if (duccwork.isOperational()) {
                DuccMachinesData machinesData = DuccMachinesData.getInstance();
                for (String node : nodeMap.keySet()) {
                    NodeId nodeId = new NodeId(node);
                    List<String> nodePids = machinesData.getPids(nodeId, userId);
                    for (String pid : nodePids) {
                        if (qualify) {
                            qualifiedPids.add(node + ":" + pid);
                            continue;
                        }
                        qualifiedPids.add(pid);
                    }
                }
            }
            if (qualifiedPids.size() > 0) {
                String list = "";
                for (String entry : qualifiedPids) {
                    list = list + entry + " ";
                }
                sb.append("<span title=\"" + list.trim() + "\">");
                sb.append("" + qualifiedPids.size());
                sb.append("</span>");
            } else {
                sb.append("" + qualifiedPids.size());
            }
        } else {
            job = (DuccWorkJob)duccwork;
            if (job.isOperational()) {
                sb.append(duccwork.getSchedulingInfo().getInstancesCount());
            } else {
                sb.append("0");
            }
            for (DuccId processId : job.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)job.getProcessMap().get((Object)processId);
                String node = process.getNodeIdentity().getName();
                nodeMap.put(node, 1);
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (duccwork instanceof DuccWorkJob) {
            job = (DuccWorkJob)duccwork;
            long faults = 0L;
            try {
                faults = job.getPgInCount();
            }
            catch (Exception process) {
                // empty catch block
            }
            int ifaults = (int)faults;
            switch (ifaults) {
                case -3: {
                    sb.append("<span title=\"incomplete\" class=\"health_red\">");
                    sb.append("INC");
                    break;
                }
                case -2: {
                    sb.append("<span title=\"incomplete\" class=\"health_black\">");
                    sb.append("INC");
                    break;
                }
                case -1: {
                    sb.append("<span title=\"not available\" class=\"health_black\">");
                    sb.append(this.notAvailable);
                    break;
                }
                default: {
                    double swapping = job.getSwapUsageGbMax();
                    if (swapping * (double)faults > 0.0) {
                        sb.append("<span class=\"health_red\">");
                    } else {
                        sb.append("<span class=\"health_black\">");
                    }
                    sb.append(faults);
                }
            }
            sb.append("</span>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (duccwork instanceof DuccWorkJob) {
            job = (DuccWorkJob)duccwork;
            String swapSizeDisplay = "";
            String swapSizeHover = "";
            title = "";
            double swap = 0.0;
            swap = job.isCompleted() ? job.getSwapUsageGbMax() : job.getSwapUsageGb();
            int iswap = (int)swap;
            switch (iswap) {
                case -3: {
                    sb.append("<span title=\"incomplete\" class=\"health_red\">");
                    sb.append("INC");
                    break;
                }
                case -2: {
                    sb.append("<span title=\"incomplete\" class=\"health_black\">");
                    sb.append("INC");
                    break;
                }
                case -1: {
                    sb.append("<span title=\"not available\" class=\"health_black\">");
                    sb.append(this.notAvailable);
                    break;
                }
                default: {
                    double swapBytes = swap * DuccHandlerUtils.GB;
                    swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                    swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                    title = "title=\"" + swapSizeHover + "\"";
                    if (swapBytes > 0.0) {
                        sb.append("<span " + title + " class=\"health_red\">");
                    } else {
                        sb.append("<span " + title + " class=\"health_black\">");
                    }
                    sb.append(swapSizeDisplay);
                }
            }
            sb.append("</span>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        IDuccSchedulingInfo si = duccwork.getSchedulingInfo();
        SizeBytes sizeBytes = new SizeBytes(SizeBytes.Type.Bytes, si.getMemorySizeAllocatedInBytes());
        String actual = this.getProcessMemorySize(duccId, sizeBytes);
        sizeBytes = new SizeBytes(si.getMemoryUnits().name(), Long.parseLong(si.getMemorySizeRequested()));
        String requested = this.getProcessMemorySize(duccId, sizeBytes);
        sb.append("<span title=\"requested: " + requested + "\">");
        sb.append(actual);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (!nodeMap.isEmpty()) {
            boolean useList = false;
            if (nodeMap.size() > 1) {
                useList = true;
            }
            if (useList) {
                sb.append("<select>");
            }
            Iterator iswap = nodeMap.keySet().iterator();
            while (iswap.hasNext()) {
                String node;
                String option = node = (String)iswap.next();
                Integer count = (Integer)nodeMap.get(node);
                if (count > 1) {
                    option = option + " [" + count + "]";
                }
                if (useList) {
                    sb.append("<option>");
                }
                sb.append(option);
                if (!useList) continue;
                sb.append("</option>");
            }
            if (useList) {
                sb.append("</select>");
            }
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String description = this.stringNormalize(duccwork.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        return row;
    }

    private void handleServletJsonFormatReservationsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatReservationsAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        int maxRecords = this.getReservationsMax(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = duccData.getSortedCombinedReservations();
        ArrayList<String> users = this.getReservationsUsers(request);
        long now = System.currentTimeMillis();
        if (sortedCombinedReservations.size() > 0) {
            int counter = 0;
            Iterator<Map.Entry<Info, Info>> iR = sortedCombinedReservations.entrySet().iterator();
            while (iR.hasNext()) {
                JsonArray row;
                Info info = iR.next().getValue();
                IDuccWork dw = info.getDuccWork();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, dw);
                if (!list) continue;
                ++counter;
                if (dw instanceof DuccWorkReservation) {
                    DuccWorkReservation reservation = (DuccWorkReservation)dw;
                    row = this.buildReservationRow(request, (IDuccWork)reservation, duccData, now);
                    data.add((JsonElement)row);
                    continue;
                }
                if (!(dw instanceof DuccWorkJob)) continue;
                DuccWorkJob job = (DuccWorkJob)dw;
                row = this.buildReservationRow(request, (IDuccWork)job, duccData, now);
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            if (DuccData.getInstance().isPublished()) {
                row.add((JsonElement)new JsonPrimitive("no reservations"));
            } else {
                row.add((JsonElement)new JsonPrimitive("no data"));
            }
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatServicesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatServicesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        ServicesSortCache servicesSortCache = ServicesSortCache.getInstance();
        Collection<IServiceAdapter> servicesSortedCollection = servicesSortCache.getSortedCollection();
        if (!servicesSortedCollection.isEmpty()) {
            int maxRecords = this.getServicesMax(request);
            ArrayList<String> users = this.getServicesUsers(request);
            int counter = 0;
            for (IServiceAdapter service : servicesSortedCollection) {
                String schedulingClass;
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, service);
                if (!list) continue;
                ++counter;
                JsonArray row = new JsonArray();
                int sid = service.getId();
                String user = service.getUser();
                long deployments = service.getDeployments();
                long instances = service.getInstances();
                StringBuffer col = new StringBuffer();
                col.append("<span class=\"ducc-col-start\">");
                if (service.isRegistered() && this.buttonsEnabled && service.isDisabled()) {
                    col.append("<input type=\"button\" onclick=\"ducc_confirm_service_enable(" + sid + ")\" value=\"Enable\" " + this.getDisabledWithHover(request, user) + "/>");
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span class=\"ducc-col-stop\">");
                if (service.isRegistered() && this.buttonsEnabled) {
                    if (service.isPingOnly()) {
                        if (service.isPingActive()) {
                            col.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                        }
                    } else if (deployments != 0L) {
                        col.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                    }
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String name = service.getName();
                col.append("<span>");
                String id = "<a href=\"service.details.html?name=" + name + "\">" + sid + "</a>";
                col.append("" + id);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span>");
                col.append(name);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String state = service.getState();
                boolean alert = service.isAlert();
                boolean available = service.isStateAvailable();
                if (alert) {
                    state = state + "+Alert";
                }
                String style = "class=\"health_black\";";
                if (alert) {
                    style = "class=\"health_red\"";
                } else if (available) {
                    style = "class=\"health_green\"";
                }
                String stateHover = ServicesHelper.getInstance().getStateHover(service);
                if (stateHover.length() > 0) {
                    stateHover = "title=\"" + stateHover + "\"";
                }
                col.append("<span " + style + " " + stateHover + ">");
                col.append(state);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                long lastUse = service.getLastUse();
                if (lastUse > 0L) {
                    col.append(this.getTimeStamp(request, jobid, "" + lastUse));
                }
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + instances);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + deployments);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ServiceInterpreter.StartState startState = service.getStartState();
                col.append("<span>");
                col.append(startState.name());
                if (service.isDisabled()) {
                    col.append("<br>");
                    String health = "class=\"health_red\"";
                    String reason = "title=\"" + service.getDisableReason() + "\"";
                    col.append("<span " + health + " " + reason + ">");
                    col.append("Disabled");
                    col.append("</span>");
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + user);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                if (service.isPingOnly()) {
                    schedulingClass = "" + service.getSchedulingClass();
                    col.append("<span title=\"" + schedulingClass + "\">");
                    String serviceType = "ping-only";
                    col.append("<span>");
                    col.append(serviceType);
                } else {
                    schedulingClass = service.getSchedulingClass();
                    col.append("" + schedulingClass);
                }
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span>");
                long faults = 0L;
                try {
                    faults = service.getPgIn();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int ifaults = (int)faults;
                switch (ifaults) {
                    case -3: {
                        col.append("<span title=\"incomplete\" class=\"health_red\">");
                        col.append("INC");
                        break;
                    }
                    case -2: {
                        col.append("<span title=\"incomplete\" class=\"health_black\">");
                        col.append("INC");
                        break;
                    }
                    case -1: {
                        col.append("<span title=\"not available\" class=\"health_black\">");
                        col.append(this.notAvailable);
                        break;
                    }
                    default: {
                        double swapping = service.getSwap();
                        if (swapping * (double)faults > 0.0) {
                            col.append("<span class=\"health_red\">");
                        } else {
                            col.append("<span class=\"health_black\">");
                        }
                        col.append(faults);
                    }
                }
                col.append("</span>");
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span>");
                String swapSizeDisplay = "";
                String swapSizeHover = "";
                String title = "";
                double swap = service.getSwap();
                int iswap = (int)swap;
                switch (iswap) {
                    case -3: {
                        col.append("<span title=\"incomplete\" class=\"health_red\">");
                        col.append("INC");
                        break;
                    }
                    case -2: {
                        col.append("<span title=\"incomplete\" class=\"health_black\">");
                        col.append("INC");
                        break;
                    }
                    case -1: {
                        col.append("<span title=\"not available\" class=\"health_black\">");
                        col.append(this.notAvailable);
                        break;
                    }
                    default: {
                        double swapBytes = swap;
                        swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                        swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                        title = "title=\"" + swapSizeHover + "\"";
                        if (swapBytes > 0.0) {
                            col.append("<span " + title + " class=\"health_red\">");
                        } else {
                            col.append("<span " + title + " class=\"health_black\">");
                        }
                        col.append(swapSizeDisplay);
                    }
                }
                col.append("</span>");
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                long size = service.getSize();
                if (size < 0L) {
                    size = 0L;
                }
                col.append(size);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentJobs = service.getDependentJobs();
                int countDependentJobs = dependentJobs.size();
                String titleJobs = "";
                if (countDependentJobs > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentJobs) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleJobs = "dependent Job Id list: " + idList;
                }
                String jobs = "<span title=\"" + titleJobs + "\">" + countDependentJobs + "</span>";
                col.append(jobs);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentServices = service.getDependentServices();
                int countDependentServices = dependentServices.size();
                String titleServices = "";
                if (countDependentServices > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentServices) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleServices = "dependent Service Name list: " + idList;
                }
                String services = "<span title=\"" + titleServices + "\">" + countDependentServices + "</span>";
                col.append(services);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentReservations = service.getDependentReservations();
                int countDependentReservations = dependentReservations.size();
                String titleReservations = "";
                if (countDependentReservations > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentReservations) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleReservations = "dependent Reservation Id list: " + idList;
                }
                String reservations = "<span title=\"" + titleReservations + "\">" + countDependentReservations + "</span>";
                col.append(reservations);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String description = service.getDescription();
                col.append(description);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            String text = "";
            text = DuccData.getInstance().isPublished() ? messages.fetch("no services") : messages.fetch("no data");
            row.add((JsonElement)new JsonPrimitive(text));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void buildRowForIndividualMachine(JsonArray data, int counter, MachineInfo machineInfo, SizeBytes allocated) {
        JsonArray row = new JsonArray();
        StringBuffer sb = new StringBuffer();
        String status = machineInfo.getStatus();
        String hover = "title=\"" + machineInfo.getMachineStatusReason() + "\"";
        if (status.equals("down")) {
            sb.append("<span " + hover + " class=\"health_red\">");
            sb.append(status);
            sb.append("</span>");
        } else if (status.equals("up")) {
            sb.append("<span " + hover + "class=\"health_green\">");
            sb.append(status);
            sb.append("</span>");
        } else {
            sb.append(status);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        row.add((JsonElement)new JsonPrimitive(machineInfo.getIp()));
        row.add((JsonElement)new JsonPrimitive(machineInfo.getName()));
        String nodepool = DuccSchedulerClasses.getInstance().getNodepool(machineInfo.getName());
        row.add((JsonElement)new JsonPrimitive(nodepool));
        if (status.equals("up")) {
            sb = new StringBuffer();
            sb.append("total=" + machineInfo.getMemTotal());
            Integer quantum = machineInfo.getQuantum();
            if (quantum != null) {
                sb.append(" ");
                sb.append("quantum=" + quantum);
            }
            hover = "title=\"" + sb.toString() + "\"";
            String memReserveWithHover = "<span " + hover + " >" + machineInfo.getMemReserve() + "</span>";
            row.add((JsonElement)new JsonPrimitive(memReserveWithHover));
        } else if (status.equals("down")) {
            row.add((JsonElement)new JsonPrimitive("0"));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        if (status.equals("up")) {
            long memFree = ConvertSafely.String2Long((String)machineInfo.getMemReserve());
            row.add((JsonElement)new JsonPrimitive((Number)(memFree -= allocated.getGBytes())));
        } else if (status.equals("down")) {
            row.add((JsonElement)new JsonPrimitive("0"));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        if (!status.equals("defined")) {
            String cpu = formatter1.format(machineInfo.getCpu());
            row.add((JsonElement)new JsonPrimitive(cpu));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        sb = new StringBuffer();
        String swapping = machineInfo.getSwapInuse();
        if (swapping.equals("0")) {
            sb.append(swapping);
        } else {
            sb.append("<span class=\"health_red\">");
            sb.append(swapping);
            sb.append("</span>");
        }
        if (!status.equals("defined")) {
            row.add((JsonElement)new JsonPrimitive(sb.toString()));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        if (!status.equals("defined")) {
            row.add((JsonElement)new JsonPrimitive(machineInfo.getSwapFree()));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        boolean isCgroupsEnabled = machineInfo.getCgroupsEnabled();
        boolean isCgroupsCpuReportingEnabled = machineInfo.getCgroupsCpuReportingEnabled();
        sb = new StringBuffer();
        if (status.equals("up")) {
            if (isCgroupsEnabled) {
                if (isCgroupsCpuReportingEnabled) {
                    sb.append("<span title=\"control groups active\" class=\"health_black\">");
                    sb.append("on");
                    sb.append("</span>");
                } else {
                    sb.append("<span title=\"control groups CPU reporting not configured\" class=\"health_red\">");
                    sb.append("noCPU%");
                    sb.append("</span>");
                }
            } else {
                sb.append("<span title=\"control groups inactive\" class=\"health_red\">");
                sb.append("off");
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        long aliens = machineInfo.getAliens().size();
        if (aliens == 0L) {
            sb.append(aliens);
        } else {
            StringBuffer title = new StringBuffer();
            title.append("title=");
            title.append("\"");
            for (String pid : machineInfo.getAliens()) {
                title.append(pid + " ");
            }
            title.append("\"");
            sb.append("<span class=\"health_red\" " + title + ">");
            sb.append(aliens);
            sb.append("</span>");
        }
        if (!status.equals("defined")) {
            row.add((JsonElement)new JsonPrimitive(sb.toString()));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        if (!status.equals("defined")) {
            row.add((JsonElement)new JsonPrimitive(machineInfo.getHeartbeatLast()));
        } else {
            row.add((JsonElement)new JsonPrimitive(""));
        }
        data.add((JsonElement)row);
    }

    private void handleServletJsonFormatMachinesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatMachinesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        JsonArray individualMachines = new JsonArray();
        int counter = 0;
        long sumMemTotal = 0L;
        long sumMemFree = 0L;
        long sumMemReserve = 0L;
        long sumMemAllocated = 0L;
        double sumCPU = 0.0;
        long sumMachines = 0L;
        long sumSwapInuse = 0L;
        long sumSwapFree = 0L;
        long sumAliens = 0L;
        DuccMachinesData instance = DuccMachinesData.getInstance();
        Map<MachineInfo, NodeId> machines = instance.getMachines();
        if (!machines.isEmpty()) {
            Map<String, Long> allocatedMap = Distiller.getMap();
            for (Map.Entry<MachineInfo, NodeId> entry : machines.entrySet()) {
                MachineInfo machineInfo = entry.getKey();
                SizeBytes sb = new SizeBytes(SizeBytes.Type.Bytes, 0L);
                if (DuccMachinesDataHelper.isUp(machineInfo)) {
                    try {
                        sumMemTotal += ConvertSafely.String2Long((String)machineInfo.getMemTotal());
                        sumMemReserve += ConvertSafely.String2Long((String)machineInfo.getMemReserve());
                        sumSwapInuse += ConvertSafely.String2Long((String)machineInfo.getSwapInuse());
                        sumSwapFree += ConvertSafely.String2Long((String)machineInfo.getSwapFree());
                        sumCPU += machineInfo.getCpu();
                        ++sumMachines;
                        sumAliens += (long)machineInfo.getAliens().size();
                        String machineName = machineInfo.getName();
                        long bytes = allocatedMap.get(machineName);
                        sumMemAllocated += bytes;
                        sb = new SizeBytes(SizeBytes.Type.Bytes, bytes);
                        String text = "allocated " + machineName + "=" + sb.getGBytes();
                        duccLogger.trace(methodName, jobid, new Object[]{text});
                    }
                    catch (Exception e) {
                        duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
                    }
                }
                this.buildRowForIndividualMachine(individualMachines, counter, machineInfo, sb);
                ++counter;
            }
            SizeBytes sbAllocated = new SizeBytes(SizeBytes.Type.Bytes, sumMemAllocated);
            sumMemFree = sumMemReserve - sbAllocated.getGBytes();
            JsonArray row = new JsonArray();
            row.add((JsonElement)new JsonPrimitive("Total"));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            String hover = "title=\"total=" + sumMemTotal + "\"";
            String sumMemReserveWithHover = "<span " + hover + " >" + sumMemReserve + "</span>";
            row.add((JsonElement)new JsonPrimitive(sumMemReserveWithHover));
            row.add((JsonElement)new JsonPrimitive((Number)sumMemFree));
            String cpuTotal = formatter1.format(sumCPU / (double)sumMachines);
            row.add((JsonElement)new JsonPrimitive(cpuTotal));
            row.add((JsonElement)new JsonPrimitive((Number)sumSwapInuse));
            row.add((JsonElement)new JsonPrimitive((Number)sumSwapFree));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive((Number)sumAliens));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        } else {
            JsonArray row = new JsonArray();
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        data.addAll(individualMachines);
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatBrokerAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletJsonFormatBrokerAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        BrokerHelper brokerHelper = BrokerHelper.getInstance();
        JsonArray topics = new JsonArray();
        JsonArray queues = new JsonArray();
        Map<String, Map<String, String>> topicAttributes = brokerHelper.getEntityAttributes();
        if (topicAttributes.size() > 0) {
            for (Map.Entry<String, Map<String, String>> entry : topicAttributes.entrySet()) {
                String topic = entry.getKey();
                Map<String, String> map = entry.getValue();
                JsonArray row = new JsonArray();
                row.add((JsonElement)new JsonPrimitive(topic));
                String type = map.get(BrokerHelper.JmxKeyWord.Type.name());
                row.add((JsonElement)new JsonPrimitive(type));
                String attrValue = map.get(BrokerHelper.FrameworkAttribute.ConsumerCount.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.QueueSize.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MaxEnqueueTime.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.AverageEnqueueTime.name());
                try {
                    Double d = Double.valueOf(attrValue);
                    attrValue = formatter3.format(d);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MemoryPercentUsage.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                if (type.equals(map.get(BrokerHelper.FrameworkAttribute.QueueSize.name()))) {
                    topics.add((JsonElement)row);
                    continue;
                }
                queues.add((JsonElement)row);
            }
            data.addAll(topics);
            data.addAll(queues);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatClassesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletJsonFormatClassesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        DuccSchedulerClasses schedulerClasses = DuccSchedulerClasses.getInstance();
        Map clmap = schedulerClasses.getClasses();
        String val = null;
        NodeConfiguration nc = this.getNodeConfiguration();
        if (clmap != null) {
            DuccProperties[] class_set = clmap.values().toArray(new DuccProperties[clmap.size()]);
            Arrays.sort(class_set, new NodeConfiguration.ClassSorter());
            for (DuccProperties cl : class_set) {
                String v1;
                JsonArray row = new JsonArray();
                String class_name = cl.getProperty("name");
                row.add((JsonElement)new JsonPrimitive(class_name));
                val = cl.getProperty("nodepool");
                row.add((JsonElement)new JsonPrimitive(val));
                String policy = cl.getProperty("policy");
                row.add((JsonElement)new JsonPrimitive(policy));
                int quantum = this.getQuantum(nc, class_name);
                row.add((JsonElement)new JsonPrimitive((Number)quantum));
                String weight = cl.getStringProperty("weight", "-");
                row.add((JsonElement)new JsonPrimitive(weight));
                String priority = cl.getProperty("priority");
                row.add((JsonElement)new JsonPrimitive(priority));
                val = "-";
                if (schedulerClasses.isPreemptable(class_name) && schedulerClasses.isPreemptable(class_name) && !(v1 = cl.getStringProperty("debug", "")).equals("")) {
                    val = v1;
                }
                row.add((JsonElement)new JsonPrimitive(val));
                data.add((JsonElement)row);
            }
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatDaemonsAaDataAll(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean allDaemonsFlag = true;
        this.handleServletJsonFormatDaemonsAaData(target, baseRequest, request, response, allDaemonsFlag);
    }

    private void handleServletJsonFormatDaemonsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean allDaemonsFlag = false;
        this.handleServletJsonFormatDaemonsAaData(target, baseRequest, request, response, allDaemonsFlag);
    }

    private void handleServletJsonFormatDaemonsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, boolean allDaemonsFlag) throws IOException, ServletException {
        JsonArray row;
        String methodName = "handleServletJsonFormatDaemonsAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        DuccDaemonsData duccDaemonsData = DuccDaemonsData.getInstance();
        DuccMachinesData duccMachinesData = DuccMachinesData.getInstance();
        String wsHostIP = this.getWebServerHostIP();
        String wsHostName = this.getWebServerHostName();
        boolean brokerAlive = brokerHelper.isAlive();
        block14: for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            row = new JsonArray();
            String status = "";
            String bootTime = "";
            String hostIP = "";
            String hostName = "";
            String pid = "";
            String pubSizeLast = "";
            String pubSizeMax = "";
            String heartbeatLast = "";
            String heartbeatMax = "";
            String heartbeatMaxTOD = "";
            String jmxUrl = null;
            Properties properties = DuccDaemonRuntimeProperties.getInstance().get(daemonName);
            switch (daemonName) {
                case Database: {
                    if (databaseHelper.isDisabled()) continue block14;
                }
                default: {
                    switch (daemonName) {
                        case Broker: {
                            status = brokerAlive ? DuccHandlerUtils.up() : DuccHandlerUtils.down();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), brokerHelper.getStartTime());
                            hostName = this.useWS(wsHostName, brokerHelper.getHost());
                            hostIP = this.useWS(wsHostName, hostName, wsHostIP);
                            pid = "" + brokerHelper.getPID();
                            pubSizeLast = "-";
                            pubSizeMax = "-";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = brokerHelper.getJmxUrl();
                            break;
                        }
                        case Database: {
                            status = databaseHelper.isAlive() ? DuccHandlerUtils.up() : DuccHandlerUtils.down();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), databaseHelper.getStartTime());
                            hostName = this.useWS(wsHostName, databaseHelper.getHost());
                            hostIP = this.useWS(wsHostName, hostName, wsHostIP);
                            pid = "" + databaseHelper.getPID();
                            pubSizeLast = "-";
                            pubSizeMax = "-";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = databaseHelper.getJmxUrl();
                            break;
                        }
                        case Webserver: {
                            status = DuccHandlerUtils.up();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                            hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                            hostName = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "");
                            pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                            pubSizeLast = "*";
                            pubSizeMax = "*";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                            break;
                        }
                        default: {
                            status = DuccHandlerUtils.unknown();
                            if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                            }
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                            hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                            hostName = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "");
                            pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                            pubSizeLast = "" + duccDaemonsData.getEventSize(daemonName);
                            pubSizeMax = "" + duccDaemonsData.getEventSizeMax(daemonName);
                            heartbeatLast = DuccDaemonsData.getInstance().getHeartbeat(daemonName);
                            long timeout = DuccWebProperties.get_ducc_ws_monitored_daemon_down_millis_expiry() / 1000L;
                            if (timeout > 0L) {
                                try {
                                    long overtime = timeout - Long.parseLong(heartbeatLast);
                                    if (overtime < 0L) {
                                        if (brokerAlive) {
                                            status = DuccHandlerUtils.down();
                                        }
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                            String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                            String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                            String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                            status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                                        }
                                    } else {
                                        boolean reqMet;
                                        if (brokerAlive) {
                                            status = DuccHandlerUtils.up();
                                        }
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && !(reqMet = DuccData.getInstance().getLive().isJobDriverMinimalAllocateRequirementMet())) {
                                            status = DuccHandlerUtils.up_provisional(", pending JD allocation");
                                        }
                                    }
                                }
                                catch (Throwable overtime) {
                                    // empty catch block
                                }
                            }
                            heartbeatMax = DuccDaemonsData.getInstance().getMaxHeartbeat(daemonName);
                            heartbeatMaxTOD = TimeStamp.simpleFormat((String)DuccDaemonsData.getInstance().getMaxHeartbeatTOD(daemonName));
                            try {
                                heartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), heartbeatMaxTOD);
                            }
                            catch (Exception overtime) {
                                // empty catch block
                            }
                            jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                        }
                    }
                    row.add((JsonElement)new JsonPrimitive(status));
                    row.add((JsonElement)new JsonPrimitive(daemonName.name()));
                    row.add((JsonElement)new JsonPrimitive(bootTime));
                    row.add((JsonElement)new JsonPrimitive(hostIP));
                    row.add((JsonElement)new JsonPrimitive(hostName));
                    row.add((JsonElement)new JsonPrimitive(pid));
                    row.add((JsonElement)new JsonPrimitive("" + pubSizeLast));
                    row.add((JsonElement)new JsonPrimitive("" + pubSizeMax));
                    row.add((JsonElement)new JsonPrimitive("" + heartbeatLast));
                    row.add((JsonElement)new JsonPrimitive("" + heartbeatMax));
                    row.add((JsonElement)new JsonPrimitive("" + heartbeatMaxTOD));
                    String jmxUrlLink = "";
                    if (jmxUrl != null) {
                        jmxUrlLink = this.buildjConsoleLink(jmxUrl);
                    }
                    row.add((JsonElement)new JsonPrimitive(jmxUrlLink));
                    data.add((JsonElement)row);
                }
            }
        }
        boolean showAgents = allDaemonsFlag;
        if (!showAgents) {
            String cookie = DuccCookies.getCookie(request, "DUCCagents");
            duccLogger.trace(methodName, jobid, new Object[]{"== show: " + cookie});
            if (cookie.equals("show")) {
                showAgents = true;
            }
        }
        if (showAgents) {
            Map<MachineInfo, NodeId> machines = duccMachinesData.getMachines();
            Iterator<MachineInfo> iterator = machines.keySet().iterator();
            while (iterator.hasNext()) {
                row = new JsonArray();
                MachineInfo machineInfo = iterator.next();
                DuccDaemonRuntimeProperties drp = DuccDaemonRuntimeProperties.getInstance();
                String machineName = machineInfo.getName();
                if (machineName.startsWith("=")) continue;
                Properties properties = drp.getAgent(machineName);
                StringBuffer status = new StringBuffer();
                if (brokerAlive) {
                    String machineStatus = machineInfo.getStatus();
                    if (machineStatus.equals("down")) {
                        status.append(DuccHandlerUtils.down());
                    } else if (machineStatus.equals("up")) {
                        status.append(DuccHandlerUtils.up());
                    } else {
                        status.append(DuccHandlerUtils.unknown());
                    }
                } else {
                    status.append(DuccHandlerUtils.unknown());
                }
                row.add((JsonElement)new JsonPrimitive(status.toString()));
                String daemonName = "Agent";
                row.add((JsonElement)new JsonPrimitive(daemonName));
                String bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                row.add((JsonElement)new JsonPrimitive(bootTime));
                String hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                row.add((JsonElement)new JsonPrimitive(hostIP));
                String hostName = machineInfo.getName();
                row.add((JsonElement)new JsonPrimitive(hostName));
                String pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                row.add((JsonElement)new JsonPrimitive(pid));
                String publicationSizeLast = machineInfo.getPublicationSizeLast();
                row.add((JsonElement)new JsonPrimitive(publicationSizeLast));
                String publicationSizeMax = machineInfo.getPublicationSizeMax();
                row.add((JsonElement)new JsonPrimitive(publicationSizeMax));
                String heartbeatLast = machineInfo.getHeartbeatLast();
                row.add((JsonElement)new JsonPrimitive(heartbeatLast));
                long heartbeatMax = machineInfo.getHeartbeatMax();
                if (heartbeatMax > 0L) {
                    row.add((JsonElement)new JsonPrimitive((Number)heartbeatMax));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                String fmtHeartbeatMaxTOD = "";
                long heartbeatMaxTOD = machineInfo.getHeartbeatMaxTOD();
                if (heartbeatMaxTOD > 0L) {
                    fmtHeartbeatMaxTOD = TimeStamp.simpleFormat((String)("" + heartbeatMaxTOD));
                    try {
                        fmtHeartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), fmtHeartbeatMaxTOD);
                    }
                    catch (Exception hover) {
                        // empty catch block
                    }
                }
                row.add((JsonElement)new JsonPrimitive(fmtHeartbeatMaxTOD));
                String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                String jmxUrlLink = "";
                if (jmxUrl != null) {
                    jmxUrlLink = this.buildjConsoleLink(jmxUrl);
                }
                row.add((JsonElement)new JsonPrimitive(jmxUrlLink));
                data.add((JsonElement)row);
            }
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatMachines(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatMachines";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DuccMachinesData instance = DuccMachinesData.getInstance();
        MachineFactsList factsList = instance.getMachineFactsList();
        Gson gson = new Gson();
        String jSon = gson.toJson((Object)factsList);
        sb.append(jSon);
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatReservations(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatReservations";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        ReservationFactsList factsList = new ReservationFactsList();
        int maxRecords = this.getReservationsMaxRecordsParameter(request);
        DuccAbstractHandler.RequestStateType requestStateType = this.getStateTypeParameter(request);
        ArrayList<String> users = this.getReservationsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<ReservationInfo, ReservationInfo> sortedReservations = duccData.getSortedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<ReservationInfo, ReservationInfo>> iterator = sortedReservations.entrySet().iterator();
            int counter = 0;
            block11: while (iterator.hasNext()) {
                String reservationUser;
                ReservationInfo reservationInfo = iterator.next().getValue();
                DuccWorkReservation reservation = reservationInfo.getReservation();
                IDuccState.ReservationState reservationState = reservation.getReservationState();
                block0 : switch (requestStateType) {
                    case All: {
                        break;
                    }
                    case Active: {
                        switch (reservationState) {
                            case Completed: {
                                continue block11;
                            }
                        }
                        break;
                    }
                    case Inactive: {
                        switch (reservationState) {
                            case Completed: {
                                break block0;
                            }
                        }
                        continue block11;
                    }
                }
                if (!this.isIncludeUser(users, reservationUser = reservation.getStandardInfo().getUser().trim()) || maxRecords <= 0 || counter++ >= maxRecords) continue;
                String id = reservation.getId();
                String start = this.getTimeStamp(request, reservation.getDuccId(), reservation.getStandardInfo().getDateOfSubmission());
                String end = this.getTimeStamp(request, reservation.getDuccId(), reservation.getStandardInfo().getDateOfCompletion());
                String user = reservation.getStandardInfo().getUser();
                String rclass = reservation.getSchedulingInfo().getSchedulingClass();
                String state = reservation.getReservationState().toString();
                String reason = reservation.getCompletionType().toString();
                String allocation = reservation.getSchedulingInfo().getInstancesCount();
                ArrayList<NodePidList> userProcesses = new ArrayList();
                ArrayList<String> list = new ArrayList();
                if (!reservation.isCompleted()) {
                    userProcesses = DuccMachinesData.getInstance().getUserProcesses(reservation.getUniqueNodes(), user);
                    list = reservation.getNodes();
                }
                SizeBytes resSize = new SizeBytes(SizeBytes.Type.Bytes, reservation.getSchedulingInfo().getMemorySizeAllocatedInBytes());
                String size = "" + this.getProcessMemorySize(reservation.getDuccId(), resSize);
                String description = reservation.getStandardInfo().getDescription();
                ReservationFacts facts = new ReservationFacts(id, start, end, user, rclass, state, reason, allocation, userProcesses, size, list, description);
                factsList.add(facts);
            }
        }
        Gson gson = new Gson();
        String jSon = gson.toJson((Object)factsList);
        sb.append(jSon);
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/json-format-aaData-jobs")) {
            this.handleServletJsonFormatJobsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-reservations")) {
            this.handleServletJsonFormatReservationsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-services")) {
            this.handleServletJsonFormatServicesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-machines")) {
            this.handleServletJsonFormatMachinesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-broker")) {
            this.handleServletJsonFormatBrokerAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-classes")) {
            this.handleServletJsonFormatClassesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-daemons-all")) {
            this.handleServletJsonFormatDaemonsAaDataAll(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-daemons")) {
            this.handleServletJsonFormatDaemonsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-machines")) {
            this.handleServletJsonFormatMachines(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-reservations")) {
            this.handleServletJsonFormatReservations(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-job-processes")) {
            this.handleServletJsonFormatJobProcessesData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-job-specification")) {
            this.handleServletJsonFormatJobSpecificationData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-managed-reservation-specification")) {
            this.handleServletJsonFormatManagedReservationSpecificationData(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/json-format")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

