/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.db.DbQuery;
import org.apache.uima.ducc.ws.helper.JmxHelper;

public class DatabaseHelper
extends JmxHelper {
    private static DuccLogger logger = DuccLogger.getLogger(DatabaseHelper.class);
    private static DuccId jobid = null;
    private static DatabaseHelper instance = new DatabaseHelper();
    protected boolean enabled = false;
    protected String host = null;

    public static DatabaseHelper getInstance() {
        return instance;
    }

    private DatabaseHelper() {
        this.init();
    }

    private void init() {
        block10: {
            String location = "init";
            try {
                DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
                this.host = dpr.getProperty("ducc.database.host");
                if (this.host != null) {
                    this.setHost(this.host);
                    if (!this.host.equalsIgnoreCase("--disabled--")) {
                        this.enabled = true;
                    }
                }
                if (!this.enabled) break block10;
                String jmxHost = dpr.getProperty("ducc.database.jmx.host");
                if (jmxHost != null) {
                    try {
                        this.setJmxHost(jmxHost);
                    }
                    catch (Exception e) {
                        logger.error(location, jobid, (Throwable)e, new Object[0]);
                    }
                }
                this.setJmxPort(7199);
                String jmxPort = dpr.getProperty("ducc.database.jmx.port");
                if (jmxPort != null) {
                    try {
                        this.setJmxPort(Integer.parseInt(jmxPort));
                    }
                    catch (Exception e) {
                        logger.error(location, jobid, (Throwable)e, new Object[0]);
                    }
                }
                this.jmxConnect();
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    private void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isAlive() {
        boolean retVal = DbQuery.getInstance().isUp();
        return retVal;
    }

    public Long getStartTime() {
        String location = "getStartTime";
        Long retVal = new Long(0L);
        Object o = null;
        MBeanServerConnection mbsc = null;
        try {
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "StartTime");
            retVal = (Long)o;
        }
        catch (Exception e) {
            try {
                this.reconnect();
                mbsc = this.getMBSC();
                o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "StartTime");
                retVal = (Long)o;
            }
            catch (Exception e2) {
                logger.error(location, jobid, (Throwable)e2, new Object[0]);
            }
        }
        return retVal;
    }

    @Override
    protected void reconnect() {
        String location = "reconnect";
        this.init();
        logger.debug(location, jobid, new Object[]{"reconnected"});
    }
}

