/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.authentication;

import org.apache.uima.ducc.common.authentication.IAuthenticationManager;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.authentication.AbstractAuthenticator;

public class DuccAuthenticator
extends AbstractAuthenticator {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccAuthenticator.class);
    private static DuccId jobid = null;
    private static DuccAuthenticator instance = new DuccAuthenticator();
    private DuccPropertiesResolver duccPropertiesResolver = DuccPropertiesResolver.getInstance();
    private IAuthenticationManager iAuthenticationManager = null;

    public static DuccAuthenticator getInstance() {
        return instance;
    }

    public DuccAuthenticator() {
        this.initializeAuthenticator();
    }

    private void initializeAuthenticator() {
        String methodName = "initializeAuthenticator";
        try {
            String key = "ducc.authentication.implementer";
            String value = this.duccPropertiesResolver.getProperty(key);
            duccLogger.info(methodName, jobid, new Object[]{value});
            String cp = System.getProperty("java.class.path");
            String[] cplist = cp.split(":");
            if (cplist != null) {
                for (String item : cplist) {
                    duccLogger.debug(methodName, null, new Object[]{item});
                }
            }
            Class<?> authenticationImplementer = Class.forName(value);
            this.iAuthenticationManager = (IAuthenticationManager)authenticationImplementer.newInstance();
            duccLogger.info(methodName, jobid, new Object[]{this.iAuthenticationManager.getVersion()});
        }
        catch (Throwable t) {
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }

    public String getVersion() {
        String methodName = "getVersion";
        String retVal = null;
        try {
            retVal = this.iAuthenticationManager.getVersion();
            duccLogger.debug(methodName, jobid, new Object[]{retVal});
        }
        catch (Throwable t) {
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }

    @Override
    public String getNotes(String userid) {
        String methodName = "getNotes";
        String retVal = null;
        try {
            retVal = this.iAuthenticationManager.getNotes(userid);
            duccLogger.debug(methodName, jobid, new Object[]{retVal});
        }
        catch (Throwable t) {
            duccLogger.debug(methodName, jobid, new Object[]{"no notes available - legacy implementer?"});
            duccLogger.debug(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }

    public boolean isPasswordChecked() {
        String methodName = "isPasswordChecked";
        boolean retVal = false;
        try {
            retVal = this.iAuthenticationManager.isPasswordChecked();
            duccLogger.debug(methodName, jobid, new Object[]{retVal});
        }
        catch (Throwable t) {
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }

    public IAuthenticationResult isAuthenticate(String userid, String domain, String password) {
        String methodName = "isAuthenticate";
        IAuthenticationResult retVal = null;
        try {
            retVal = this.iAuthenticationManager.isAuthenticate(userid, domain, password);
            duccLogger.debug(methodName, jobid, new Object[]{userid + " " + domain + " " + retVal});
        }
        catch (Throwable t) {
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }

    @Override
    public IAuthenticationResult isGroupMember(String userid, String domain, IAuthenticationManager.Role role) {
        String methodName = "isGroupMember";
        IAuthenticationResult retVal = null;
        try {
            retVal = this.iAuthenticationManager.isGroupMember(userid, domain, role);
            duccLogger.debug(methodName, jobid, new Object[]{userid + " " + domain + " " + retVal});
        }
        catch (Throwable t) {
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
        return retVal;
    }
}

