/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils;

import java.util.TreeMap;

public class LinuxSignals {
    private static int signalUpperLimit = Signal.SIGSYS.number() + 1;
    private static TreeMap<Integer, Signal> map = LinuxSignals.createMap();
    private static int boundary_lower = 128;
    private static int boundary_upper = 128 + signalUpperLimit;

    private static TreeMap<Integer, Signal> createMap() {
        TreeMap<Integer, Signal> signalMap = new TreeMap<Integer, Signal>();
        LinuxSignals.mapAdd(signalMap, Signal.SIGHUP);
        LinuxSignals.mapAdd(signalMap, Signal.SIGINT);
        LinuxSignals.mapAdd(signalMap, Signal.SIGQUIT);
        LinuxSignals.mapAdd(signalMap, Signal.SIGILL);
        LinuxSignals.mapAdd(signalMap, Signal.SIGTRAP);
        LinuxSignals.mapAdd(signalMap, Signal.SIGABRT);
        LinuxSignals.mapAdd(signalMap, Signal.SIGBUS);
        LinuxSignals.mapAdd(signalMap, Signal.SIGFPE);
        LinuxSignals.mapAdd(signalMap, Signal.SIGKILL);
        LinuxSignals.mapAdd(signalMap, Signal.SIGUSR1);
        LinuxSignals.mapAdd(signalMap, Signal.SIGSEGV);
        LinuxSignals.mapAdd(signalMap, Signal.SIGUSR2);
        LinuxSignals.mapAdd(signalMap, Signal.SIGPIPE);
        LinuxSignals.mapAdd(signalMap, Signal.SIGALRM);
        LinuxSignals.mapAdd(signalMap, Signal.SIGTERM);
        LinuxSignals.mapAdd(signalMap, Signal.SIGSTKFLT);
        LinuxSignals.mapAdd(signalMap, Signal.SIGCHLD);
        LinuxSignals.mapAdd(signalMap, Signal.SIGCONT);
        LinuxSignals.mapAdd(signalMap, Signal.SIGSTOP);
        LinuxSignals.mapAdd(signalMap, Signal.SIGTSTP);
        LinuxSignals.mapAdd(signalMap, Signal.SIGTTIN);
        LinuxSignals.mapAdd(signalMap, Signal.SIGTTOU);
        LinuxSignals.mapAdd(signalMap, Signal.SIGURG);
        LinuxSignals.mapAdd(signalMap, Signal.SIGXCPU);
        LinuxSignals.mapAdd(signalMap, Signal.SIGXFSZ);
        LinuxSignals.mapAdd(signalMap, Signal.SIGVTALRM);
        LinuxSignals.mapAdd(signalMap, Signal.SIGPROF);
        LinuxSignals.mapAdd(signalMap, Signal.SIGWINCH);
        LinuxSignals.mapAdd(signalMap, Signal.SIGIO);
        LinuxSignals.mapAdd(signalMap, Signal.SIGPWR);
        LinuxSignals.mapAdd(signalMap, Signal.SIGSYS);
        return signalMap;
    }

    private static void mapAdd(TreeMap<Integer, Signal> signalMap, Signal signal) {
        Integer key = signal.number;
        Signal value = signal;
        signalMap.put(key, value);
    }

    public static int getValue(int code) {
        return code - boundary_lower;
    }

    public static boolean isSignal(int code) {
        return code > boundary_lower && code < boundary_upper;
    }

    public static Signal lookup(int code) {
        Signal retVal = null;
        Integer key = code - boundary_lower;
        if (map.containsKey(key)) {
            retVal = map.get(key);
        }
        return retVal;
    }

    private static void report(int code) {
        if (LinuxSignals.isSignal(code)) {
            Signal signal = LinuxSignals.lookup(code);
            System.out.println("name=" + signal.name() + " " + "number=" + signal.number() + " " + "description=" + signal.description());
        } else {
            System.out.println("name=<none> number=" + code + " " + "description=" + "<none>");
        }
    }

    public static void main(String[] args) {
        for (int i = 1; i < 35; ++i) {
            LinuxSignals.report(i + boundary_lower);
        }
    }

    public static enum Signal {
        SIGHUP(1, "Hangup (POSIX)"),
        SIGINT(2, "Interrupt (ANSI)"),
        SIGQUIT(3, "Quit (POSIX)"),
        SIGILL(4, "Illegal instruction (ANSI)"),
        SIGTRAP(5, "Trace trap (POSIX)"),
        SIGABRT(6, "Abort (ANSI)"),
        SIGBUS(7, "BUS error (4.2 BSD)"),
        SIGFPE(8, "Floating-point exception (ANSI)"),
        SIGKILL(9, "Kill, unblockable (POSIX)"),
        SIGUSR1(10, "User-defined signal 1 (POSIX)"),
        SIGSEGV(11, "Segmentation violation (ANSI)"),
        SIGUSR2(12, "User-defined signal 2 (POSIX)"),
        SIGPIPE(13, "Broken pipe (POSIX)"),
        SIGALRM(14, "Alarm clock (POSIX)"),
        SIGTERM(15, "Termination (ANSI)"),
        SIGSTKFLT(16, "Stack fault"),
        SIGCHLD(17, "Child status has changed (POSIX)"),
        SIGCONT(18, "Continue (POSIX)"),
        SIGSTOP(19, "Stop, unblockable (POSIX)"),
        SIGTSTP(20, "Keyboard stop (POSIX"),
        SIGTTIN(21, "Background read from tty (POSIX)"),
        SIGTTOU(22, "Background write to tty (POSIX)"),
        SIGURG(23, "Urgent condition on socket (4.2 BSD)"),
        SIGXCPU(24, "CPU limit exceeded (4.2 BSD)"),
        SIGXFSZ(25, "File size limit exceeded (4.2 BSD)"),
        SIGVTALRM(26, "Virtual alarm clock (4.2 BSD)"),
        SIGPROF(27, "Profiling alarm clock (4.2 BSD)"),
        SIGWINCH(28, "Window size change (4.3 BSD, Sun)"),
        SIGIO(29, "I/O now possible (4.2 BSD)"),
        SIGPWR(30, "Power failure restart (System V)"),
        SIGSYS(31, "Bad system call");

        private final int number;
        private final String description;

        private Signal(int number, String description) {
            this.number = number;
            this.description = description;
        }

        public int number() {
            return this.number;
        }

        public String description() {
            return this.description;
        }
    }
}

