/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccDataHelper;
import org.apache.uima.ducc.ws.registry.IServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;

public class ServicesHelper {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)ServicesHelper.class.getName());
    private static DuccId jobid = null;
    private static ServicesHelper instance = new ServicesHelper();

    public static ServicesHelper getInstance() {
        return instance;
    }

    public String getId(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        String value;
        String retVal = "";
        if (propertiesMeta != null && propertiesMeta.containsKey(IServicesRegistry.numeric_id) && (value = propertiesMeta.getProperty(IServicesRegistry.numeric_id)) != null) {
            retVal = value;
        }
        return retVal;
    }

    public ArrayList<String> getImplementors(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (propertiesMeta != null && propertiesMeta.containsKey(IServicesRegistry.implementors)) {
            String[] implementors;
            for (String implementor : implementors = DuccDataHelper.parseImplementors(propertiesMeta)) {
                retVal.add(implementor);
            }
        }
        return retVal;
    }

    public long getDeployments(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        ArrayList<String> implementors = this.getImplementors(servicesRegistry, propertiesMeta);
        return implementors.size();
    }

    public List<DuccWorkJob> getServicesList(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        ArrayList<DuccWorkJob> retVal = new ArrayList();
        ArrayList<String> implementors = this.getImplementors(servicesRegistry, propertiesMeta);
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        retVal = duccWorkMap.getServicesList(implementors);
        return retVal;
    }

    public long getPgin(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        String location = "getPgin";
        String id = this.getId(servicesRegistry, propertiesMeta);
        long retVal = 0L;
        List<DuccWorkJob> servicesList = this.getServicesList(servicesRegistry, propertiesMeta);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getMajorFaults();
            }
        }
        logger.debug(location, jobid, new Object[]{id, retVal});
        return retVal;
    }

    public long getSwap(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        String location = "getSwap";
        String id = this.getId(servicesRegistry, propertiesMeta);
        long retVal = 0L;
        List<DuccWorkJob> servicesList = this.getServicesList(servicesRegistry, propertiesMeta);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getSwapUsage();
            }
        }
        logger.debug(location, jobid, new Object[]{id, retVal});
        return retVal;
    }

    public long getSwapMax(ServicesRegistry servicesRegistry, Properties propertiesMeta) {
        String location = "getSwapMax";
        String id = this.getId(servicesRegistry, propertiesMeta);
        long retVal = 0L;
        List<DuccWorkJob> servicesList = this.getServicesList(servicesRegistry, propertiesMeta);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getSwapUsageMax();
            }
        }
        logger.debug(location, jobid, new Object[]{id, retVal});
        return retVal;
    }
}

