/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils.commands;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class CmdId {
    private static String command = "/usr/bin/id";
    private DuccLogger logger = null;
    private DuccId jobid = null;

    public CmdId() {
        this.init(true);
    }

    public CmdId(boolean useLogger) {
        this.init(useLogger);
    }

    private void init(boolean useLogger) {
        if (useLogger) {
            this.logger = DuccLoggerComponents.getWsLogger((String)CmdId.class.getName());
        }
    }

    private boolean isUseLogger() {
        return this.logger != null;
    }

    public String runnit(String[] args) {
        String location = "runCommand";
        String retVal = null;
        try {
            String line;
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(command);
            commandList.add(args[0]);
            String[] commandArray = commandList.toArray(new String[0]);
            ProcessBuilder pb = new ProcessBuilder(commandArray);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(pOut);
            BufferedReader br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                this.debug(location, line);
            }
            retVal = sb.toString();
        }
        catch (Exception e) {
            this.error(location, e);
        }
        return retVal;
    }

    private void debug(String location, String s) {
        if (this.isUseLogger()) {
            this.logger.debug(location, this.jobid, new Object[]{s});
        } else {
            System.out.println(s);
        }
    }

    private void error(String location, Exception e) {
        if (this.isUseLogger()) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        } else {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CmdId id = new CmdId(false);
        id.runnit(args);
    }
}

