/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.json.MonitorInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccWebMonitor;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.server.IWebMonitor;
import org.eclipse.jetty.server.Request;

public class DuccHandlerProxy
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerProxy.class.getName());
    private static DuccId jobid = null;
    public final String proxyJobStatus = "/ducc-servlet/proxy-job-status";
    public final String proxyJobMonitorReport = "/ducc-servlet/proxy-job-monitor-report";
    public final String proxyReservationStatus = "/ducc-servlet/proxy-reservation-status";
    public final String proxyReservationMonitorReport = "/ducc-servlet/proxy-reservation-monitor-report";
    public final String proxyManagedReservationStatus = "/ducc-servlet/proxy-managed-reservation-status";
    public final String proxyManagedReservationMonitorReport = "/ducc-servlet/proxy-managed-reservation-monitor-report";
    DuccWebMonitor duccWebMonitor = DuccWebMonitor.getInstance();

    private boolean isIdMissing(String id) {
        boolean retVal = false;
        if (id.length() == 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isIdInvalid(String id) {
        boolean retVal = false;
        try {
            int value = Integer.parseInt(id);
            if (value < 0) {
                retVal = true;
            }
        }
        catch (Exception e) {
            retVal = true;
        }
        return retVal;
    }

    private void handleServletJobStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletJobStatus";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        String jobId = request.getParameter("id");
        jobId = jobId != null ? jobId.trim() : "";
        if (this.isIdMissing(jobId)) {
            String message = "id missing";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else if (this.isIdInvalid(jobId)) {
            String message = "id invalid";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else {
            MonitorInfo monitorInfo = this.duccWebMonitor.renew(IWebMonitor.MonitorType.Job, jobId);
            Gson gson = new Gson();
            String jSon = gson.toJson((Object)monitorInfo);
            duccLogger.debug(location, jobid, new Object[]{jSon});
            response.getWriter().println(jSon);
            response.setContentType("application/json");
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletJobMonitorReport(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletJobMonitorReport";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        ConcurrentHashMap<DuccId, Long> eMap = this.duccWebMonitor.getExpiryMap(IWebMonitor.MonitorType.Job);
        Gson gson = new Gson();
        String jSon = gson.toJson(eMap);
        duccLogger.debug(location, jobid, new Object[]{jSon});
        response.getWriter().println(jSon);
        response.setContentType("application/json");
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletReservationStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletReservationStatus";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        String id = request.getParameter("id");
        id = id != null ? id.trim() : "";
        if (this.isIdMissing(id)) {
            String message = "id missing";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else if (this.isIdInvalid(id)) {
            String message = "id invalid";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else {
            MonitorInfo monitorInfo = this.duccWebMonitor.renew(IWebMonitor.MonitorType.UnmanagedReservation, id);
            Gson gson = new Gson();
            String jSon = gson.toJson((Object)monitorInfo);
            duccLogger.debug(location, jobid, new Object[]{jSon});
            response.getWriter().println(jSon);
            response.setContentType("application/json");
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletReservationMonitorReport(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletReservationMonitorReport";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        ConcurrentHashMap<DuccId, Long> eMap = this.duccWebMonitor.getExpiryMap(IWebMonitor.MonitorType.UnmanagedReservation);
        Gson gson = new Gson();
        String jSon = gson.toJson(eMap);
        duccLogger.debug(location, jobid, new Object[]{jSon});
        response.getWriter().println(jSon);
        response.setContentType("application/json");
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletManagedReservationStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletManagedReservationStatus";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        String id = request.getParameter("id");
        id = id != null ? id.trim() : "";
        if (this.isIdMissing(id)) {
            String message = "id missing";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else if (this.isIdInvalid(id)) {
            String message = "id invalid";
            duccLogger.info(location, jobid, new Object[]{message});
            response.sendError(400, message);
        } else {
            MonitorInfo monitorInfo = this.duccWebMonitor.renew(IWebMonitor.MonitorType.ManagedReservation, id);
            Gson gson = new Gson();
            String jSon = gson.toJson((Object)monitorInfo);
            duccLogger.debug(location, jobid, new Object[]{jSon});
            response.getWriter().println(jSon);
            response.setContentType("application/json");
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletManagedReservationMonitorReport(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletManagedReservationMonitorReport";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        ConcurrentHashMap<DuccId, Long> eMap = this.duccWebMonitor.getExpiryMap(IWebMonitor.MonitorType.ManagedReservation);
        Gson gson = new Gson();
        String jSon = gson.toJson(eMap);
        duccLogger.debug(location, jobid, new Object[]{jSon});
        response.getWriter().println(jSon);
        response.setContentType("application/json");
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleServletUnknown";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, jobid, new Object[]{request.toString()});
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleDuccRequest";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.debug(location, jobid, new Object[]{request.toString()});
        duccLogger.debug(location, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/proxy-job-status")) {
            this.handleServletJobStatus(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/proxy-job-monitor-report")) {
            this.handleServletJobMonitorReport(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/proxy-managed-reservation-status")) {
            this.handleServletManagedReservationStatus(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/proxy-managed-reservation-monitor-report")) {
            this.handleServletManagedReservationMonitorReport(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/proxy-reservation-status")) {
            this.handleServletReservationStatus(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/proxy-reservation-monitor-report")) {
            this.handleServletReservationMonitorReport(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handle";
        try {
            duccLogger.debug(location, jobid, new Object[]{request.toString()});
            duccLogger.debug(location, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/proxy")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(location, jobid, t, new Object[0]);
            }
            duccLogger.info(location, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(location, jobid, t, new Object[0]);
        }
    }
}

