/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.processor.uima;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.errors.builtin.WindowBasedErrorHandler;
import org.apache.uima.ducc.ps.service.utils.UimaSerializer;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class AbstractServiceProcessor {
    protected Map<Long, UimaSerializer> serializerMap = new HashMap<Long, UimaSerializer>();
    protected AtomicLong errorCount = new AtomicLong();
    protected AtomicLong successCount = new AtomicLong();
    protected AtomicLong errorCountSinceLastSuccess = new AtomicLong();
    protected int maxErrors = 1;
    protected int windowSize = 1;
    protected int DEFAULT_INIT_DELAY = 30000;

    protected IServiceErrorHandler getErrorHandler(Logger logger) {
        logger.log(Level.INFO, "Error Handler Configuration: threshold=" + this.maxErrors + " windowSize=" + this.windowSize);
        return new WindowBasedErrorHandler().withMaxFrameworkErrors(this.maxErrors).withProcessErrorWindow(this.windowSize).build();
    }

    protected void delay(Logger logger, long howLong) {
        long delay = this.DEFAULT_INIT_DELAY;
        if (System.getProperty("ducc.service.init.delay") != null) {
            delay = Long.parseLong(System.getProperty("ducc.service.init.delay").trim());
        }
        logger.log(Level.INFO, "Wait for the initialized state to propagate to the SM so any processing errors are not treates as initialization failures - delay=" + delay);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected UimaSerializer getUimaSerializer() {
        return this.serializerMap.get(Thread.currentThread().getId());
    }

    protected void stop() throws Exception {
    }
}

