/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class JMXAgent {
    private JMXConnectorServer jmxConnector;
    private Logger logger;
    private String assignedJmxPort;

    public JMXAgent(String assignedJmxPort, Logger logger) {
        this.assignedJmxPort = assignedJmxPort;
        this.logger = logger;
    }

    public int initialize() throws ServiceInitializationException {
        String key = "com.sun.management.jmxremote.authenticate";
        String value = System.getProperty(key);
        this.logger.log(Level.INFO, key + "=" + value);
        int rmiRegistryPort = 2099;
        if (this.assignedJmxPort != null) {
            try {
                int tmp;
                rmiRegistryPort = tmp = Integer.parseInt(this.assignedJmxPort);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(Level.WARNING, "startJmxAgent", (Throwable)nfe);
            }
        }
        boolean done = false;
        while (!done) {
            try {
                LocateRegistry.createRegistry(rmiRegistryPort);
                done = true;
            }
            catch (Exception exx) {
                ++rmiRegistryPort;
            }
        }
        return rmiRegistryPort;
    }

    public String start(int rmiRegistryPort) throws ServiceInitializationException {
        JMXServiceURL url = null;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String hostname = InetAddress.getLocalHost().getHostName();
            String s = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", hostname, rmiRegistryPort);
            url = new JMXServiceURL(s);
            this.jmxConnector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
            this.jmxConnector.start();
        }
        catch (Exception e) {
            url = null;
            this.logger.log(Level.WARNING, "startJmxAgent Unable to Start JMX Connector. Running with *No* JMX Connectivity");
        }
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    public void stop() throws IOException {
        this.jmxConnector.stop();
    }
}

