/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.tools;

import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;

public class DuccPubListener
implements MessageListener {
    String host;
    int port;
    String topic_str;
    String[] agents;
    String outfn = null;
    int generation = 0;
    int timeout = 0;
    Map<String, Boolean> agentPresence = new HashMap<String, Boolean>();
    int total_agents = 0;
    Connection connection;
    Session session;
    Topic topic;
    boolean do_filter = false;

    public DuccPubListener(String host, int port, String topic_str, int timeout, String outfn, String[] agents) {
        this.host = host;
        this.port = port;
        this.topic_str = topic_str;
        this.timeout = timeout;
        this.outfn = outfn;
        this.agents = agents;
        for (String a : agents) {
            this.agentPresence.put(a, false);
        }
        this.total_agents = this.agentPresence.size();
        if ((topic_str.indexOf("metrics") >= 0 || topic_str.indexOf("inventory") >= 0) && this.total_agents > 0) {
            this.do_filter = true;
        }
    }

    protected void connect() throws Throwable {
        String url = "tcp://" + this.host + ":" + this.port;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(url);
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.topic = this.session.createTopic(this.topic_str);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.topic);
        consumer.setMessageListener((MessageListener)this);
        this.connection.start();
        if (this.timeout > 0) {
            try {
                Thread.sleep(this.timeout * 1000);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.close();
        }
    }

    protected void close() throws Throwable {
        this.connection.close();
        System.exit(0);
    }

    String receivedAgent(String msg) {
        String answer = null;
        for (String a : this.agents) {
            if (this.agentPresence.get(a).booleanValue() || msg.indexOf(a) < 0) continue;
            this.agentPresence.put(a, true);
            --this.total_agents;
            answer = a;
        }
        return answer;
    }

    void writeString(String fn, String msg) {
        try {
            FileWriter fw = new FileWriter(fn);
            fw.write(msg);
            fw.close();
            System.out.println(fn);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                String suffix = null;
                Serializable obj = ((ObjectMessage)message).getObject();
                Gson gson = new Gson();
                String msg = gson.toJson((Object)obj);
                suffix = ".json";
                if (!this.do_filter) {
                    String out = this.outfn + suffix;
                    if (this.timeout > 0) {
                        out = out + "." + ++this.generation;
                    }
                    this.writeString(out, msg);
                    if (this.timeout <= 0) {
                        this.close();
                    }
                } else {
                    String agent = this.receivedAgent(msg);
                    if (agent != null) {
                        String out = this.outfn + "." + agent + suffix;
                        this.writeString(out, msg);
                    }
                    if (this.total_agents == 0) {
                        this.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void run() {
        try {
            this.connect();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("Usage:");
        System.out.println("   DuccPubListener args");
        System.out.println("Where args are:");
        System.out.println("   -host AMQhostname");
        System.out.println("         Default is \"localhost\"");
        System.out.println("   -port AMQportname");
        System.out.println("         Default is 61616");
        System.out.println("   -topic topic");
        System.out.println("         No default, required");
        System.out.println("   -output outputFileName");
        System.out.println("         Default is topic");
        System.out.println("   -timeout timeInSeconds");
        System.out.println("         How long to listen.  Default is 0.  If 0, exit after first message.");
        System.out.println("   -agent agentname");
        System.out.println("         For agent broadcasts, which agent to listen for. Default is \"all\"");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            DuccPubListener.usage(null);
        }
        String[] agents = new String[]{"all"};
        String amqhost = "localhost";
        int amqport = 61616;
        int timeout = 0;
        String topic = null;
        String outfn = null;
        int i = 0;
        while (i < args.length) {
            if ("-agent".startsWith(args[i])) {
                agents = args[i + 1].split(",");
                ++i;
                ++i;
                continue;
            }
            if ("-host".startsWith(args[i])) {
                amqhost = args[i + 1];
                ++i;
                ++i;
                continue;
            }
            if ("-port".startsWith(args[i])) {
                try {
                    amqport = Integer.parseInt(args[i + 1]);
                }
                catch (Throwable t) {
                    DuccPubListener.usage("AMQ port is not numeric");
                }
                ++i;
                ++i;
                continue;
            }
            if ("-topic".startsWith(args[i])) {
                topic = args[i + 1];
                ++i;
                ++i;
                continue;
            }
            if ("-timeout".startsWith(args[i])) {
                try {
                    timeout = Integer.parseInt(args[i + 1]);
                }
                catch (Throwable t) {
                    DuccPubListener.usage("Timeout is not numeric");
                }
                ++i;
                ++i;
                continue;
            }
            if ("-output".startsWith(args[i])) {
                outfn = args[i + 1];
                ++i;
                ++i;
                continue;
            }
            DuccPubListener.usage(null);
        }
        if (topic == null) {
            DuccPubListener.usage("Must specify topic");
        }
        if (outfn == null) {
            outfn = topic;
        }
        DuccPubListener dl = new DuccPubListener(amqhost, amqport, topic, timeout, outfn, agents);
        dl.run();
    }
}

