/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sampleapps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.ducc.sampleapps.DuccDocumentInfo;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.TypeSystemUtil;
import org.apache.uima.util.XMLSerializer;

public class DuccCasCC
extends JCasAnnotator_ImplBase {
    public static final String PARAM_XMICOMPRESSIONLEVEL = "XmiCompressionLevel";
    public static final String PARAM_USEBINARYCOMPRESSION = "UseBinaryCompression";
    private Logger logger;
    private String outputFilename = null;
    private File outFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private boolean useBinaryCas;
    private int zipCompLevel;
    private String casExt;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.zipCompLevel = (Integer)this.getContext().getConfigParameterValue(PARAM_XMICOMPRESSIONLEVEL);
        this.useBinaryCas = null == this.getContext().getConfigParameterValue(PARAM_USEBINARYCOMPRESSION) ? Boolean.FALSE : (Boolean)this.getContext().getConfigParameterValue(PARAM_USEBINARYCOMPRESSION);
        this.logger = aContext.getLogger();
        if (this.useBinaryCas) {
            this.zipCompLevel = 0;
            this.casExt = "cas";
            this.logger.log(Level.INFO, "Outputting CASes in UIMA compressed binary form 6");
        } else {
            this.casExt = "xmi";
            this.logger.log(Level.INFO, "Outputting CASes in XmiCas format, zip compressed at level=" + this.zipCompLevel);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        FSIterator fsit = jcas.getIndexRepository().getAllIndexedFS(jcas.getCasType(Workitem.type));
        if (fsit.hasNext()) {
            Workitem wi = (Workitem)fsit.next();
            if (this.outputFilename == null || !this.outputFilename.equals(wi.getOutputspec())) {
                try {
                    this.outFile = new File(wi.getOutputspec());
                    File outDir = this.outFile.getParentFile();
                    if (outDir != null && !outDir.exists()) {
                        outDir.mkdirs();
                    }
                    this.zos = new ZipOutputStream(new FileOutputStream(this.outFile));
                    this.zos.close();
                    this.logger.log(Level.INFO, "DuccCasCC: Flushed empty " + wi.getOutputspec());
                    return;
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            try {
                this.zos.close();
                this.fos.close();
                if (!this.outFile.renameTo(new File(this.outputFilename))) {
                    throw new IOException("Rename failed for " + this.outputFilename);
                }
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            this.logger.log(Level.INFO, "DuccCasCC: Flushed " + wi.getOutputspec());
            return;
        }
        fsit = jcas.getIndexRepository().getAllIndexedFS(jcas.getCasType(DuccDocumentInfo.type));
        if (!fsit.hasNext()) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("No DuccDocumentInfo FS in CAS"));
        }
        DuccDocumentInfo di = (DuccDocumentInfo)((Object)fsit.next());
        String outputfile = di.getOutputfile();
        if (!outputfile.equals(this.outputFilename)) {
            this.outputFilename = outputfile;
            try {
                this.outFile = new File(this.outputFilename + "_temp");
                File outDir = this.outFile.getParentFile();
                if (outDir != null && !outDir.exists()) {
                    outDir.mkdirs();
                }
                this.fos = new FileOutputStream(this.outFile);
                this.zos = new ZipOutputStream(new BufferedOutputStream(this.fos, 102400));
                if (this.useBinaryCas) {
                    ZipEntry ze = new ZipEntry("typesystem.xml");
                    ze.setMethod(8);
                    this.zos.setLevel(9);
                    this.zos.putNextEntry(ze);
                    TypeSystem ts = jcas.getTypeSystem();
                    TypeSystemDescription tsDesc = TypeSystemUtil.typeSystem2TypeSystemDescription((TypeSystem)ts);
                    tsDesc.toXML((OutputStream)this.zos);
                    this.zos.closeEntry();
                }
                this.zos.setLevel(this.zipCompLevel);
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        ZipEntry ze = new ZipEntry("doc_" + di.getDocseq() + "." + this.casExt);
        ze.setMethod(8);
        try {
            this.zos.putNextEntry(ze);
            BufferedOutputStream bos = new BufferedOutputStream(this.zos, 10240);
            if (this.useBinaryCas) {
                Serialization.serializeWithCompression((CAS)jcas.getCas(), (Object)bos, (TypeSystem)jcas.getTypeSystem());
            } else {
                XmiCasSerializer ser = new XmiCasSerializer(jcas.getTypeSystem());
                XMLSerializer xmlSer = new XMLSerializer((OutputStream)bos, false);
                ser.serialize(jcas.getCas(), xmlSer.getContentHandler());
            }
            bos.flush();
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

