/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;

public class AnonymousPinger
extends AServicePing {
    String host;
    int port;

    public void init(String arguments, String endpoint) throws Exception {
        String[] parts;
        System.out.println("INIT: endpoint " + endpoint);
        System.out.println("Socket file: " + arguments);
        FileInputStream fis = new FileInputStream(arguments);
        byte[] bytes = new byte[128];
        int bytesread = fis.read(bytes);
        fis.close();
        String sockloc = new String(bytes, 0, bytesread);
        System.out.println("Service is listening at " + sockloc);
        for (String s : parts = sockloc.split(":")) {
            System.out.println("Parts: " + s);
        }
        this.host = parts[0];
        this.port = Integer.parseInt(parts[1]);
        System.out.println("Parsed service location to " + this.host + " : " + this.port);
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStatistics getStatistics() {
        ServiceStatistics stats = new ServiceStatistics(false, false, "<NA>");
        Socket sock = null;
        try {
            sock = new Socket(this.host, this.port);
            ObjectInputStream dis = new ObjectInputStream(sock.getInputStream());
            String response = (String)dis.readObject();
            System.out.println("Pong response: " + response);
            stats.setAlive(true);
            stats.setHealthy(true);
            stats.setInfo(response);
        }
        catch (Throwable t) {
            t.printStackTrace();
            stats.setInfo(t.getMessage());
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException e) {}
        }
        return stats;
    }

    public static void main(String[] args) {
        try {
            AnonymousPinger cp = new AnonymousPinger();
            cp.init(args[0], args[1]);
            for (int i = 0; i < 10; ++i) {
                ServiceStatistics stats = cp.getStatistics();
                System.out.println(stats);
                Thread.sleep(2000L);
            }
            cp.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

