/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class AnonymousService {
    String sockdir;

    AnonymousService(String sockdir) throws Exception {
        System.out.println("Custom Service starts");
        this.sockdir = sockdir;
        File f = new File(sockdir);
        if (f.exists() && f.isDirectory()) {
            System.out.println("Reusing socket dir: " + sockdir);
            return;
        }
        if (f.exists()) {
            throw new IllegalStateException("Socket tempdir conflict, exits but is not a directory: " + sockdir);
        }
        System.out.println("Making new sockdir: " + sockdir);
        f.mkdirs();
    }

    void startPingResponder() throws Exception {
        PingResponder pr = new PingResponder(this.sockdir);
        Thread prth = new Thread(pr);
        prth.start();
    }

    void run() throws Exception {
        this.startPingResponder();
        try {
            while (true) {
                System.out.println("Serving stuff");
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Args[" + i + "] = " + args[i]);
            }
        } else {
            System.out.println("No args, can't run");
            System.exit(1);
        }
        try {
            AnonymousService as = new AnonymousService(args[0]);
            as.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PingResponder
    implements Runnable {
        String sockdir;
        String hostname;

        PingResponder(String sockdir) throws Exception {
            this.sockdir = sockdir;
            this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
            System.out.println("Starting ping responder on " + this.hostname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket server = null;
            System.out.println("Waiting for ping");
            int pingid = 0;
            try {
                try {
                    server = new ServerSocket(0);
                    int port = server.getLocalPort();
                    System.out.println("ServicePingMain listens on port " + port);
                    File f = new File(this.sockdir + "/hostport");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write((this.hostname + ":" + port).getBytes());
                    fos.close();
                    while (true) {
                        Socket sock = server.accept();
                        ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
                        String reply = "Pong number " + pingid++;
                        System.out.println("Responding to ping: " + reply);
                        out.writeObject(reply);
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            finally {
                try {
                    server.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

