/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jp.classloader;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.container.jp.UimaProcessor;
import org.apache.uima.ducc.container.jp.iface.IJobProcessDeployer;
import org.apache.uima.ducc.container.jp.iface.IUimaProcessor;
import org.apache.uima.ducc.container.jp.iface.ServiceFailedInitialization;
import org.apache.uima.ducc.user.common.PrivateClassLoader;

public class JobProcessDeployer
implements IJobProcessDeployer {
    private static String M_DEPLOY = "deploy";
    private static String M_PROCESS = "process";
    private static String M_STOP = "stop";
    private static String M_LASTERROR = "getLastSerializedError";
    private static String M_INITIALIZE = "initialize";
    private boolean DEBUG = false;
    Method processMethod = null;
    Method stopMethod = null;
    Method deployMethod = null;
    Method lastErrorMethod = null;
    Object uimaContainerInstance = null;
    int scaleout = 1;

    @Override
    public int initialize(String userClasspath, String[] args, String clzToLoad) throws ServiceFailedInitialization {
        try {
            URLClassLoader ucl = PrivateClassLoader.create((String)userClasspath);
            Thread.currentThread().setContextClassLoader(ucl);
            Class<?> classToLaunch = ucl.loadClass(clzToLoad);
            if (this.DEBUG) {
                URL[] urls2;
                for (URL u : urls2 = ucl.getURLs()) {
                    System.out.println("-----------:" + u.getFile());
                }
            }
            Method initMethod = classToLaunch.getMethod(M_INITIALIZE, String[].class);
            this.processMethod = classToLaunch.getMethod(M_PROCESS, Object.class);
            this.stopMethod = classToLaunch.getMethod(M_STOP, new Class[0]);
            this.deployMethod = classToLaunch.getMethod(M_DEPLOY, String.class);
            this.lastErrorMethod = classToLaunch.getMethod(M_LASTERROR, new Class[0]);
            this.uimaContainerInstance = classToLaunch.newInstance();
            Object s = initMethod.invoke(this.uimaContainerInstance, new Object[]{args});
            this.scaleout = (Integer)s;
            return this.scaleout;
        }
        catch (Exception e) {
            throw new ServiceFailedInitialization(e);
        }
    }

    @Override
    public IUimaProcessor deploy() throws ServiceFailedInitialization {
        try {
            this.deployMethod.invoke(this.uimaContainerInstance, Utils.findDuccHome());
            return new UimaProcessor(this.uimaContainerInstance, this.processMethod, this.stopMethod, this.lastErrorMethod, this.scaleout);
        }
        catch (Exception e) {
            throw new ServiceFailedInitialization(e);
        }
    }
}

