/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.log;

import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerThread;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;

public class LoggerHelper {
    private static Logger logger = Logger.getLogger(LoggerHelper.class, IComponent.Id.JD.name());

    public static String getTransNo(IActionData actionData) {
        String retVal = "?";
        try {
            IMetaCasTransaction trans = actionData.getMetaCasTransaction();
            retVal = trans.getTransactionId().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getSeqNo(IActionData actionData) {
        String retVal = "?";
        try {
            IWorkItem wi = actionData.getWorkItem();
            retVal = LoggerHelper.getSeqNo(wi);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getSeqNo(IWorkItem wi) {
        String retVal = "?";
        try {
            IMetaCas metaCas = wi.getMetaCas();
            retVal = metaCas.getSystemKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getId(IWorkItem wi) {
        String retVal = "?";
        try {
            IMetaCas metaCas = wi.getMetaCas();
            retVal = metaCas.getUserKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getRemote(IActionData actionData) {
        String retVal = "?";
        try {
            IMetaCasTransaction trans = actionData.getMetaCasTransaction();
            RemoteWorkerThread rwt = new RemoteWorkerThread(trans);
            retVal = ((Object)rwt).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static MessageBuffer getMessageBuffer(IActionData actionData) {
        String location = "getMessageBuffer";
        MessageBuffer mb = new MessageBuffer();
        try {
            String seqNo = LoggerHelper.getSeqNo(actionData);
            String remote = LoggerHelper.getRemote(actionData);
            mb.append(Standardize.Label.seqNo.get() + seqNo);
            mb.append(Standardize.Label.remote.get() + remote);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return mb;
    }

    public static MessageBuffer getMessageBuffer(String transNo, String seqNo, String remote) {
        String location = "getMessageBuffer";
        MessageBuffer mb = new MessageBuffer();
        try {
            mb.append(Standardize.Label.seqNo.get() + seqNo);
            mb.append(Standardize.Label.remote.get() + remote);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return mb;
    }

    public static MessageBuffer getMessageBuffer(IMetaCasTransaction trans, IRemoteWorkerThread rwt) {
        String location = "getMessageBuffer";
        MessageBuffer mb = new MessageBuffer();
        try {
            mb.append(Standardize.Label.remote.get() + rwt.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return mb;
    }

    public static MessageBuffer getMessageBuffer(IWorkItem wi, IRemoteWorkerThread rwt) {
        String location = "getMessageBuffer";
        MessageBuffer mb = new MessageBuffer();
        try {
            mb.append(Standardize.Label.seqNo.get() + LoggerHelper.getSeqNo(wi));
            mb.append(Standardize.Label.id.get() + LoggerHelper.getId(wi));
            mb.append(Standardize.Label.remote.get() + rwt.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return mb;
    }
}

