/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.fsm.wi.WiFsm;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.container.net.iface.IMetaCas;

public class ActionGetRedux
implements IAction {
    private static Logger logger = Logger.getLogger(ActionGetRedux.class, IComponent.Id.JD.name());

    @Override
    public String getName() {
        return ActionGetRedux.class.getName();
    }

    @Override
    public void engage(Object objectData) {
        String location = "engage";
        logger.trace(location, ILogger.null_id, "");
        IActionData actionData = (IActionData)objectData;
        try {
            if (actionData != null) {
                IRemoteWorkerThread rwt = actionData.getRemoteWorkerThread();
                WiTracker tracker = WiTracker.getInstance();
                IWorkItem wi = tracker.find(rwt);
                if (wi != null) {
                    MessageBuffer mb;
                    IEvent event = WiFsm.CAS_Unavailable;
                    IMetaCas metaCas = wi.getMetaCas();
                    if (metaCas != null) {
                        event = WiFsm.CAS_Available;
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        logger.debug(location, ILogger.null_id, mb.toString());
                        actionData.getWorkItem().setMetaCas(metaCas);
                        actionData.getMetaCasTransaction().setMetaCas(metaCas);
                    } else {
                        mb = LoggerHelper.getMessageBuffer(actionData);
                        mb.append("No CAS found for processing");
                        logger.info(location, ILogger.null_id, mb.toString());
                    }
                    IFsm fsm = wi.getFsm();
                    fsm.transition(event, actionData);
                } else {
                    MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                    mb.append("No work item found for processing");
                    logger.warn(location, ILogger.null_id, mb.toString());
                }
            } else {
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append("No action data found for processing");
                logger.warn(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }
}

