/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.container.common.IJdConstants;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.MetaCasHelper;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverDirective;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverErrorHandler;
import org.apache.uima.ducc.container.jd.fsm.wi.Action;
import org.apache.uima.ducc.container.jd.fsm.wi.ActionHelper;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;

public abstract class ActionEndAbstract
extends Action
implements IAction {
    private Logger logger = Logger.getLogger(ActionEndAbstract.class, IComponent.Id.JD.name());

    protected ActionEndAbstract(Logger logger) {
        this.logger = logger;
    }

    private IJdConstants.DeallocateReason getDeallocateReason(ProxyJobDriverDirective pjdd) {
        IJdConstants.DeallocateReason deallocateReason = IJdConstants.DeallocateReason.WorkItemTimeout;
        return deallocateReason;
    }

    protected void handleException(IActionData actionData, ExceptionType exceptionType, Object userException, String printableException) throws JobDriverException {
        MessageBuffer mb;
        String location = "handleException";
        MessageBuffer mb2 = LoggerHelper.getMessageBuffer(actionData);
        mb2.append((Object)((Object)Standardize.Label.enter) + "");
        this.logger.debug(location, ILogger.null_id, mb2.toString());
        IWorkItem wi = actionData.getWorkItem();
        IMetaCasTransaction trans = actionData.getMetaCasTransaction();
        RemoteWorkerProcess rwp = new RemoteWorkerProcess(trans);
        IMetaCas metaCas = wi.getMetaCas();
        JobDriver jd = JobDriver.getInstance();
        JobDriverHelper jdh = JobDriverHelper.getInstance();
        CasManager cm = jd.getCasManager();
        IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
        MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
        IProcessStatistics pStats = jdh.getProcessStatistics(rwp);
        int seqNo = metaCasHelper.getSystemKey();
        try {
            switch (exceptionType) {
                case User: {
                    if (printableException != null) {
                        ActionHelper.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** EXCEPTION *****\n" + printableException);
                        break;
                    }
                    ActionHelper.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** EXCEPTION *****\n");
                    break;
                }
                case Timeout: {
                    ActionHelper.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** TIMEOUT *****\n" + userException.toString() + "\n");
                }
            }
        }
        catch (Exception e) {
            this.logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        ProxyJobDriverDirective pjdd = null;
        try {
            String serializedCas = (String)metaCas.getUserSpaceCas();
            ProxyJobDriverErrorHandler pjdeh = jd.getProxyJobDriverErrorHandler();
            pjdd = pjdeh.handle(serializedCas, userException);
        }
        catch (Exception e) {
            this.logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        if (pjdd != null) {
            mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append(Standardize.Label.isKillJob.get() + pjdd.isKillJob());
            mb.append(Standardize.Label.isKillProcess.get() + pjdd.isKillProcess());
            mb.append(Standardize.Label.isKillWorkItem.get() + pjdd.isKillWorkItem());
            this.logger.info(location, ILogger.null_id, mb.toString());
            if (pjdd.isKillJob()) {
                ActionHelper.killJob(this.logger, actionData, cm);
            }
            if (pjdd.isKillProcess()) {
                IJdConstants.DeallocateReason deallocateReason = this.getDeallocateReason(pjdd);
                ActionHelper.killProcess(this.logger, actionData, cm, metaCas, wi, deallocateReason);
            }
            if (pjdd.isKillWorkItem()) {
                wisk.error(seqNo);
                pStats.error(wi);
                ActionHelper.killWorkItem(this.logger, actionData, cm);
            } else {
                wisk.retry(seqNo);
                pStats.retry(wi);
                ActionHelper.retryWorkItem(this.logger, actionData, cm, metaCas);
            }
        } else {
            wisk.error(seqNo);
            pStats.error(wi);
            ActionHelper.killWorkItem(this.logger, actionData, cm);
        }
        mb = LoggerHelper.getMessageBuffer(actionData);
        mb.append((Object)((Object)Standardize.Label.exit) + "");
        this.logger.debug(location, ILogger.null_id, mb.toString());
    }

    public static enum ExceptionType {
        User,
        Timeout;

    }
}

