/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IOHelper;

public class ComponentHelper {
    private static final DuccLogger logger = DuccLogger.getLogger(ComponentHelper.class);

    public static void oneInstance(String directory, String componentName) {
        String methodName = "oneInstance";
        try {
            String hostname;
            IOHelper.mkdirs(directory);
            String filename = ComponentHelper.getLockFileNameWithPath(directory, componentName);
            File file = new File(filename);
            if (file.exists()) {
                logger.error(methodName, null, "found file " + filename);
                BufferedReader in = new BufferedReader(new FileReader(file));
                hostname = in.readLine();
                in.close();
                logger.error(methodName, null, "already running on host " + hostname);
                System.exit(-1);
            }
            file.deleteOnExit();
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(hostname + "\n");
            out.close();
        }
        catch (IOException e) {
            logger.error(methodName, null, e, new Object[0]);
        }
    }

    public static boolean isLocked(String directory, String componentName) {
        String filename = ComponentHelper.getLockFileNameWithPath(directory, componentName);
        File file = new File(filename);
        return file.exists();
    }

    public static String getLockFileNameWithPath(String directory, String componentName) {
        return directory + componentName + ".lock";
    }

    public static String getLockFileName(String directory, String componentName) {
        return componentName + ".lock";
    }
}

