/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.node.metrics;

import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class ByteBufferParser
implements Serializable {
    private static final long serialVersionUID = 5187826597226614457L;
    private int[] fieldOffsets;
    private int[] fieldLengths;
    private byte[] byteBuffer;

    public ByteBufferParser(byte[] byteBuffer, int[] fieldOffsets, int[] fieldLengths) {
        this.byteBuffer = byteBuffer;
        this.fieldOffsets = fieldOffsets;
        this.fieldLengths = fieldLengths;
    }

    protected byte[] getFieldAsByteArray(int fieldIndex) {
        byte[] b = new byte[this.fieldLengths[fieldIndex]];
        ByteBuffer bb = ByteBuffer.wrap(this.byteBuffer);
        bb.position(this.fieldOffsets[fieldIndex]);
        bb.get(b, 0, this.fieldLengths[fieldIndex]);
        return b;
    }

    protected String getFieldAsString(int fieldIndex) {
        return new String(this.getFieldAsByteArray(fieldIndex));
    }

    protected Long getFieldAsLong(int fieldIndex) {
        return Long.parseLong(new String(this.getFieldAsByteArray(fieldIndex)));
    }
}

