/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.user.common.PrivateClassLoader;
import org.apache.uima.ducc.user.common.QuotedOptions;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DuccUiUtilities {
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static String getUser() {
        String envUser;
        String user = System.getProperty("user.name");
        String runmode = DuccPropertiesResolver.get((String)"ducc.runmode");
        if (runmode != null && runmode.equals("Test") && (envUser = System.getenv(IDuccUser.EnvironmentVariable.USER.value())) != null) {
            user = envUser;
        }
        return user;
    }

    public static String fixupEnvironment(String environment, String allInOne, String logDirectory) {
        String envNames;
        ArrayList envList = QuotedOptions.tokenizeList((String)environment, (boolean)false);
        Map envMap = QuotedOptions.parseAssignments((List)envList, (int)1);
        if (allInOne == null || !allInOne.equalsIgnoreCase("local")) {
            String source = "LD_LIBRARY_PATH";
            String[] target = "DUCC_" + source;
            if (envMap.containsKey(source) && !envMap.containsKey(target)) {
                envMap.put(target, envMap.get(source));
                envMap.remove(source);
            }
        }
        if ((envNames = DuccPropertiesResolver.get((String)"ducc.environment.propagated")) != null) {
            for (String name : envNames.split("\\s+")) {
                String value;
                if (envMap.containsKey(name) || (value = QuotedOptions.quoteValue((String)name)) == null) continue;
                envMap.put(name, value);
            }
        }
        if (!envMap.containsKey("DUCC_UMASK")) {
            File f = new File(logDirectory);
            Path logDir = f.toPath();
            try {
                FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"));
                Path dir = Files.createTempDirectory(logDir, "ducc_umask", attr);
                Set<PosixFilePermission> perms = Files.getFileAttributeView(dir, PosixFileAttributeView.class, new LinkOption[0]).readAttributes().permissions();
                Files.delete(dir);
                int umask = 777;
                int[] bitVals = new int[]{400, 200, 100, 40, 20, 10, 4, 2, 1};
                for (PosixFilePermission perm : perms) {
                    umask -= bitVals[perm.ordinal()];
                }
                envMap.put("DUCC_UMASK", String.format("%03d", umask));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("fixupEnvironment: failed to create temporary directory in log_directory - " + e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String name : envMap.keySet()) {
            sb.append(name).append("=").append((String)envMap.get(name)).append(" ");
        }
        return sb.toString();
    }

    public static String dispatchUrl(String server) {
        String host = DuccPropertiesResolver.get((String)("ducc." + server + ".http.node"));
        String port = DuccPropertiesResolver.get((String)("ducc." + server + ".http.port"));
        if (host == null || port == null) {
            throw new IllegalStateException("ducc." + server + ".http.node and/or .port not set in ducc.properties");
        }
        return "http://" + host + ":" + port + "/" + server.substring(0, 2);
    }

    private static void secureDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        try {
            documentBuilderFactory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        catch (ParserConfigurationException e1) {
            UIMAFramework.getLogger().log(Level.WARNING, "DocumentBuilderFactory didn't recognize setting feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        try {
            documentBuilderFactory.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (ParserConfigurationException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "DocumentBuilderFactory doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
    }

    public static String getEndpoint(String working_dir, String process_DD, String jvmargs, String classpath) {
        if (!process_DD.startsWith("/") && process_DD.endsWith(".xml") && working_dir != null) {
            process_DD = working_dir + "/" + process_DD;
        }
        Document doc = null;
        try {
            XMLInputSource xmlin;
            if (!process_DD.endsWith(".xml") && classpath != null) {
                URLClassLoader classLoader = PrivateClassLoader.create((String)classpath);
                xmlin = UimaUtils.getXMLInputSource((String)process_DD, (ClassLoader)classLoader);
            } else {
                xmlin = UimaUtils.getXMLInputSource((String)process_DD);
            }
            DocumentBuilder db = null;
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DuccUiUtilities.secureDocumentBuilderFactory(f);
            db = f.newDocumentBuilder();
            doc = db.parse(xmlin.getInputStream());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException(t.getMessage());
        }
        NodeList nodes = doc.getElementsByTagName("inputQueue");
        if (nodes.getLength() > 0) {
            int i;
            Element element = (Element)nodes.item(0);
            String endpoint = element.getAttribute("endpoint");
            String broker = element.getAttribute("brokerURL");
            if (endpoint.contains("${") || broker.contains("${")) {
                ArrayList jvmargList = QuotedOptions.tokenizeList((String)jvmargs, (boolean)true);
                Map jvmargMap = QuotedOptions.parseAssignments((List)jvmargList, (int)-1);
                endpoint = DuccUiUtilities.resolvePlaceholders(endpoint, jvmargMap);
                broker = DuccUiUtilities.resolvePlaceholders(broker, jvmargMap);
            }
            if ((i = broker.indexOf(63)) > 0) {
                broker = broker.substring(0, i);
            }
            String ep = "UIMA-AS:" + endpoint + ":" + broker;
            return ep;
        }
        throw new IllegalArgumentException("Invalid DD:" + process_DD + ". Missing required element <inputQueue ...");
    }

    public static String check_service_dependencies(String endpoint, String dependency_string) {
        if (dependency_string == null) {
            return null;
        }
        StringBuilder deps = new StringBuilder();
        for (String d : dependency_string.split("\\s+")) {
            String[] parts = d.split(":", 3);
            String type = parts[0];
            if (type.equals(IService.ServiceType.UimaAs.decode())) {
                if (parts.length < 3) {
                    throw new IllegalArgumentException("Invalid UIMA-AS service id: " + d);
                }
                String qname = parts[1];
                String broker = parts[2];
                if (qname.equals("") || broker.equals("")) {
                    throw new IllegalArgumentException("Invalid syntax for UIMA-AS service id: " + d);
                }
                URL url = null;
                try {
                    url = new URL(null, broker, (URLStreamHandler)new TcpStreamHandler());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid broker URL '" + broker + "' in service ID '" + d + "'");
                }
                int ix = broker.indexOf(63);
                if (ix > 0) {
                    System.out.println("WARNING: Ignoring URL decorations on service ID " + d);
                    d = parts[0] + ":" + parts[1] + ":" + broker.substring(0, ix);
                }
            } else if (!type.equals(IService.ServiceType.Custom.decode())) {
                throw new IllegalArgumentException("Ill-formed or unsupported service type in dependency: '" + d + "'");
            }
            if (d.equals(endpoint)) {
                throw new IllegalArgumentException("A service cannot depend on itself: " + d);
            }
            deps.append(d).append(" ");
        }
        return deps.substring(0, deps.length() - 1);
    }

    private static String resolvePlaceholders(String contents, Map<String, String> argMap) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = argMap.get(key);
            if (value == null) {
                throw new IllegalArgumentException("Undefined JVM property '" + key + "' in: " + contents);
            }
            matcher.appendReplacement(sb, "");
            sb.append(value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

