/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.Properties;

public class CliFixups {
    static void cleanupArgs(String[] args, String className) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--process_DD")) {
                args[i] = "--process_descriptor_DD";
                continue;
            }
            if (arg.equals("--instance_memory_size")) {
                args[i] = "--memory_size";
                continue;
            }
            if (arg.equals("--classpath_order")) {
                args[i] = null;
                if (++i >= args.length || args[i].startsWith("--")) continue;
                args[i] = null;
                continue;
            }
            if (arg.equals("--number_of_instances")) {
                if (++i >= args.length || !args[i].trim().equals("1")) continue;
                args[i] = null;
                args[i - 1] = null;
                continue;
            }
            if (arg.equals("--process_thread_count")) {
                args[i] = "--process_pipeline_count";
                continue;
            }
            if (!arg.equals("--process_get_meta_time_max")) continue;
            args[i] = null;
            if (++i >= args.length || args[i].startsWith("--")) continue;
            args[i] = null;
        }
    }

    static void cleanupProps(Properties props, String className) {
        CliFixups.changeOption("process_DD", "process_descriptor_DD", props);
        CliFixups.changeOption("instance_memory_size", "memory_size", props);
        CliFixups.changeOption("classpath_order", null, props);
        CliFixups.changeOption("process_thread_count", "process_pipeline_count", props);
        String val = props.getProperty("number_of_instances");
        if (val != null && val.trim().equals("1")) {
            CliFixups.changeOption("number_of_instances", null, props);
        }
        CliFixups.changeOption("process_get_meta_time_max", null, props);
    }

    private static void changeOption(String oldKey, String newKey, Properties props) {
        String val = props.getProperty(oldKey);
        if (val != null) {
            props.remove(oldKey);
            if (newKey != null) {
                props.put(newKey, val);
            }
        }
    }
}

