/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.Pair;

class ConsoleListener
implements Runnable {
    private ServerSocket sock;
    private CliBase submit;
    private Map<Integer, Pair<StdioReader, StdioWriter>> listeners = new HashMap<Integer, Pair<StdioReader, StdioWriter>>();
    private String console_host_address;
    private boolean in_shutdown = false;
    private boolean start_stdin = false;
    private int nextIdNum = 2;
    private volatile PrintWriter shared_logout = null;
    private IDuccCallback consoleCb;
    boolean debug = false;
    private boolean suppress_log;

    ConsoleListener(CliBase submit, IDuccCallback consoleCb) throws Exception {
        this.submit = submit;
        this.sock = new ServerSocket(0);
        this.consoleCb = consoleCb;
        NodeIdentity ni = new NodeIdentity();
        String host_address = ni.getIp();
        int console_listener_port = this.sock.getLocalPort();
        this.console_host_address = host_address + ":" + console_listener_port;
        this.debug = submit.debug;
        this.suppress_log = submit.suppress_console_log;
    }

    String getConsoleHostAddress() {
        return this.console_host_address;
    }

    synchronized boolean isShutdown() {
        return this.in_shutdown;
    }

    void shutdown() {
        if (this.debug) {
            System.out.println("Console handler: Shutdown starts");
        }
        this.in_shutdown = true;
        try {
            this.sock.close();
            for (Pair<StdioReader, StdioWriter> handler : this.listeners.values()) {
                ((StdioReader)handler.first()).shutdown();
                ((StdioWriter)handler.second()).shutdown();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(int port) {
        int count;
        ConsoleListener consoleListener = this;
        synchronized (consoleListener) {
            Pair<StdioReader, StdioWriter> listener = this.listeners.remove(port);
            if (listener != null) {
                try {
                    ((StdioReader)listener.first()).shutdown();
                    ((StdioWriter)listener.second()).shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            count = this.listeners.size();
        }
        if (this.debug) {
            System.out.println("Console handler: Removed handler for port " + port + ", size = " + this.listeners.size());
        }
        if (count == 0) {
            this.shutdown();
        }
    }

    void startStdin(boolean start_stdin) {
        this.start_stdin = start_stdin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.debug) {
            System.out.println("Listening on " + this.console_host_address);
        }
        try {
            while (true) {
                Socket s = this.sock.accept();
                StdioReader sr = new StdioReader(s);
                StdioWriter sw = new StdioWriter(s);
                int p = s.getPort();
                ConsoleListener consoleListener = this;
                synchronized (consoleListener) {
                    this.listeners.put(p, (Pair<StdioReader, StdioWriter>)new Pair((Object)sr, (Object)sw));
                    sr.idNum = this.nextIdNum++;
                }
                Thread t = new Thread((Runnable)sr, "STDOUT");
                t.start();
                if (!this.start_stdin) continue;
                Thread tt = new Thread((Runnable)sw, "STDIN");
                tt.start();
            }
        }
        catch (Throwable t) {
            if (!this.in_shutdown) {
                this.shutdown();
            }
            if (this.debug) {
                System.out.println("console listener returns");
            }
            this.submit.consoleExits();
            return;
        }
    }

    class StdioWriter
    implements Runnable {
        Socket sock;
        OutputStream out;
        boolean done = false;
        boolean is_shutdown = false;

        StdioWriter(Socket sock) {
            this.sock = sock;
        }

        synchronized void shutdown() {
            this.is_shutdown = true;
        }

        private void close() {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                if (ConsoleListener.this.debug) {
                    System.out.println("STDIN LISTENER STARTS *******");
                }
                try {
                    this.out = this.sock.getOutputStream();
                }
                catch (Exception e) {
                    System.out.println("Cannot acquire remote socket for stdin redirection: " + e.toString());
                    return;
                }
                byte[] buf = new byte[4096];
                int dbg = 0;
                while (true) {
                    try {
                        int cnt;
                        while ((cnt = System.in.available()) > 0) {
                            while (cnt > 0) {
                                int min = Math.min(cnt, buf.length);
                                System.in.read(buf, 0, min);
                                this.out.write(buf, 0, min);
                                cnt -= min;
                            }
                        }
                        StdioWriter min = this;
                        synchronized (min) {
                            if (this.is_shutdown) {
                                break block18;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                            if (++dbg % 100 != 0 || !ConsoleListener.this.debug) continue;
                            System.out.println("STDIN: Sleep: " + dbg);
                        }
                        catch (InterruptedException e) {
                            break block18;
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Error in process stdin redirection - redirection ended. " + e.toString());
                        break block18;
                    }
                }
                finally {
                    this.close();
                }
            }
            if (ConsoleListener.this.debug) {
                System.out.println("***********STDIN returns");
            }
        }
    }

    class StdioReader
    implements Runnable {
        Socket sock;
        InputStream is;
        boolean shutdown = false;
        ConsoleListener cl;
        String remote_host;
        private PrintWriter logout = null;
        static final String stream_tag = "1500 Stream: ";
        static final String console_tag = "1002 CONSOLE_REDIRECT ";
        int tag_len = 0;
        private int idNum;
        private boolean is_stderr = false;
        boolean do_console_out = ConsoleListener.access$200(ConsoleListener.this);
        String partial = null;

        StdioReader(Socket sock) {
            this.sock = sock;
            InetAddress ia = sock.getInetAddress();
            this.remote_host = ia.getHostName();
            this.tag_len = console_tag.length();
            if (ConsoleListener.this.debug) {
                System.out.println("===== Listener starting: " + this.remote_host + ":" + sock.getPort());
            }
        }

        public void shutdown() throws Exception {
            if (this.shutdown) {
                return;
            }
            if (ConsoleListener.this.debug) {
                System.out.println("===== Listener completing: " + this.remote_host + ":" + this.sock.getPort());
            }
            this.shutdown = true;
            this.is.close();
            if (this.logout != null) {
                this.logout.close();
            }
            ConsoleListener.this.delete(this.sock.getPort());
        }

        void doWrite(String line) {
            if (line.startsWith(stream_tag)) {
                String name = line.substring(stream_tag.length());
                this.is_stderr = name.startsWith("STDERR");
                if (this.is_stderr) {
                    this.do_console_out = true;
                    this.idNum = 1;
                } else {
                    this.idNum = 0;
                }
                return;
            }
            if (line.startsWith(console_tag) && !ConsoleListener.this.suppress_log) {
                String logfile = line.substring(this.tag_len);
                try {
                    this.logout = new PrintWriter(logfile);
                    if (this.idNum == 0) {
                        ConsoleListener.this.shared_logout = this.logout;
                    }
                }
                catch (FileNotFoundException e) {
                    ConsoleListener.this.consoleCb.status("Failed to create log file: " + logfile);
                    e.printStackTrace();
                }
                return;
            }
            if (this.logout == null && this.idNum == 1) {
                this.logout = ConsoleListener.this.shared_logout;
            }
            if (this.logout != null) {
                this.logout.println(line);
            }
            if (this.do_console_out) {
                ConsoleListener.this.consoleCb.console(this.idNum, line);
            } else if (line.startsWith("1001 Command launching...")) {
                this.do_console_out = true;
            }
        }

        public void printlines(byte[] buf, int count) {
            String tmp = new String(buf, 0, count);
            String[] lines = tmp.split("\n");
            int len = lines.length - 1;
            if (len < 0) {
                if (this.partial != null) {
                    this.doWrite(this.partial);
                    this.partial = null;
                }
                return;
            }
            if (this.partial != null) {
                lines[0] = this.partial + lines[0];
                this.partial = null;
            }
            for (int i = 0; i < len; ++i) {
                this.doWrite(lines[i]);
            }
            if (tmp.endsWith("\n")) {
                this.doWrite(lines[len]);
                this.partial = null;
            } else {
                this.partial = lines[len];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf = new byte[4096];
            try {
                this.is = this.sock.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            try {
                int count = 0;
                while ((count = this.is.read(buf)) > 0) {
                    this.printlines(buf, count);
                }
                if (ConsoleListener.this.debug) {
                    System.out.println(this.remote_host + ": EOF:  exiting");
                }
            }
            catch (Throwable t) {
                if (this.shutdown) {
                    if (ConsoleListener.this.debug) {
                        System.out.println(this.remote_host + ":" + this.sock.getPort() + " ignore read error after shutdoen - id# " + this.idNum);
                    }
                } else {
                    System.out.println(this.remote_host + ":" + this.sock.getPort() + " read error - id# " + this.idNum);
                    t.printStackTrace();
                }
            }
            finally {
                try {
                    this.shutdown();
                }
                catch (Throwable count) {}
            }
        }
    }
}

