/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.transport.event.AbstractDuccOrchestratorEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;

public class DuccReservationSubmit
extends CliBase {
    ReservationRequestProperties requestProperties = new ReservationRequestProperties();
    IDuccCallback resCB = new ReservationCallback();
    private String nodeList = "";
    IUiOptions.UiOption[] opts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.Specification, IUiOptions.UiOption.ReservationMemorySize, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.WaitForCompletion, IUiOptions.UiOption.CancelOnInterrupt};

    public DuccReservationSubmit(String[] args) throws Exception {
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.requestProperties, this.resCB);
    }

    public DuccReservationSubmit(ArrayList<String> args) throws Exception {
        String[] arg_array = args.toArray(new String[args.size()]);
        this.init(this.getClass().getName(), this.opts, arg_array, (DuccProperties)this.requestProperties, this.resCB);
    }

    public DuccReservationSubmit(Properties props) throws Exception {
        this.init(this.getClass().getName(), this.opts, props, (DuccProperties)this.requestProperties, this.resCB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws Exception {
        String[] reserveClasses;
        String pname = IUiOptions.UiOption.SchedulingClass.pname();
        String scheduling_class = this.requestProperties.getProperty(pname);
        if (scheduling_class != null && !Arrays.asList(reserveClasses = DuccSchedulerClasses.getInstance().getReserveClasses()).contains(scheduling_class)) {
            throw new IllegalArgumentException("Invalid value for scheduling_class - must be one of the reserve classes");
        }
        SubmitReservationDuccEvent ev = new SubmitReservationDuccEvent((DuccProperties)this.requestProperties, CliVersion.getVersion());
        SubmitReservationReplyDuccEvent reply = null;
        try {
            reply = (SubmitReservationReplyDuccEvent)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
        }
        catch (Exception e) {
            this.message("Reservation not submitted:", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.dispatcher.close();
        }
        boolean rc = this.extractReply((AbstractDuccOrchestratorEvent)reply);
        if (rc) {
            if (!this.commandLine.contains(IUiOptions.UiOption.WaitForCompletion)) {
                this.requestProperties.setProperty(IUiOptions.UiOption.WaitForCompletion.pname(), "");
            }
            this.startMonitors(false, IDuccContext.DuccContext.Reservation);
        }
        return rc;
    }

    public String getHost() {
        return this.nodeList;
    }

    @Deprecated
    public String[] getHosts() {
        return this.nodeList.split("\\s");
    }

    @Deprecated
    public String getHostsAsString() {
        return this.nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int code = 1;
        try {
            DuccReservationSubmit ds = new DuccReservationSubmit(args);
            boolean rc = ds.execute();
            if (rc) {
                System.out.println("Reservation " + ds.getDuccId() + " submitted.");
                code = ds.getReturnCode();
                String node = ds.getHost();
                if (!node.isEmpty()) {
                    System.out.println("Node: " + node);
                }
            } else {
                System.out.println("Could not submit reservation.");
            }
        }
        catch (Exception e) {
            System.out.println("Cannot initialize: " + e.getMessage() + ".");
        }
        finally {
            System.exit(code);
        }
    }

    private class ReservationCallback
    implements IDuccCallback {
        private final String nodesPrefix = "nodes: ";

        private ReservationCallback() {
        }

        @Override
        public void console(int pnum, String msg) {
            System.out.println("[" + pnum + "] " + msg);
        }

        @Override
        public void status(String msg) {
            if (msg.startsWith("nodes: ")) {
                DuccReservationSubmit.this.nodeList = msg.substring("nodes: ".length());
            } else {
                System.out.println(msg);
            }
        }
    }
}

