/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import org.apache.uima.ducc.common.jd.plugin.IJdProcessExceptionHandler;
import org.apache.uima.ducc.transport.event.cli.JobReplyProperties;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.JobSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;

public interface IUiOptions {
    public static final int help_width = 120;

    public static enum ClasspathOrderParms {
        UserBeforeDucc{

            @Override
            public String pname() {
                return "user-before-ducc";
            }

            @Override
            public String description() {
                return "Start process with user's classpath ahead of DUCC's";
            }
        }
        ,
        DuccBeforeUser{

            @Override
            public String pname() {
                return "ducc-before-user";
            }

            @Override
            public String description() {
                return "Start process with DUCC's classpath ahead of user's";
            }
        }
        ,
        Unknown{

            @Override
            public String pname() {
                return "unknown";
            }

            @Override
            public String description() {
                return "Illegal argument";
            }
        };


        public abstract String pname();

        public abstract String description();
    }

    public static enum UiOption {
        Activate{

            @Override
            public String pname() {
                return "activate";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "If present, apply current service updates to the running instances..";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        AllInOne{

            @Override
            public String pname() {
                return "all_in_one";
            }

            @Override
            public String argname() {
                return "local|remote";
            }

            @Override
            public String description() {
                return "Run driver and pipeline in single process.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        AttachConsole{

            @Override
            public String pname() {
                return "attach_console";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "If specified, redirect remote stdout and stderr to the local submitting console.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Autostart{

            @Override
            public String pname() {
                return "autostart";
            }

            @Override
            public String argname() {
                return "boolean: true or false";
            }

            @Override
            public String description() {
                return "If True, start the service when DUCC starts.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        CancelOnInterrupt{

            @Override
            public String pname() {
                return SpecificationProperties.key_cancel_on_interrupt;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Cancel on interrupt (Ctrl-C). Implies " + WaitForCompletion.pname();
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Classpath{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_classpath;
            }

            @Override
            public String description() {
                return "Classpath for the Job. Default is current classpath.";
            }

            @Override
            public String argname() {
                return "java classpath";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return "ClassPath";
            }
        }
        ,
        ClasspathOrder{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_classpath_order;
            }

            @Override
            public String argname() {
                return ClasspathOrderParms.UserBeforeDucc.pname() + " or " + ClasspathOrderParms.DuccBeforeUser.pname();
            }

            @Override
            public String description() {
                return "Specify user-supplied classpath before DUCC-supplied classpath, or the reverse.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return ClasspathOrderParms.DuccBeforeUser.pname();
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Debug{

            @Override
            public String pname() {
                return "debug";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Enable CLI Debugging messages.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        DjPid{

            @Override
            public String pname() {
                return JobRequestProperties.key_dpid;
            }

            @Override
            public String argname() {
                return "number";
            }

            @Override
            public String description() {
                return "DUCC Process Id.  If specified only this DUCC process will be canceled.  If not specified, then entire job will be canceled.";
            }

            @Override
            public String example() {
                return "22";
            }

            @Override
            public String label() {
                return "Ducc Process Id";
            }
        }
        ,
        DriverDebug{

            @Override
            public String pname() {
                return "driver_debug";
            }

            @Override
            public String argname() {
                return "debugger-port-number";
            }

            @Override
            public String description() {
                return "Append JVM debug flags to the jvm arguments to start the JobDriver in remote debug mode.";
            }

            @Override
            public String example() {
                return "driver_debug 8001";
            }

            @Override
            public String label() {
                return "ProcessDebug";
            }
        }
        ,
        Description{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_description;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Description of the run.";
            }

            @Override
            public String example() {
                return "My excellent job!";
            }

            @Override
            public String deflt() {
                return "none";
            }

            @Override
            public String label() {
                return "Description";
            }
        }
        ,
        DriverDescriptorCR{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_descriptor_CR;
            }

            @Override
            public String description() {
                return "Driver (collection reader) descriptor.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCR.xml";
            }

            @Override
            public String label() {
                return "DriverDescriptorCR";
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        DriverDescriptorCROverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_descriptor_CR_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Driver Collection Reader configuration parameter name/value pair overrides. Parameters must already be defined in the CR descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1,name2=\"value2a value2b value2c\",name3=value3...";
            }

            @Override
            public String label() {
                return "DriverDescriptorCROverrides";
            }
        }
        ,
        DriverExceptionHandler{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_exception_handler;
            }

            @Override
            public String description() {
                return "Driver Exception handler class.  Must implement " + IJdProcessExceptionHandler.class.getName();
            }

            @Override
            public String argname() {
                return "classname";
            }

            @Override
            public String example() {
                return "org.bob.myProject.MyDriverExceptionHandler";
            }

            @Override
            public String label() {
                return "DriverExceptionHandler";
            }
        }
        ,
        DriverJvmArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_driver_jvm_args;
            }

            @Override
            public String argname() {
                return "jvm arguments";
            }

            @Override
            public String description() {
                return "Blank-delimited list of JVM Arguments passed to the job driver.";
            }

            @Override
            public String example() {
                return "-Xmx100M -DMYVAR=foo";
            }

            @Override
            public String label() {
                return "DriverJvmArgs";
            }
        }
        ,
        Environment{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_environment;
            }

            @Override
            public String argname() {
                return "env vars";
            }

            @Override
            public String description() {
                return "Blank-delimited list of environment variables.";
            }

            @Override
            public String example() {
                return "TERM=xterm DISPLAY=me.org.net:1.0";
            }

            @Override
            public String label() {
                return "Environment";
            }
        }
        ,
        Help{

            @Override
            public String pname() {
                return "help";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Print this help message";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Instances{

            @Override
            public String pname() {
                return "instances";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String description() {
                return "Number of service processes.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        InstanceFailuresLimit{

            @Override
            public String pname() {
                return "instance_failures_limit";
            }

            @Override
            public String description() {
                return "Number of consecutive instance failures that will cause the service to be stopped.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return "2";
            }

            @Override
            public String label() {
                return "InstanceFailuresLimit";
            }
        }
        ,
        JobId{

            @Override
            public String pname() {
                return JobRequestProperties.key_id;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "The id of the job";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ManagedReservationId{

            @Override
            public String pname() {
                return JobRequestProperties.key_id;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "The id of the managed reservation";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        Jvm{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_jvm;
            }

            @Override
            public String argname() {
                return "path-name-to-java";
            }

            @Override
            public String description() {
                return "The jvm to use.  Must be a full path to the 'java' executable.  Default is\n   the jvm that DUCC is using.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return "Jvm";
            }
        }
        ,
        LogDirectory{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_log_directory;
            }

            @Override
            public String argname() {
                return "path";
            }

            @Override
            public String description() {
                return "The directory where logs are written.  Default: $HOME/ducc/logs";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return "LogDirectory";
            }
        }
        ,
        Message{

            @Override
            public String pname() {
                return JobReplyProperties.key_message;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Orchestrator response string - internally generated.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Modify{

            @Override
            public String pname() {
                return "modify";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String description() {
                return "Modify meta properties for a registered service.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        NumberOfInstances{

            @Override
            public String pname() {
                return ReservationSpecificationProperties.key_number_of_instances;
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String description() {
                return "Number of instances to reserve";
            }

            @Override
            public String example() {
                return "1";
            }

            @Override
            public String deflt() {
                return "1";
            }

            @Override
            public String label() {
                return "Number of instances";
            }
        }
        ,
        Quiet{

            @Override
            public String pname() {
                return "quiet";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Disable CLI Informational messages.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Register{

            @Override
            public String pname() {
                return "register";
            }

            @Override
            public String argname() {
                return "specification-file (optional)";
            }

            @Override
            public String description() {
                return "Register a service.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingArguments{

            @Override
            public String pname() {
                return "service_ping_arguments";
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Any (service-dependent) ping arguments, to be passed to the pinger.";
            }

            @Override
            public String example() {
                return "q_thresh=12,svc_thresh=.01";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingClass{

            @Override
            public String pname() {
                return "service_ping_class";
            }

            @Override
            public String argname() {
                return "classname";
            }

            @Override
            public String description() {
                return "Class to ping ervice, must extend AServicePing.java";
            }

            @Override
            public String example() {
                return "org.bob.Pinger";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingClasspath{

            @Override
            public String pname() {
                return "service_ping_classpath";
            }

            @Override
            public String argname() {
                return "classpath";
            }

            @Override
            public String description() {
                return "Classpath containing service_custom_ping class and dependencies.";
            }

            @Override
            public String example() {
                return "Bob.jar";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingJvmArgs{

            @Override
            public String pname() {
                return "service_ping_jvm_args";
            }

            @Override
            public String argname() {
                return "java-system-property-assignments";
            }

            @Override
            public String description() {
                return "-D jvm system property assignments to pass to jvm";
            }

            @Override
            public String example() {
                return "-DxmX=3";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingTimeout{

            @Override
            public String pname() {
                return "service_ping_timeout";
            }

            @Override
            public String argname() {
                return "time-in-ms";
            }

            @Override
            public String description() {
                return "Time in milliseconds to wait for a ping to the service.";
            }

            @Override
            public String example() {
                return "1000";
            }

            @Override
            public String deflt() {
                return "500";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServicePingDoLog{

            @Override
            public String pname() {
                return "service_ping_dolog";
            }

            @Override
            public String argname() {
                return "boolean";
            }

            @Override
            public String description() {
                return "If specified, log the pinger, else suppress the log.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServiceTypeCustom{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_custom;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        ServiceTypeOther{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_other;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        ServiceTypeUima{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_type_uima;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Service type - internally generated";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Start{

            @Override
            public String pname() {
                return "start";
            }

            @Override
            public String description() {
                return "Start a registered service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Stop{

            @Override
            public String pname() {
                return "stop";
            }

            @Override
            public String description() {
                return "Stop a registered service.";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        SubmitPid{

            @Override
            public String pname() {
                return JobRequestProperties.key_submitter_pid_at_host;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        ProcessDebug{

            @Override
            public String pname() {
                return "process_debug";
            }

            @Override
            public String argname() {
                return "debugger-port-number";
            }

            @Override
            public String description() {
                return "Listening port number the remote process is to connect to.";
            }

            @Override
            public String example() {
                return "8000";
            }

            @Override
            public String label() {
                return "ProcessDebug";
            }
        }
        ,
        ProcessDescriptorAE{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_AE;
            }

            @Override
            public String description() {
                return "Process Analysis Enginefor aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyAE.xml";
            }

            @Override
            public String label() {
                return "DriverDescriptorAE";
            }
        }
        ,
        ProcessDescriptorAEOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_AE_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process Analysis Engine configuration parameter name/value pair overrides. Parameters must already be defined in the AE descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1,name2=\"value2a value2b value2c\",name3=value3...";
            }

            @Override
            public String label() {
                return "ProcessDescriptorAEOverrides";
            }
        }
        ,
        ProcessDescriptorCC{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CC;
            }

            @Override
            public String description() {
                return "Process CAS Consumer for aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCC.xml";
            }

            @Override
            public String label() {
                return "DriverDescriptorCC";
            }
        }
        ,
        ProcessDescriptorCCOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CC_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process CAS Consumer configuration parameter name/value pair overrides. Parameters must already be defined in the CC descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1,name2=\"value2a value2b value2c\",name3=value3...";
            }

            @Override
            public String label() {
                return "ProcessDescriptorCCOverrides";
            }
        }
        ,
        ProcessDescriptorCM{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CM;
            }

            @Override
            public String description() {
                return "Process CAS Multiplier for aggregate.";
            }

            @Override
            public String argname() {
                return "descriptor xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyCM.xml";
            }

            @Override
            public String label() {
                return "DriverDescriptorCM";
            }
        }
        ,
        ProcessDescriptorCMOverrides{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_descriptor_CM_overrides;
            }

            @Override
            public String argname() {
                return "list of overrides";
            }

            @Override
            public String description() {
                return "Process CAS Multiplier configuration parameter name/value pair overrides. Parameters must already be defined in the CM descriptor.";
            }

            @Override
            public String example() {
                return "name1=value1,name2=\"value2a value2b value2c\",name3=value3...";
            }

            @Override
            public String label() {
                return "ProcessDescriptorCMOverrides";
            }
        }
        ,
        ProcessDD{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_DD;
            }

            @Override
            public String description() {
                return "Process deployment descriptor (mutually exclusive with CM+AE+CC).";
            }

            @Override
            public String argname() {
                return "dd.xml";
            }

            @Override
            public String example() {
                return "/home/" + System.getProperty("user.name") + "/descriptors/MyDD.xml";
            }

            @Override
            public String label() {
                return "ProcessDD";
            }
        }
        ,
        ProcessDeploymentsMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_deployments_max;
            }

            @Override
            public String description() {
                return "Maximum number of processes dispatched for this job at any time..";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return "ProcessDeploymentsMax";
            }
        }
        ,
        ProcessExecutable{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_executable;
            }

            @Override
            public String argname() {
                return "program name";
            }

            @Override
            public String description() {
                return "The full path to a program to be executed.";
            }

            @Override
            public String example() {
                return "/bin/ls";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ProcessExecutableArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_executable_args;
            }

            @Override
            public String argname() {
                return "argument list";
            }

            @Override
            public String description() {
                return "Blank-delimited list of arguments for " + ProcessExecutable.pname();
            }

            @Override
            public String example() {
                return "-a -t -l";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ProcessGetMetaTimeMax{

            @Override
            public String pname() {
                return "process_get_meta_time_max";
            }

            @Override
            public String description() {
                return "Maximum elapsed time (in minutes) for processing getMeta.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ProcessInitializationTimeMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_initialization_time_max;
            }

            @Override
            public String description() {
                return "Maximum elapsed time (in minutes) for processing initialization.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ProcessInitializationFailuresCap{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_initialization_failures_cap;
            }

            @Override
            public String description() {
                return "Number of unexpected job process initialization failures (i.e. System.exit(), kill-15...) before the number of Job Processes is capped at the number in state Running currently.  Default is " + this.deflt() + ".";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return "99";
            }

            @Override
            public String label() {
                return "ProcessInitializationFailuresCap";
            }
        }
        ,
        ProcessFailuresLimit{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_failures_limit;
            }

            @Override
            public String description() {
                return "Number of unexpected job process failures (i.e. System.exit(), kill-15...) that will cause the job to be terminated.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return "20";
            }

            @Override
            public String label() {
                return "ProcessFailuresLimit";
            }
        }
        ,
        ProcessJvmArgs{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_jvm_args;
            }

            @Override
            public String argname() {
                return "jvm arguments";
            }

            @Override
            public String description() {
                return "Blank-delimited list of JVM Arguments passed to each process";
            }

            @Override
            public String example() {
                return "-Xmx100M -DMYVAR=foo";
            }

            @Override
            public String label() {
                return "ProcessJvmArgs";
            }
        }
        ,
        ProcessMemorySize{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_memory_size;
            }

            @Override
            public String argname() {
                return "size-in-GB";
            }

            @Override
            public String description() {
                return "Maximum memory for each process, in GB.";
            }

            @Override
            public String example() {
                return "30";
            }

            @Override
            public String label() {
                return "ProcessMemorySize";
            }
        }
        ,
        ProcessThreadCount{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_thread_count;
            }

            @Override
            public String description() {
                return "Number of pipelines per deployment (i.e. UIMA pipelines per UIMA-AS service copy).";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return "4";
            }

            @Override
            public String label() {
                return "ProcessThreadCount";
            }
        }
        ,
        ProcessPerItemTimeMax{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_process_per_item_time_max;
            }

            @Override
            public String description() {
                return "Maximum elapsed time (in minutes) for processing one CAS.";
            }

            @Override
            public String argname() {
                return "integer";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Query{

            @Override
            public String pname() {
                return "query";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint (optional)";
            }

            @Override
            public String description() {
                return "Query a registered service, or all.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Reason{

            @Override
            public String pname() {
                return JobRequestProperties.key_reason;
            }

            @Override
            public String argname() {
                return "quoted text";
            }

            @Override
            public String description() {
                return "Reason for the cancel";
            }

            @Override
            public String example() {
                return "Back to the drawing board";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ReservationMemorySize{

            @Override
            public String pname() {
                return ReservationSpecificationProperties.key_instance_memory_size;
            }

            @Override
            public String argname() {
                return "size-in-GB";
            }

            @Override
            public String description() {
                return "Size of instance's memory, in GB.";
            }

            @Override
            public String example() {
                return "64";
            }

            @Override
            public String label() {
                return this.name();
            }

            @Override
            public boolean required() {
                return true;
            }
        }
        ,
        ReservationNodeList{

            @Override
            public String pname() {
                return ReservationRequestProperties.key_node_list;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Set of nodes reserved - internall generated.";
            }

            @Override
            public String example() {
                return "Back to the drawing board";
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        RoleAdministrator{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_role_administrator;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Act in the capacity of DUCC administrator.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        SchedulingClass{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_scheduling_class;
            }

            @Override
            public String argname() {
                return "scheduling class name";
            }

            @Override
            public String description() {
                return "The class to run the job in.";
            }

            @Override
            public String example() {
                return "normal";
            }

            @Override
            public String label() {
                return "SchedulingClass";
            }
        }
        ,
        ServiceLinger{

            @Override
            public String pname() {
                return "service_linger";
            }

            @Override
            public String argname() {
                return "milliseconds";
            }

            @Override
            public String description() {
                return "Time in milliseconds to wait after last referring job or service exits before stopping a non-autostarted service.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return "300000";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServiceDependency{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_service_dependency;
            }

            @Override
            public String argname() {
                return "list";
            }

            @Override
            public String description() {
                return "List of service descriptor strings.";
            }

            @Override
            public String example() {
                return "UIMA-AS:RandomSleepAE:tcp://node1:61616 CUSTOM:myservice";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        ServiceRequestEndpoint{

            @Override
            public String pname() {
                return ServiceRequestProperties.key_service_request_endpoint;
            }

            @Override
            public String argname() {
                return "string";
            }

            @Override
            public String description() {
                return "Unique id for this service. Usually inferred for UIMA-AS services.";
            }

            @Override
            public String example() {
                return "UIMA-AS:queueName:ActiveMqUrl";
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Signature{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_signature;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Specification{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_specification;
            }

            @Override
            public String sname() {
                return "f";
            }

            @Override
            public String argname() {
                return "file";
            }

            @Override
            public String description() {
                return "Properties file comprising the specification, where the keys are names of parameters. Individual parameters take precedence over those specified in properties file, if any.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        SubmitErrors{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_submit_errors;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        SubmitWarnings{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_submit_warnings;
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        SuppressConsoleLog{

            @Override
            public String pname() {
                return "suppress_console_log";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Do not copy stdout to a log file.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        Timestamp{

            @Override
            public String pname() {
                return "timestamp";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Enables timestamp on monitor messages.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return "ProcessTimestamp";
            }
        }
        ,
        Unregister{

            @Override
            public String pname() {
                return "unregister";
            }

            @Override
            public String argname() {
                return "service-id-or-endpoint";
            }

            @Override
            public String description() {
                return "Unregister a service.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        Update{

            @Override
            public String pname() {
                return "update";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "If specified, update service registry with accompanying parameters.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        User{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_user;
            }

            @Override
            public String argname() {
                return "userid";
            }

            @Override
            public String description() {
                return "Filled in (and overridden) by the CLI, the id of the submitting user.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return null;
            }
        }
        ,
        WaitForCompletion{

            @Override
            public String pname() {
                return "wait_for_completion";
            }

            @Override
            public String argname() {
                return null;
            }

            @Override
            public String description() {
                return "Do not exit until job is completed.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String label() {
                return this.name();
            }
        }
        ,
        WorkingDirectory{

            @Override
            public String pname() {
                return JobSpecificationProperties.key_working_directory;
            }

            @Override
            public String argname() {
                return "path";
            }

            @Override
            public String description() {
                return "The working directory set in each process. Default to current directory.";
            }

            @Override
            public String example() {
                return null;
            }

            @Override
            public String deflt() {
                return ".";
            }

            @Override
            public String label() {
                return "WorkingDirectory";
            }
        };


        public abstract String pname();

        public abstract String argname();

        public abstract String description();

        public abstract String example();

        public boolean multiargs() {
            return false;
        }

        public boolean required() {
            return false;
        }

        public String deflt() {
            return null;
        }

        public String label() {
            return null;
        }

        public String sname() {
            return null;
        }

        public String makeDesc() {
            if (this.example() == null) {
                return this.description();
            }
            return this.description() + "\nexample: " + this.example();
        }
    }
}

