/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;

public interface IServiceApi {

    public static enum ServiceOptions {
        Activate{

            @Override
            public String decode() {
                return "activate";
            }

            @Override
            public String description() {
                return "If True, sync the active instances with the end result of the modification.";
            }

            @Override
            public String argname() {
                return "none";
            }
        }
        ,
        Autostart{

            @Override
            public String decode() {
                return "autostart";
            }

            @Override
            public String description() {
                return "If True, start the service when DUCC starts.";
            }

            @Override
            public String argname() {
                return "boolean: true or false";
            }
        }
        ,
        Instances{

            @Override
            public String decode() {
                return "instances";
            }

            @Override
            public String description() {
                return "Number of instances to start or stop.";
            }

            @Override
            public String argname() {
                return "integer";
            }
        }
        ,
        MonitorPort{

            @Override
            public String decode() {
                return "monitor-port";
            }

            @Override
            public String description() {
                return "Activemq JMX port.";
            }

            @Override
            public String argname() {
                return "integer";
            }
        }
        ,
        Update{

            @Override
            public String decode() {
                return "update";
            }

            @Override
            public String description() {
                return "Update registry with start or stop.";
            }

            @Override
            public String argname() {
                return "none";
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "unknown";
            }

            @Override
            public String argname() {
                return "unknown";
            }
        };


        public abstract String decode();

        public abstract String description();

        public abstract String argname();

        public static ServiceOptions encode(String value) {
            if (value.equals(Activate.decode())) {
                return Activate;
            }
            if (value.equals(Autostart.decode())) {
                return Autostart;
            }
            if (value.equals(Instances.decode())) {
                return Instances;
            }
            if (value.equals(MonitorPort.decode())) {
                return MonitorPort;
            }
            if (value.equals(Update.decode())) {
                return Update;
            }
            return Unknown;
        }
    }

    public static enum RegistrationOption {
        ClasspathOrder{

            @Override
            public String decode() {
                return "classpath_order";
            }

            @Override
            public String description() {
                return "Specify user-supplied classpath before DUCC-supplied classpath, or the reverse.";
            }

            @Override
            public String argname() {
                return ClasspathOrderParms.UserBeforeDucc.decode() + " or " + ClasspathOrderParms.DuccBeforeUser.decode();
            }
        }
        ,
        Description{

            @Override
            public String decode() {
                return "description";
            }

            @Override
            public String description() {
                return "Description of the run";
            }

            @Override
            public String argname() {
                return "description-string";
            }
        }
        ,
        ProcessDD{

            @Override
            public String decode() {
                return "process_DD";
            }

            @Override
            public String description() {
                return "Process deployment descriptor.";
            }

            @Override
            public String argname() {
                return "dd-descriptor.xml";
            }
        }
        ,
        ProcessClasspath{

            @Override
            public String decode() {
                return "process_classpath";
            }

            @Override
            public String description() {
                return "Classpath for the processes, inherited from environment if not specified";
            }

            @Override
            public String argname() {
                return "classpath-string";
            }
        }
        ,
        ProcessEnvironment{

            @Override
            public String decode() {
                return "process_environment";
            }

            @Override
            public String description() {
                return "Blank delimeted list of Environment variables; for example, ENV1=foo ENV2=bar";
            }

            @Override
            public String argname() {
                return "environment-var-list";
            }
        }
        ,
        ProcessFailuresLimit{

            @Override
            public String decode() {
                return "process_failures_limit";
            }

            @Override
            public String description() {
                return "Maximimum number of failures allowed before the job is automatically cancelled.";
            }

            @Override
            public String argname() {
                return "environment-var-list";
            }
        }
        ,
        ProcessJvmArgs{

            @Override
            public String decode() {
                return "process_jvm_args";
            }

            @Override
            public String description() {
                return "Blank-delimeted list of JVM Arguments passed to each process";
            }

            @Override
            public String argname() {
                return "argument-list";
            }
        }
        ,
        ProcessMemorySize{

            @Override
            public String decode() {
                return "process_memory_size";
            }

            @Override
            public String description() {
                return "Maximum memory usage of each process, in GB.";
            }

            @Override
            public String argname() {
                return "size-in-GB";
            }
        }
        ,
        SchedulingClass{

            @Override
            public String decode() {
                return "scheduling_class";
            }

            @Override
            public String description() {
                return "The class to run the job in.";
            }

            @Override
            public String argname() {
                return "scheduling-class";
            }
        }
        ,
        ServiceRequestEndpoint{

            @Override
            public String decode() {
                return ServiceRequestProperties.key_service_request_endpoint;
            }

            @Override
            public String description() {
                return "Unique id for this service. Usually inferred for UIMA-AS services.";
            }

            @Override
            public String argname() {
                return "string";
            }
        }
        ,
        ServicePingClass{

            @Override
            public String decode() {
                return "service_ping_class";
            }

            @Override
            public String description() {
                return "Class to ping ervice, must extend AServicePing.java";
            }

            @Override
            public String argname() {
                return "classname";
            }
        }
        ,
        ServicePingClasspath{

            @Override
            public String decode() {
                return "service_ping_classpath";
            }

            @Override
            public String description() {
                return "Classpath containing service_custom_ping class and dependencies.";
            }

            @Override
            public String argname() {
                return "classpath";
            }
        }
        ,
        ServicePingJvmArgs{

            @Override
            public String decode() {
                return "service_ping_jvm_args";
            }

            @Override
            public String description() {
                return "-D jvm system property assignments to pass to jvm";
            }

            @Override
            public String argname() {
                return "java-system-property-assignments";
            }
        }
        ,
        ServicePingTimeout{

            @Override
            public String decode() {
                return "service_ping_timeout";
            }

            @Override
            public String description() {
                return "Time in milliseconds to wait for a ping to the service.";
            }

            @Override
            public String argname() {
                return "time-in-ms";
            }
        }
        ,
        ServicePingDoLog{

            @Override
            public String decode() {
                return "service_ping_dolog";
            }

            @Override
            public String description() {
                return "If specified, log the pinger, else suppress the log.";
            }

            @Override
            public String argname() {
                return "none";
            }
        }
        ,
        WorkingDirectory{

            @Override
            public String decode() {
                return "working_directory";
            }

            @Override
            public String description() {
                return "The working directory set in each process.";
            }

            @Override
            public String argname() {
                return "directory-name";
            }
        }
        ,
        LogDirectory{

            @Override
            public String decode() {
                return "log_directory";
            }

            @Override
            public String description() {
                return "The directory where logs are written.  Default: $HOME/ducc/logs";
            }

            @Override
            public String argname() {
                return "directory-name";
            }
        }
        ,
        Jvm{

            @Override
            public String decode() {
                return "jvm";
            }

            @Override
            public String description() {
                return "The jvm to use.  Must be a full path to the 'java' executable.  Default is\n   the jvm that DUCC is using.";
            }

            @Override
            public String argname() {
                return "path-name-to-java";
            }
        }
        ,
        ServiceDependency{

            @Override
            public String decode() {
                return "service_dependency";
            }

            @Override
            public String description() {
                return "Comma-delimeted list of service descriptor strings. Example:UIMA-AS:RandomSleepAE:tcp://node1:61616";
            }

            @Override
            public String argname() {
                return "service-dependency-list";
            }
        }
        ,
        ServiceLinger{

            @Override
            public String decode() {
                return "service_linger";
            }

            @Override
            public String description() {
                return "Time in seconds to wait after last referring job or service exits before stopping a non-autostarted service.";
            }

            @Override
            public String argname() {
                return "seconds";
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "Illegal argument";
            }

            @Override
            public String argname() {
                return "none";
            }
        };


        public abstract String decode();

        public abstract String description();

        public abstract String argname();

        public static RegistrationOption encode(String value) {
            if (value.equals(ClasspathOrder.decode())) {
                return ClasspathOrder;
            }
            if (value.equals(Description.decode())) {
                return Description;
            }
            if (value.equals(ProcessDD.decode())) {
                return ProcessDD;
            }
            if (value.equals(ProcessClasspath.decode())) {
                return ProcessClasspath;
            }
            if (value.equals(ProcessEnvironment.decode())) {
                return ProcessEnvironment;
            }
            if (value.equals(ProcessFailuresLimit.decode())) {
                return ProcessFailuresLimit;
            }
            if (value.equals(ProcessJvmArgs.decode())) {
                return ProcessJvmArgs;
            }
            if (value.equals(ProcessMemorySize.decode())) {
                return ProcessMemorySize;
            }
            if (value.equals(SchedulingClass.decode())) {
                return SchedulingClass;
            }
            if (value.equals(ServiceRequestEndpoint.decode())) {
                return ServiceRequestEndpoint;
            }
            if (value.equals(ServicePingClass.decode())) {
                return ServicePingClass;
            }
            if (value.equals(ServicePingClasspath.decode())) {
                return ServicePingClasspath;
            }
            if (value.equals(ServicePingTimeout.decode())) {
                return ServicePingTimeout;
            }
            if (value.equals(ServicePingDoLog.decode())) {
                return ServicePingDoLog;
            }
            if (value.equals(WorkingDirectory.decode())) {
                return WorkingDirectory;
            }
            if (value.equals(LogDirectory.decode())) {
                return LogDirectory;
            }
            if (value.equals(Jvm.decode())) {
                return Jvm;
            }
            if (value.equals(ServiceDependency.decode())) {
                return ServiceDependency;
            }
            if (value.equals(ServiceLinger.decode())) {
                return ServiceLinger;
            }
            return Unknown;
        }
    }

    public static enum ClasspathOrderParms {
        UserBeforeDucc{

            @Override
            public String decode() {
                return "user-before-ducc";
            }

            @Override
            public String description() {
                return "Start process with uer's classpath ahead of DUCC's";
            }

            @Override
            public String argname() {
                return "none";
            }
        }
        ,
        DuccBeforeUser{

            @Override
            public String decode() {
                return "ducc-before-user";
            }

            @Override
            public String description() {
                return "Start process with DUCC's classpath ahead of user's";
            }

            @Override
            public String argname() {
                return "none";
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "Illegal argument";
            }

            @Override
            public String argname() {
                return "none";
            }
        };


        public abstract String decode();

        public abstract String description();

        public abstract String argname();

        public static ClasspathOrderParms encode(String value) {
            if (value.equals(UserBeforeDucc.decode())) {
                return UserBeforeDucc;
            }
            if (value.equals(DuccBeforeUser.decode())) {
                return DuccBeforeUser;
            }
            return Unknown;
        }
    }
}

