/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemStateManager;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryMap;
import org.apache.uima.ducc.transport.event.jd.PerformanceSummaryReader;

public class DuccPerfStats {
    boolean csv = false;
    boolean summary = false;
    boolean workitems = false;
    boolean processes = false;
    String jobid = null;
    String dir = ".";
    SummarySort summarySort = SummarySort.TotalTime;
    WorkItemSort workItemSort = WorkItemSort.Seq;

    static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.exit(1);
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(DuccPerfStats.class.getName(), options);
        StringBuffer sb = new StringBuffer();
        for (SummarySort ss : SummarySort.values()) {
            if (ss == SummarySort.Unknown) continue;
            sb.append(ss.decode());
            sb.append(" ");
        }
        String summaryFields = sb.toString();
        sb = new StringBuffer();
        for (WorkItemSort ss : WorkItemSort.values()) {
            if (ss == WorkItemSort.Unknown) continue;
            sb.append(ss.decode());
            sb.append(" ");
        }
        String workItemFields = sb.toString();
        System.out.println("If no log directory is provided the CURRENT directory is searched for the specified job logs.");
        System.out.println("   If no job id is provided, the CURRENT directory is assumed to be the job's log directory and");
        System.out.println("is searched for stats files.");
        System.out.println("Sort fields for job summary: " + summaryFields);
        System.out.println("Sort fields for work items : " + workItemFields);
        System.out.println("The process details listing does not provide for sorting.");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("Format job summary statistics from the current directory:");
        System.out.println("   ducc_perf_stats -report summary");
        System.out.println("");
        System.out.println("Format work item detailsfrom the current directory:");
        System.out.println("   ducc_perf_stats -report workitems");
        System.out.println("");
        System.out.println("Format process details from job history");
        System.out.println("   ducc_perf_stats -report processes");
        System.out.println("");
        System.out.println("Format job summary statistics from some log directory and print in CSV:");
        System.out.println("   ducc_perf_stats -directory /home/bob/ducc/logs -job 33 -summary -csv");
        System.out.println("");
        System.out.println("When using CSV, the first line of the job summary stats contains two numbers");
        System.out.println("  numitems numcas");
        System.out.println("Where numitems is the number of analytics found in the stats file.");
        System.out.println("Where numcas   is the number of input CASs (work items) processed.");
        System.exit(0);
    }

    protected void addOptions(Options options) {
        for (ClOptions opt : ClOptions.values()) {
            if (opt == ClOptions.Unknown) continue;
            if (opt.argname() == null) {
                OptionBuilder.withLongOpt((String)opt.decode());
                OptionBuilder.withDescription((String)opt.description());
                options.addOption(OptionBuilder.create());
                continue;
            }
            OptionBuilder.withLongOpt((String)opt.decode());
            OptionBuilder.withDescription((String)opt.description());
            OptionBuilder.withArgName((String)opt.argname());
            OptionBuilder.hasArg((boolean)true);
            options.addOption(OptionBuilder.create());
        }
    }

    protected String dup(String s, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    protected IDuccWorkJob readJob(String job) throws Exception {
        String ducc_home = Utils.findDuccHome();
        if (ducc_home == null) {
            return null;
        }
        String history = ducc_home + "/history/jobs/" + job + ".dwj";
        FileInputStream fis = null;
        ObjectInputStream in = null;
        fis = new FileInputStream(history);
        in = new ObjectInputStream(fis);
        IDuccWorkJob reply = (IDuccWorkJob)in.readObject();
        in.close();
        return reply;
    }

    protected void formatProcesses(String job) {
        try {
            IDuccWorkJob dwj = this.readJob(job);
            IDuccProcessMap pmap = dwj.getProcessMap();
            String headerFmt = "%25s %8s %12s %12s %12s %12s %12s %12s %10s %8s %8s %8s %8s %8s %8s %8s %s";
            String underline = this.dup("-", 25) + " -------- ------------ ------------ ------------ ------------ ------------ ------------ ---------- -------- -------- -------- -------- -------- -------- -------- -----------------";
            String dataFmt = null;
            if (this.csv) {
                dataFmt = "%s\t%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%s";
            } else {
                dataFmt = "%25.25s %8s %12d %12d %12d %12d %12d %12d %10d %8d %8d %8d %8d %8d %8d %8d %s";
                System.out.println(String.format(headerFmt, "Node", "Pid", "Init Time", "Mem", "MemMax", "Faults", "Swap", "MaxSwap", "CPU", "gcCount", "gcTime", "wiDisp", "wiDone", "wiError", "wiRetry", "wiPrmpt", "Exit Reason"));
                System.out.println(underline);
            }
            for (DuccId id : pmap.keySet()) {
                IDuccProcess idp = pmap.getProcess(id);
                String node = idp.getNodeIdentity().getName();
                String pid = idp.getPID();
                String exit_reason = idp.getReasonForStoppingProcess();
                long mem = idp.getResidentMemory();
                long memmax = idp.getResidentMemoryMax();
                long major_faults = idp.getMajorFaults();
                long swap_usage = idp.getSwapUsage();
                long max_swap_usage = idp.getSwapUsageMax();
                long cpu_time = idp.getCpuTime();
                long init_time = idp.getTimeWindowInit().getElapsedMillis();
                ProcessGarbageCollectionStats gcStats = idp.getGarbageCollectionStats();
                long gcCollectionCount = 0L;
                long gcCollectionTime = 0L;
                if (gcStats != null) {
                    gcCollectionCount = gcStats.getCollectionCount();
                    gcCollectionTime = gcStats.getCollectionTime();
                }
                IDuccProcessWorkItems idpw = idp.getProcessWorkItems();
                long wiDispatch = 0L;
                long wiDone = 0L;
                long wiError = 0L;
                long wiRetry = 0L;
                long wiPreempt = 0L;
                if (idpw != null) {
                    wiDispatch = idpw.getCountDispatch();
                    wiDone = idpw.getCountDone();
                    wiError = idpw.getCountError();
                    wiRetry = idpw.getCountRetry();
                    wiPreempt = idpw.getCountPreempt();
                }
                System.out.println(String.format(dataFmt, node, pid, init_time, mem, memmax, major_faults, swap_usage, max_swap_usage, cpu_time, gcCollectionCount, gcCollectionTime, wiDispatch, wiDone, wiError, wiRetry, wiPreempt, exit_reason == null ? "Completion" : exit_reason));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void formatSummary() {
        String fmt;
        PerformanceSummaryReader psf = new PerformanceSummaryReader(this.dir);
        PerformanceMetricsSummaryMap pms = psf.readSummary();
        if (pms == null) {
            return;
        }
        int cascount = pms.casCount();
        int size = pms.size();
        Set set = pms.entrySet();
        ArrayList<PerformanceMetricsSummaryItem> items = new ArrayList<PerformanceMetricsSummaryItem>();
        int maxl = 0;
        for (Map.Entry e : set) {
            PerformanceMetricsSummaryItem pmi = (PerformanceMetricsSummaryItem)e.getValue();
            String k = pmi.getUniqueName();
            maxl = Math.max(maxl, k.length());
            items.add(pmi);
        }
        Comparator<PerformanceMetricsSummaryItem> sorter = null;
        switch (this.summarySort) {
            case ItemsProcessed: {
                sorter = new SummaryItemsProcessedSorter();
                break;
            }
            case MaxTime: {
                sorter = new SummaryMaxTimeSorter();
                break;
            }
            case MinTime: {
                sorter = new SummaryMinTimeSorter();
                break;
            }
            case Name: {
                sorter = new SummaryNameSorter();
                break;
            }
            case TotalTime: {
                sorter = new SummaryTimeSorter();
            }
        }
        Collections.sort(items, sorter);
        if (this.csv) {
            fmt = "%d\t%d\t%d\t%d\t%s";
            System.out.println("" + size + "," + cascount);
        } else {
            System.out.println("Size: " + size + " CASCount: " + cascount);
            fmt = "%16s %16s %16s %16s %-" + maxl + "s";
            System.out.println(String.format(fmt, "Total Time", "Max Time", "Min Time", "Items Processed", "Name"));
            System.out.println(String.format(fmt, "----------", "--------", "--------", "---------------", this.dup("-", maxl)));
            fmt = "%16d %16d %16d %16d %-" + maxl + "s";
        }
        for (int i = 0; i < items.size(); ++i) {
            PerformanceMetricsSummaryItem pmi = (PerformanceMetricsSummaryItem)items.get(i);
            System.out.println(String.format(fmt, pmi.getAnalysisTime(), pmi.getAnalysisTimeMax(), pmi.getAnalysisTimeMin(), pmi.getNumProcessed(), pmi.getUniqueName()));
        }
    }

    protected void formatWorkItems() {
        String fmt;
        WorkItemStateManager workItemStateManager = new WorkItemStateManager(this.dir);
        try {
            workItemStateManager.importData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ConcurrentSkipListMap map = workItemStateManager.getMap();
        int namemax = 0;
        int nodemax = 0;
        ArrayList<IWorkItemState> items = new ArrayList<IWorkItemState>();
        for (Long k : map.keySet()) {
            IWorkItemState iws = (IWorkItemState)map.get(k);
            String id = iws.getWiId();
            String node = iws.getNode();
            if (node == null) {
                node = "<unassigned>";
            }
            namemax = Math.max(namemax, id.length());
            nodemax = Math.max(nodemax, node.length());
            items.add(iws);
        }
        if (this.csv) {
            fmt = "%s\t%s\t%s\t%s\t%s\t%s\t%s";
        } else {
            fmt = "%5s %" + namemax + "s %10s %16s %16s %" + nodemax + "s %5s";
            System.out.println(String.format(fmt, "Seq", "Id", "State", "QTime", "ProcTime", "Node", "PID"));
            System.out.println(String.format(fmt, "-----", this.dup("-", namemax), "----------", "----------------", "----------------", this.dup("-", nodemax), "-----"));
        }
        Comparator<IWorkItemState> sorter = null;
        switch (this.workItemSort) {
            case Seq: {
                sorter = new WorkItemSequenceSorter();
                break;
            }
            case Id: {
                sorter = new WorkItemIdSorter();
                break;
            }
            case State: {
                sorter = new WorkItemStateSorter();
                break;
            }
            case QTime: {
                sorter = new WorkItemQTimeSorter();
                break;
            }
            case ProcessTime: {
                sorter = new WorkItemProcessTimeSorter();
                break;
            }
            case Node: {
                sorter = new WorkItemNodeSorter();
                break;
            }
            case Pid: {
                sorter = new WorkItemPidSorter();
            }
        }
        Collections.sort(items, sorter);
        for (IWorkItemState iws : items) {
            String pid;
            String seq = iws.getSeqNo();
            String id = iws.getWiId();
            String node = iws.getNode();
            if (node == null) {
                node = "<unassigned>";
            }
            if ((pid = iws.getPid()) == null) {
                pid = "<n/a>";
            }
            IWorkItemState.State state = iws.getState();
            long proctime = iws.getMillisProcessing();
            long overhead = iws.getMillisOverhead();
            System.out.println(String.format(fmt, seq, id, state, overhead, proctime, node, pid));
        }
    }

    void run(String[] args) {
        File f;
        Options options = new Options();
        this.addOptions(options);
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            DuccPerfStats.usage("Cannot parse command line: " + e.getMessage());
        }
        if (args.length == 0) {
            DuccPerfStats.usage(options);
        }
        if (commandLine.hasOption(ClOptions.Help.decode())) {
            DuccPerfStats.usage(options);
        }
        if (commandLine.hasOption(ClOptions.Csv.decode())) {
            this.csv = true;
        }
        if (commandLine.hasOption(ClOptions.ReportType.decode())) {
            String type = commandLine.getOptionValue(ClOptions.ReportType.decode());
            if (type.equals("summary")) {
                this.summary = true;
            } else if (type.equals("processes")) {
                this.processes = true;
            } else if (type.equals("workitems")) {
                this.workitems = true;
            } else {
                System.out.println("Invalid report type: " + type);
                DuccPerfStats.usage(options);
            }
        }
        String logdir = commandLine.getOptionValue(ClOptions.Logdir.decode());
        String job = commandLine.getOptionValue(ClOptions.Job.decode());
        if (job == null && logdir != null) {
            DuccPerfStats.usage("Must specify job if log directory is specified");
        }
        String sortfield = commandLine.getOptionValue(ClOptions.Sort.decode());
        if (this.summary) {
            if (sortfield != null) {
                this.summarySort = SummarySort.encode(sortfield);
                if (this.summarySort == SummarySort.Unknown) {
                    DuccPerfStats.usage("Unrecognized sort field for summary listing: " + sortfield);
                }
            }
        } else if (sortfield != null) {
            this.workItemSort = WorkItemSort.encode(sortfield);
            if (this.workItemSort == WorkItemSort.Unknown) {
                DuccPerfStats.usage("Unrecognized sort field for work item listing: " + sortfield);
            }
        }
        if (job != null) {
            this.dir = job;
        }
        if (logdir != null) {
            this.dir = logdir + "/" + job;
        }
        if (!(f = new File(this.dir)).exists() || !f.isDirectory()) {
            DuccPerfStats.usage(this.dir + " is does not exist or is not a directory.");
        }
        if (this.summary) {
            this.formatSummary();
        }
        if (this.workitems) {
            this.formatWorkItems();
        }
        if (this.processes) {
            this.formatProcesses(job);
        }
    }

    public static void main(String[] args) {
        DuccPerfStats dfs = new DuccPerfStats();
        dfs.run(args);
        System.exit(0);
    }

    private static class WorkItemPidSorter
    implements Comparator<IWorkItemState> {
        private WorkItemPidSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            String aspid = a.getPid();
            String bspid = b.getPid();
            if (aspid == null) {
                aspid = "<n/a>";
            }
            if (bspid == null) {
                bspid = "<n/a>";
            }
            long apid = Long.parseLong(aspid);
            long bpid = Long.parseLong(bspid);
            return (int)(apid - bpid);
        }
    }

    private static class WorkItemNodeSorter
    implements Comparator<IWorkItemState> {
        private WorkItemNodeSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            String bb;
            String aa = a.getNode();
            if (aa == null) {
                aa = "<unassigned>";
            }
            if ((bb = b.getNode()) == null) {
                bb = "<unassigned>";
            }
            return aa.compareTo(bb);
        }
    }

    private static class WorkItemProcessTimeSorter
    implements Comparator<IWorkItemState> {
        private WorkItemProcessTimeSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            long aa = a.getMillisProcessing();
            long bb = b.getMillisProcessing();
            return (int)(bb - aa);
        }
    }

    private static class WorkItemQTimeSorter
    implements Comparator<IWorkItemState> {
        private WorkItemQTimeSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            long aa = a.getMillisOverhead();
            long bb = b.getMillisOverhead();
            return (int)(bb - aa);
        }
    }

    private static class WorkItemStateSorter
    implements Comparator<IWorkItemState> {
        private WorkItemStateSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            IWorkItemState.State aa = a.getState();
            IWorkItemState.State bb = b.getState();
            return aa.compareTo((Enum)bb);
        }
    }

    private static class WorkItemIdSorter
    implements Comparator<IWorkItemState> {
        private WorkItemIdSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            String aa = a.getWiId();
            String bb = b.getWiId();
            return aa.compareTo(bb);
        }
    }

    private static class WorkItemSequenceSorter
    implements Comparator<IWorkItemState> {
        private WorkItemSequenceSorter() {
        }

        @Override
        public int compare(IWorkItemState a, IWorkItemState b) {
            long aa = Long.parseLong(a.getSeqNo());
            long bb = Long.parseLong(b.getSeqNo());
            return (int)(aa - bb);
        }
    }

    private static class SummaryTimeSorter
    implements Comparator<PerformanceMetricsSummaryItem> {
        private SummaryTimeSorter() {
        }

        @Override
        public int compare(PerformanceMetricsSummaryItem a, PerformanceMetricsSummaryItem b) {
            long aa = a.getAnalysisTime();
            long bb = b.getAnalysisTime();
            return (int)(bb - aa);
        }
    }

    private static class SummaryNameSorter
    implements Comparator<PerformanceMetricsSummaryItem> {
        private SummaryNameSorter() {
        }

        @Override
        public int compare(PerformanceMetricsSummaryItem a, PerformanceMetricsSummaryItem b) {
            String aa = a.getName();
            String bb = b.getName();
            return aa.compareTo(bb);
        }
    }

    private static class SummaryMinTimeSorter
    implements Comparator<PerformanceMetricsSummaryItem> {
        private SummaryMinTimeSorter() {
        }

        @Override
        public int compare(PerformanceMetricsSummaryItem a, PerformanceMetricsSummaryItem b) {
            long aa = a.getAnalysisTimeMin();
            long bb = b.getAnalysisTimeMin();
            return (int)(aa - bb);
        }
    }

    private static class SummaryMaxTimeSorter
    implements Comparator<PerformanceMetricsSummaryItem> {
        private SummaryMaxTimeSorter() {
        }

        @Override
        public int compare(PerformanceMetricsSummaryItem a, PerformanceMetricsSummaryItem b) {
            long aa = a.getAnalysisTimeMax();
            long bb = b.getAnalysisTimeMax();
            return (int)(bb - aa);
        }
    }

    private static class SummaryItemsProcessedSorter
    implements Comparator<PerformanceMetricsSummaryItem> {
        private SummaryItemsProcessedSorter() {
        }

        @Override
        public int compare(PerformanceMetricsSummaryItem a, PerformanceMetricsSummaryItem b) {
            long aa = a.getNumProcessed();
            long bb = b.getNumProcessed();
            return (int)(bb - aa);
        }
    }

    static enum WorkItemSort {
        Seq{

            @Override
            public String decode() {
                return "seq";
            }

            @Override
            public String description() {
                return "Sort by work item sequence number.";
            }
        }
        ,
        Id{

            @Override
            public String decode() {
                return "id";
            }

            @Override
            public String description() {
                return "Sort by work item ID.";
            }
        }
        ,
        State{

            @Override
            public String decode() {
                return "state";
            }

            @Override
            public String description() {
                return "Sort by work item state.";
            }
        }
        ,
        QTime{

            @Override
            public String decode() {
                return "qtime";
            }

            @Override
            public String description() {
                return "Sort by work item enqueue overhead time.";
            }
        }
        ,
        ProcessTime{

            @Override
            public String decode() {
                return "ptime";
            }

            @Override
            public String description() {
                return "Sort by work item process time.";
            }
        }
        ,
        Node{

            @Override
            public String decode() {
                return "node";
            }

            @Override
            public String description() {
                return "Sort by work item execution node.";
            }
        }
        ,
        Pid{

            @Override
            public String decode() {
                return "pid";
            }

            @Override
            public String description() {
                return "Sort by work item process id.";
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "unknown";
            }
        };


        public abstract String decode();

        public abstract String description();

        public static WorkItemSort encode(String value) {
            if (value.equals("seq")) {
                return Seq;
            }
            if (value.equals("id")) {
                return Id;
            }
            if (value.equals("state")) {
                return State;
            }
            if (value.equals("qtime")) {
                return QTime;
            }
            if (value.equals("ptime")) {
                return ProcessTime;
            }
            if (value.equals("node")) {
                return Node;
            }
            if (value.equals("pid")) {
                return Pid;
            }
            return Unknown;
        }
    }

    static enum SummarySort {
        Name{

            @Override
            public String decode() {
                return "name";
            }

            @Override
            public String description() {
                return "Sort by AE name.";
            }
        }
        ,
        TotalTime{

            @Override
            public String decode() {
                return "total";
            }

            @Override
            public String description() {
                return "Sort by AE total processign time (default).";
            }
        }
        ,
        MaxTime{

            @Override
            public String decode() {
                return "max";
            }

            @Override
            public String description() {
                return "Sort by maximum processing time.";
            }
        }
        ,
        MinTime{

            @Override
            public String decode() {
                return "min";
            }

            @Override
            public String description() {
                return "Sort by minimum processing time.";
            }
        }
        ,
        ItemsProcessed{

            @Override
            public String decode() {
                return "items";
            }

            @Override
            public String description() {
                return "Sort by items processed.";
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "unknown";
            }
        };


        public abstract String decode();

        public abstract String description();

        public static SummarySort encode(String value) {
            if (value.equals("name")) {
                return Name;
            }
            if (value.equals("total")) {
                return TotalTime;
            }
            if (value.equals("max")) {
                return MaxTime;
            }
            if (value.equals("min")) {
                return MinTime;
            }
            if (value.equals("items")) {
                return ItemsProcessed;
            }
            return Unknown;
        }
    }

    static enum ClOptions {
        ReportType{

            @Override
            public String decode() {
                return "report";
            }

            @Override
            public String description() {
                return "Specify the report type.";
            }

            @Override
            public String argname() {
                return "summary or processes or workitems";
            }
        }
        ,
        Csv{

            @Override
            public String decode() {
                return "csv";
            }

            @Override
            public String description() {
                return "Format display in CSV.";
            }

            @Override
            public String argname() {
                return null;
            }
        }
        ,
        Job{

            @Override
            public String decode() {
                return "job";
            }

            @Override
            public String description() {
                return "This is the numeric ID of the job.";
            }

            @Override
            public String argname() {
                return "integer";
            }
        }
        ,
        Logdir{

            @Override
            public String decode() {
                return "directory";
            }

            @Override
            public String description() {
                return "This is your DUCC log directory.";
            }

            @Override
            public String argname() {
                return "Directory-name";
            }
        }
        ,
        Sort{

            @Override
            public String decode() {
                return "sort";
            }

            @Override
            public String description() {
                return "This is the field to sort on.";
            }

            @Override
            public String argname() {
                return "String name of sort field";
            }
        }
        ,
        Help{

            @Override
            public String decode() {
                return "help";
            }

            @Override
            public String description() {
                return "This help message.";
            }

            @Override
            public String argname() {
                return null;
            }
        }
        ,
        Unknown{

            @Override
            public String decode() {
                return "unknown";
            }

            @Override
            public String description() {
                return "unknown";
            }

            @Override
            public String argname() {
                return null;
            }
        };


        public abstract String decode();

        public abstract String description();

        public abstract String argname();

        public static ClOptions encode(String value) {
            if (value.equals("report")) {
                return ReportType;
            }
            if (value.equals("csv")) {
                return Csv;
            }
            if (value.equals("job")) {
                return Job;
            }
            if (value.equals("logdir")) {
                return Logdir;
            }
            if (value.equals("help")) {
                return Help;
            }
            return Unknown;
        }
    }
}

