/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.CGroupsManager;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;

public class CGroupsTest {
    public static DuccLogger logger = DuccLogger.getLogger(NodeAgent.class, (String)"CGroupsTest");
    CGroupsManager cgroupsManager = null;
    DuccIdFactory idFactory = null;
    Lock lock = new ReentrantLock();

    public static void main(String[] args) {
        try {
            CGroupsTest tester = new CGroupsTest();
            tester.initialize();
            if (args.length > 1) {
                tester.run(Long.parseLong(args[0]), true);
            } else {
                tester.run(Long.parseLong(args[0]), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(long howMany, boolean concurrent) {
        try {
            CGroupsTest tester = new CGroupsTest();
            tester.initialize();
            ExecutorService executor = Executors.newCachedThreadPool();
            if (concurrent) {
                int i = 0;
                while ((long)i < howMany) {
                    WorkerThread t = new WorkerThread();
                    executor.execute(t);
                    WorkerThread workerThread = t;
                    synchronized (workerThread) {
                        t.wait(100L);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < howMany) {
                    WorkerThread t = new WorkerThread();
                    Future<?> f = executor.submit(t);
                    f.get();
                    ++i;
                }
            }
            executor.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() throws Exception {
        String cgroupsBaseDir;
        this.idFactory = new DuccIdFactory(null, null);
        String cgroupsUtilsDirs = System.getProperty("ducc.agent.launcher.cgroups.utils.dir");
        String cgUtilsPath = null;
        if (cgroupsUtilsDirs == null) {
            cgUtilsPath = "/bin";
        }
        if ((cgroupsBaseDir = System.getProperty("ducc.agent.launcher.cgroups.basedir")) == null) {
            cgroupsBaseDir = "/cgroup/ducc";
        }
        String cgroupsSubsystems = "memory,cpu";
        long maxTimeToWaitForProcessToStop = 60000L;
        this.cgroupsManager = new CGroupsManager(cgUtilsPath, cgroupsBaseDir, cgroupsSubsystems, logger, maxTimeToWaitForProcessToStop);
    }

    public class WorkerThread
    implements Runnable {
        @Override
        public void run() {
            try {
                CGroupsTest.this.lock.lock();
                String containerId = CGroupsTest.this.idFactory.next().toString() + "." + CGroupsTest.this.idFactory.next().toString();
                System.out.println(">>>> Thread::" + Thread.currentThread().getId() + " creating cgroup with id:" + containerId);
                if (!CGroupsTest.this.cgroupsManager.createContainer(containerId, System.getProperty("user.name"), CGroupsTest.this.cgroupsManager.getUserGroupName(System.getProperty("user.name")), true)) {
                    System.out.println("Thread::" + Thread.currentThread().getId() + " Failure to create cgroup with id:" + containerId);
                    System.exit(-1);
                } else if (CGroupsTest.this.cgroupsManager.cgroupExists(CGroupsTest.this.cgroupsManager.getDuccCGroupBaseDir() + "/" + containerId)) {
                    System.out.println("Thread::" + Thread.currentThread().getId() + " Success creating cgroup with id:" + containerId);
                    CGroupsTest.this.cgroupsManager.setContainerSwappiness(containerId, CGroupsTest.this.cgroupsManager.getDuccUid(), true, 10L);
                } else {
                    System.out.println("Failed to validate existance of cgroup with id:" + containerId);
                    System.exit(-1);
                }
                CGroupsTest.this.cgroupsManager.destroyContainer(containerId, CGroupsTest.this.cgroupsManager.getDuccUid(), NodeAgent.SIGTERM);
                System.out.println("Cgroup " + containerId + " Removed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                CGroupsTest.this.lock.unlock();
            }
        }
    }
}

