/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.slf4j.Marker;

public abstract class Logger_common_impl
implements Logger {
    protected static final String EXCEPTION_MESSAGE = "Exception occurred";
    protected static final String[] EMPTY_STACK_TRACE_INFO = new String[]{null, null};
    protected final String fqcn = this.getClass().getName();
    protected final String fqcnCmn = Logger_common_impl.class.getName();
    private int SEVERE_COUNT = 0;
    private int WARNING_COUNT = 0;
    private int INFO_COUNT = 0;
    private int CONFIG_COUNT = 0;
    private int FINE_COUNT = 0;
    private int FINER_COUNT = 0;
    private int FINEST_COUNT = 0;
    protected final int limit_common;
    private final boolean isLimited;
    private final AtomicInteger dontSetResourceManagerCount = new AtomicInteger();
    private ResourceManager mResourceManager = null;
    private boolean isAnnotatorLogger;

    protected Logger_common_impl(Class<?> component) {
        this.limit_common = Integer.MAX_VALUE;
        this.isLimited = false;
    }

    protected Logger_common_impl(Logger_common_impl lci, int limit) {
        this.limit_common = limit;
        this.isLimited = true;
        this.isAnnotatorLogger = true;
        this.mResourceManager = lci.mResourceManager;
    }

    public abstract void log(Marker var1, String var2, Level var3, String var4, Object[] var5, Throwable var6);

    public abstract void log2(Marker var1, String var2, Level var3, String var4, Object[] var5, Throwable var6);

    public abstract void log(Marker var1, String var2, Level var3, String var4, Throwable var5);

    public static Marker getMarkerForLevel(Level level) {
        switch (level.toInteger()) {
            case 40000: {
                return UIMA_MARKER_CONFIG;
            }
            case 10000: {
                return UIMA_MARKER_FINEST;
            }
        }
        return null;
    }

    @Override
    public void log(String aFqcn, Level level, String message, Throwable thrown) {
        this.log(Logger_common_impl.getMarkerForLevel(level), aFqcn, level, message, thrown);
    }

    private boolean isNotLimited(Level level) {
        if (!this.isLimited) {
            return true;
        }
        switch (level.toInteger()) {
            case 70000: {
                if (this.SEVERE_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.SEVERE_COUNT;
                return true;
            }
            case 60000: {
                if (this.WARNING_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.WARNING_COUNT;
                return true;
            }
            case 50000: {
                if (this.INFO_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.INFO_COUNT;
                return true;
            }
            case 40000: {
                if (this.CONFIG_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.CONFIG_COUNT;
                return true;
            }
            case 30000: {
                if (this.FINE_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.FINE_COUNT;
                return true;
            }
            case 20000: {
                if (this.FINER_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.FINER_COUNT;
                return true;
            }
            case 10000: {
                if (this.FINEST_COUNT >= this.limit_common) {
                    return false;
                }
                ++this.FINEST_COUNT;
                return true;
            }
        }
        Misc.internalError();
        return false;
    }

    @Override
    @Deprecated(since="2.3.1")
    public void setOutputStream(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated(since="2.3.1")
    public void setOutputStream(PrintStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void log(String aMessage) {
        if (this.isLoggable(Level.INFO) && !this.isEmpty(aMessage) && this.isNotLimited(Level.INFO)) {
            this.log(this.fqcnCmn, Level.INFO, aMessage, null);
        }
    }

    @Override
    @Deprecated(since="2.3.1")
    public void log(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        if (this.isLoggable(Level.INFO) && !this.isEmpty(aMessageKey) && this.isNotLimited(Level.INFO)) {
            this.log(this.fqcnCmn, Level.INFO, this.rb(aResourceBundleName, aMessageKey, aArguments), null);
        }
    }

    @Override
    @Deprecated(since="2.3.1")
    public void logException(Exception aException) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO) && aException != null) {
            this.log(this.fqcnCmn, Level.INFO, EXCEPTION_MESSAGE, aException);
        }
    }

    @Override
    public void log(Level level, String aMessage) {
        if (this.isLoggable(level) && !this.isEmpty(aMessage) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, aMessage, null);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object param1) {
        if (this.isLoggable(level) && !this.isEmpty(aMessage) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, MessageFormat.format(aMessage, param1), null);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object[] params) {
        if (this.isLoggable(level) && !this.isEmpty(aMessage) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, MessageFormat.format(aMessage, params), null);
        }
    }

    @Override
    public void log(Level level, String aMessage, Throwable thrown) {
        if (this.isLoggable(level) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, aMessage != null && !aMessage.equals("") ? aMessage : EXCEPTION_MESSAGE, thrown);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object param1) {
        if (this.isLoggable(level) && !this.isEmpty(msgKey) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, this.rb(bundleName, msgKey, param1), null);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object[] params) {
        if (this.isLoggable(level) && !this.isEmpty(msgKey) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, this.rb(bundleName, msgKey, params), null);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Throwable thrown) {
        if (this.isLoggable(level) && this.isNotLimited(level)) {
            if (thrown == null && this.isEmpty(msgKey)) {
                return;
            }
            this.log(this.fqcnCmn, level, msgKey != null && !msgKey.equals("") ? this.rb(bundleName, msgKey, new Object[0]) : EXCEPTION_MESSAGE, thrown);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey) {
        if (this.isLoggable(level) && !this.isEmpty(msgKey) && this.isNotLimited(level)) {
            this.log(this.fqcnCmn, level, this.rb(bundleName, msgKey, new Object[0]), null);
        }
    }

    @Override
    @Deprecated(since="3.3.0")
    public void setResourceManager(ResourceManager resourceManager) {
        this.mResourceManager = resourceManager;
        Misc.decreasingWithTrace(this.dontSetResourceManagerCount, "Setting a resouce manager on a logger can lead to memory leaks and to the inability of locating message localizations in multi-classloader scenaros.", UIMAFramework.getLogger());
    }

    private ClassLoader getExtensionClassLoader() {
        if (this.mResourceManager != null) {
            return this.mResourceManager.getExtensionClassLoader();
        }
        UimaContext context = UimaContextHolder.getContext();
        if (context != null) {
            return ((UimaContextAdmin)context).getResourceManager().getExtensionClassLoader();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return null;
    }

    @Override
    public String rb(String bundleName, String msgKey, Object ... parameters) {
        return I18nUtil.localizeMessage(bundleName, msgKey, parameters, this.getExtensionClassLoader());
    }

    protected boolean isEmpty(String v) {
        return v == null || v.equals("");
    }

    @Override
    public boolean isAnnotatorLogger() {
        return this.isAnnotatorLogger;
    }

    public void setAnnotatorLogger(boolean v) {
        this.isAnnotatorLogger = v;
    }

    private Object[] suppliersToArray(Supplier<?>[] suppliers) {
        Object[] r = new Object[suppliers.length];
        int i = 0;
        for (Supplier<?> s : suppliers) {
            r[i++] = s.get();
        }
        return r;
    }

    @Override
    public void debug(String arg0) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, arg0, null, null);
        }
    }

    @Override
    public void debug(String arg0, Object arg1) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, arg0, new Object[]{arg1}, null);
        }
    }

    @Override
    public void debug(String arg0, Object ... arg1) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, arg0, arg1, null);
        }
    }

    @Override
    public void debug(String arg0, Throwable arg1) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, arg0, null, arg1);
        }
    }

    @Override
    public void debug(Marker arg0, String arg1) {
        if (this.isLoggable(Level.DEBUG, arg0) && this.isNotLimited(Level.DEBUG)) {
            this.log2(arg0, this.fqcnCmn, Level.DEBUG, arg1, null, null);
        }
    }

    @Override
    public void debug(String arg0, Object arg1, Object arg2) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, arg0, new Object[]{arg1, arg2}, null);
        }
    }

    @Override
    public void debug(Marker arg0, String arg1, Object arg2) {
        if (this.isLoggable(Level.DEBUG, arg0) && this.isNotLimited(Level.DEBUG)) {
            this.log2(arg0, this.fqcnCmn, Level.DEBUG, arg1, new Object[]{arg2}, null);
        }
    }

    @Override
    public void debug(Marker arg0, String arg1, Object ... arg2) {
        if (this.isLoggable(Level.DEBUG, arg0) && this.isNotLimited(Level.DEBUG)) {
            this.log2(arg0, this.fqcnCmn, Level.DEBUG, arg1, arg2, null);
        }
    }

    @Override
    public void debug(Marker arg0, String arg1, Throwable arg2) {
        if (this.isLoggable(Level.DEBUG, arg0) && this.isNotLimited(Level.DEBUG)) {
            this.log2(arg0, this.fqcnCmn, Level.DEBUG, arg1, null, arg2);
        }
    }

    @Override
    public void debug(Marker arg0, String arg1, Object arg2, Object arg3) {
        if (this.isLoggable(Level.DEBUG, arg0) && this.isNotLimited(Level.DEBUG)) {
            this.log2(arg0, this.fqcnCmn, Level.DEBUG, arg1, new Object[]{arg2, arg3}, null);
        }
    }

    @Override
    public void debug(Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void debug(Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void debug(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.DEBUG, marker) && this.isNotLimited(Level.DEBUG)) {
            this.log2(marker, this.fqcnCmn, Level.DEBUG, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void debug(String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.DEBUG) && this.isNotLimited(Level.DEBUG)) {
            this.log2(null, this.fqcnCmn, Level.DEBUG, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void debug(Marker marker, Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.DEBUG, marker) && this.isNotLimited(Level.DEBUG)) {
            this.log2(marker, this.fqcnCmn, Level.DEBUG, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void debug(Marker marker, Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.DEBUG, marker) && this.isNotLimited(Level.DEBUG)) {
            this.log2(marker, this.fqcnCmn, Level.DEBUG, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void error(String arg0) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, arg0, null, null);
        }
    }

    @Override
    public void error(String arg0, Object arg1) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, arg0, new Object[]{arg1}, null);
        }
    }

    @Override
    public void error(String arg0, Object ... arg1) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, arg0, arg1, null);
        }
    }

    @Override
    public void error(String arg0, Throwable arg1) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, arg0, null, arg1);
        }
    }

    @Override
    public void error(Marker arg0, String arg1) {
        if (this.isLoggable(Level.ERROR, arg0) && this.isNotLimited(Level.ERROR)) {
            this.log2(arg0, this.fqcnCmn, Level.ERROR, arg1, null, null);
        }
    }

    @Override
    public void error(String arg0, Object arg1, Object arg2) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, arg0, new Object[]{arg1, arg2}, null);
        }
    }

    @Override
    public void error(Marker arg0, String arg1, Object arg2) {
        if (this.isLoggable(Level.ERROR, arg0) && this.isNotLimited(Level.ERROR)) {
            this.log2(arg0, this.fqcnCmn, Level.ERROR, arg1, new Object[]{arg2}, null);
        }
    }

    @Override
    public void error(Marker arg0, String arg1, Object ... arg2) {
        if (this.isLoggable(Level.ERROR, arg0) && this.isNotLimited(Level.ERROR)) {
            this.log2(arg0, this.fqcnCmn, Level.ERROR, arg1, arg2, null);
        }
    }

    @Override
    public void error(Marker arg0, String arg1, Throwable arg2) {
        if (this.isLoggable(Level.ERROR, arg0) && this.isNotLimited(Level.ERROR)) {
            this.log2(arg0, this.fqcnCmn, Level.ERROR, arg1, null, arg2);
        }
    }

    @Override
    public void error(Marker arg0, String arg1, Object arg2, Object arg3) {
        if (this.isLoggable(Level.ERROR, arg0) && this.isNotLimited(Level.ERROR)) {
            this.log2(arg0, this.fqcnCmn, Level.ERROR, arg1, new Object[]{arg2, arg3}, null);
        }
    }

    @Override
    public void error(Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void error(Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void error(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.ERROR, marker) && this.isNotLimited(Level.ERROR)) {
            this.log2(marker, this.fqcnCmn, Level.ERROR, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void error(String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.ERROR) && this.isNotLimited(Level.ERROR)) {
            this.log2(null, this.fqcnCmn, Level.ERROR, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void error(Marker marker, Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.ERROR, marker) && this.isNotLimited(Level.ERROR)) {
            this.log2(marker, this.fqcnCmn, Level.ERROR, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void error(Marker marker, Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.ERROR, marker) && this.isNotLimited(Level.ERROR)) {
            this.log2(marker, this.fqcnCmn, Level.ERROR, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void info(String arg0) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, arg0, null, null);
        }
    }

    @Override
    public void info(String arg0, Object arg1) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, arg0, new Object[]{arg1}, null);
        }
    }

    @Override
    public void info(String arg0, Object ... arg1) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, arg0, arg1, null);
        }
    }

    @Override
    public void info(String arg0, Throwable arg1) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, arg0, null, arg1);
        }
    }

    @Override
    public void info(Marker arg0, String arg1) {
        if (this.isLoggable(Level.INFO, arg0) && this.isNotLimited(Level.INFO)) {
            this.log2(arg0, this.fqcnCmn, Level.INFO, arg1, null, null);
        }
    }

    @Override
    public void info(String arg0, Object arg1, Object arg2) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, arg0, new Object[]{arg1, arg2}, null);
        }
    }

    @Override
    public void info(Marker arg0, String arg1, Object arg2) {
        if (this.isLoggable(Level.INFO, arg0) && this.isNotLimited(Level.INFO)) {
            this.log2(arg0, this.fqcnCmn, Level.INFO, arg1, new Object[]{arg2}, null);
        }
    }

    @Override
    public void info(Marker arg0, String arg1, Object ... arg2) {
        if (this.isLoggable(Level.INFO, arg0) && this.isNotLimited(Level.INFO)) {
            this.log2(arg0, this.fqcnCmn, Level.INFO, arg1, arg2, null);
        }
    }

    @Override
    public void info(Marker arg0, String arg1, Throwable arg2) {
        if (this.isLoggable(Level.INFO, arg0) && this.isNotLimited(Level.INFO)) {
            this.log2(arg0, this.fqcnCmn, Level.INFO, arg1, null, arg2);
        }
    }

    @Override
    public void info(Marker arg0, String arg1, Object arg2, Object arg3) {
        if (this.isLoggable(Level.INFO, arg0) && this.isNotLimited(Level.INFO)) {
            this.log2(arg0, this.fqcnCmn, Level.INFO, arg1, new Object[]{arg2, arg3}, null);
        }
    }

    @Override
    public void info(Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void info(Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void info(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.INFO, marker) && this.isNotLimited(Level.INFO)) {
            this.log2(marker, this.fqcnCmn, Level.INFO, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    public void info(String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.INFO) && this.isNotLimited(Level.INFO)) {
            this.log2(null, this.fqcnCmn, Level.INFO, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void info(Marker marker, Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.INFO, marker) && this.isNotLimited(Level.INFO)) {
            this.log2(marker, this.fqcnCmn, Level.INFO, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void info(Marker marker, Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.INFO, marker) && this.isNotLimited(Level.INFO)) {
            this.log2(marker, this.fqcnCmn, Level.INFO, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void trace(String arg0) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, arg0, null, null);
        }
    }

    @Override
    public void trace(String arg0, Object arg1) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, arg0, new Object[]{arg1}, null);
        }
    }

    @Override
    public void trace(String arg0, Object ... arg1) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, arg0, arg1, null);
        }
    }

    @Override
    public void trace(String arg0, Throwable arg1) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, arg0, null, arg1);
        }
    }

    @Override
    public void trace(Marker arg0, String arg1) {
        if (this.isLoggable(Level.TRACE, arg0) && this.isNotLimited(Level.TRACE)) {
            this.log2(arg0, this.fqcnCmn, Level.TRACE, arg1, null, null);
        }
    }

    @Override
    public void trace(String arg0, Object arg1, Object arg2) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, arg0, new Object[]{arg1, arg2}, null);
        }
    }

    @Override
    public void trace(Marker arg0, String arg1, Object arg2) {
        if (this.isLoggable(Level.TRACE, arg0) && this.isNotLimited(Level.TRACE)) {
            this.log2(arg0, this.fqcnCmn, Level.TRACE, arg1, new Object[]{arg2}, null);
        }
    }

    @Override
    public void trace(Marker arg0, String arg1, Object ... arg2) {
        if (this.isLoggable(Level.TRACE, arg0) && this.isNotLimited(Level.TRACE)) {
            this.log2(arg0, this.fqcnCmn, Level.TRACE, arg1, arg2, null);
        }
    }

    @Override
    public void trace(Marker arg0, String arg1, Throwable arg2) {
        if (this.isLoggable(Level.TRACE, arg0) && this.isNotLimited(Level.TRACE)) {
            this.log2(arg0, this.fqcnCmn, Level.TRACE, arg1, null, arg2);
        }
    }

    @Override
    public void trace(Marker arg0, String arg1, Object arg2, Object arg3) {
        if (this.isLoggable(Level.TRACE, arg0) && this.isNotLimited(Level.TRACE)) {
            this.log2(arg0, this.fqcnCmn, Level.TRACE, arg1, new Object[]{arg2, arg3}, null);
        }
    }

    @Override
    public void trace(Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void trace(Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void trace(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.TRACE, marker) && this.isNotLimited(Level.TRACE)) {
            this.log2(marker, this.fqcnCmn, Level.TRACE, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void trace(String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.TRACE) && this.isNotLimited(Level.TRACE)) {
            this.log2(null, this.fqcnCmn, Level.TRACE, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void trace(Marker marker, Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.TRACE, marker) && this.isNotLimited(Level.TRACE)) {
            this.log2(marker, this.fqcnCmn, Level.TRACE, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void trace(Marker marker, Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.TRACE, marker) && this.isNotLimited(Level.TRACE)) {
            this.log2(marker, this.fqcnCmn, Level.TRACE, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void warn(String arg0) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, arg0, null, null);
        }
    }

    @Override
    public void warn(String arg0, Object arg1) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, arg0, new Object[]{arg1}, null);
        }
    }

    @Override
    public void warn(String arg0, Object ... arg1) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, arg0, arg1, null);
        }
    }

    @Override
    public void warn(String arg0, Throwable arg1) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, arg0, null, arg1);
        }
    }

    @Override
    public void warn(Marker arg0, String arg1) {
        if (this.isLoggable(Level.WARNING, arg0) && this.isNotLimited(Level.WARNING)) {
            this.log2(arg0, this.fqcnCmn, Level.WARNING, arg1, null, null);
        }
    }

    @Override
    public void warn(String arg0, Object arg1, Object arg2) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, arg0, new Object[]{arg1, arg2}, null);
        }
    }

    @Override
    public void warn(Marker arg0, String arg1, Object arg2) {
        if (this.isLoggable(Level.WARNING, arg0) && this.isNotLimited(Level.WARNING)) {
            this.log2(arg0, this.fqcnCmn, Level.WARNING, arg1, new Object[]{arg2}, null);
        }
    }

    @Override
    public void warn(Marker arg0, String arg1, Object ... arg2) {
        if (this.isLoggable(Level.WARNING, arg0) && this.isNotLimited(Level.WARNING)) {
            this.log2(arg0, this.fqcnCmn, Level.WARNING, arg1, arg2, null);
        }
    }

    @Override
    public void warn(Marker arg0, String arg1, Throwable arg2) {
        if (this.isLoggable(Level.WARNING, arg0) && this.isNotLimited(Level.WARNING)) {
            this.log2(arg0, this.fqcnCmn, Level.WARNING, arg1, null, arg2);
        }
    }

    @Override
    public void warn(Marker arg0, String arg1, Object arg2, Object arg3) {
        if (this.isLoggable(Level.WARNING, arg0) && this.isNotLimited(Level.WARNING)) {
            this.log2(arg0, this.fqcnCmn, Level.WARNING, arg1, new Object[]{arg2, arg3}, null);
        }
    }

    @Override
    public void warn(Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void warn(Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.WARNING) && this.isNotLimited(Level.WARNING)) {
            this.log2(null, this.fqcnCmn, Level.WARNING, msgSupplier.get(), null, throwable);
        }
    }

    @Override
    public void warn(Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.WARNING, marker) && this.isNotLimited(Level.WARNING)) {
            this.log2(marker, this.fqcnCmn, Level.WARNING, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void warn(String message, Supplier<?> ... paramSuppliers) {
        if (this.isLoggable(Level.WARN) && this.isNotLimited(Level.WARN)) {
            this.log2(null, this.fqcnCmn, Level.WARN, message, this.suppliersToArray(paramSuppliers), null);
        }
    }

    @Override
    public void warn(Marker marker, Supplier<String> msgSupplier) {
        if (this.isLoggable(Level.WARNING, marker) && this.isNotLimited(Level.WARNING)) {
            this.log2(marker, this.fqcnCmn, Level.WARNING, msgSupplier.get(), null, null);
        }
    }

    @Override
    public void warn(Marker marker, Supplier<String> msgSupplier, Throwable throwable) {
        if (this.isLoggable(Level.WARNING, marker) && this.isNotLimited(Level.WARNING)) {
            this.log2(marker, this.fqcnCmn, Level.WARNING, msgSupplier.get(), null, throwable);
        }
    }
}

