/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;

public final class SerializationUtils {
    private static final Set<Class<?>> CAS_MGR_SERIALIZER_SAFE_CLASSES = Set.of(CASMgrSerializer.class, String.class);
    private static final Set<Class<?>> CAS_SERIALIZER_SAFE_CLASSES = Set.of(CASSerializer.class, String.class);
    private static final Set<Class<?>> CAS_COMPLETE_SERIALIZER_SAFE_CLASSES = Set.of(CASCompleteSerializer.class, String.class, CASMgrSerializer.class, CASSerializer.class);

    private SerializationUtils() {
    }

    public static byte[] serialize(Serializable aObject) throws IOException {
        if (aObject == null) {
            return null;
        }
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objStream = new ObjectOutputStream(byteStream);){
                objStream.writeObject(aObject);
                objStream.flush();
                byArray = byteStream.toByteArray();
            }
            return byArray;
        }
    }

    public static Object deserialize(byte[] aBytes) throws IOException, ClassNotFoundException {
        Object object;
        try {
            object = SerializationUtils.deserialize(aBytes, Stream.concat(Stream.concat(CAS_SERIALIZER_SAFE_CLASSES.stream(), CAS_COMPLETE_SERIALIZER_SAFE_CLASSES.stream()), CAS_MGR_SERIALIZER_SAFE_CLASSES.stream()).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            throw e;
        }
        if (!(object == null || object instanceof CASMgrSerializer || object instanceof CASSerializer || object instanceof CASCompleteSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return object;
    }

    public static Object deserializeCASSerializerOrCASCompleteSerializer(InputStream aIs) throws IOException {
        Object object = SerializationUtils.deserialize(aIs, Stream.concat(CAS_SERIALIZER_SAFE_CLASSES.stream(), CAS_COMPLETE_SERIALIZER_SAFE_CLASSES.stream()).collect(Collectors.toSet()));
        if (object != null && !(object instanceof CASSerializer) && !(object instanceof CASCompleteSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return object;
    }

    public static CASCompleteSerializer deserializeCASCompleteSerializer(byte[] aBytes) throws IOException {
        Object object = SerializationUtils.deserialize(aBytes, CAS_COMPLETE_SERIALIZER_SAFE_CLASSES);
        if (object != null && !(object instanceof CASCompleteSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return (CASCompleteSerializer)object;
    }

    public static CASSerializer deserializeCASSerializer(byte[] aBytes) throws IOException {
        Object object = SerializationUtils.deserialize(aBytes, CAS_SERIALIZER_SAFE_CLASSES);
        if (object != null && !(object instanceof CASSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return (CASSerializer)object;
    }

    public static CASMgrSerializer deserializeCASMgrSerializer(byte[] aBytes) throws IOException {
        Object object = SerializationUtils.deserialize(aBytes, CAS_MGR_SERIALIZER_SAFE_CLASSES);
        if (object != null && !(object instanceof CASMgrSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return (CASMgrSerializer)object;
    }

    public static CASMgrSerializer deserializeCASMgrSerializer(InputStream aIn) throws IOException {
        Object object = SerializationUtils.deserialize(aIn, CAS_MGR_SERIALIZER_SAFE_CLASSES);
        if (object != null && !(object instanceof CASMgrSerializer)) {
            throw new IOException("Unexpected object type: [" + object.getClass().getName() + "]");
        }
        return (CASMgrSerializer)object;
    }

    private static <T> T deserialize(byte[] aBytes, Set<Class<?>> aFilter) throws IOException {
        if (aBytes == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(aBytes);){
            T t = SerializationUtils.deserialize(is, aFilter);
            return t;
        }
    }

    private static <T> T deserialize(InputStream aIs, Set<Class<?>> aSafeClasses) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(aIs);
        ObjectInputFilter f = ObjectInputFilter.rejectUndecidedClass(ObjectInputFilter.allowFilter(aSafeClasses::contains, ObjectInputFilter.Status.UNDECIDED));
        ois.setObjectInputFilter(f);
        try {
            return (T)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unexpected deserialization error", e);
        }
    }
}

