/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.BuiltinTypeKinds;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FsGenerator3;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.UIMAClassLoader;
import org.apache.uima.internal.util.WeakIdentityMap;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.spi.JCasClassProvider;
import org.apache.uima.spi.TypeSystemProvider;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class FSClassRegistry {
    static final String RECORD_JCAS_CLASSLOADERS = "uima.record_jcas_classloaders";
    static final boolean IS_RECORD_JCAS_CLASSLOADERS = Misc.getNoValueSystemProperty("uima.record_jcas_classloaders");
    static final String LOG_JCAS_CLASSLOADERS_ON_SHUTDOWN = "uima.log_jcas_classloaders_on_shutdown";
    static final boolean IS_LOG_JCAS_CLASSLOADERS_ON_SHUTDOWN = Misc.getNoValueSystemProperty("uima.log_jcas_classloaders_on_shutdown");
    private static final MethodHandles.Lookup defaultLookup = MethodHandles.lookup();
    private static final MethodType findConstructorJCasCoverType = MethodType.methodType(Void.TYPE, TypeImpl.class, CASImpl.class);
    private static final MethodType callsiteFsGenerator = MethodType.methodType(FsGenerator3.class);
    private static final MethodType fsGeneratorType = MethodType.methodType(TOP.class, TypeImpl.class, CASImpl.class);
    private static final JCasClassInfo[] jcasClassesInfoForBuiltins;
    private static final List<MethodHandle> methodHandlesForInt;
    private static final WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> cl_to_type2JCas;
    private static final WeakIdentityMap<ClassLoader, StackTraceElement[]> cl_to_type2JCasStacks;
    private static final WeakIdentityMap<ClassLoader, Map<String, Class<? extends TOP>>> cl_to_spiJCas;
    private static final WeakIdentityMap<ClassLoader, UIMAClassLoader> cl_to_uimaCl;
    private static final WeakIdentityMap<Class<? extends TOP>, FsGenerator3> JCAS_TO_GENERATOR;
    private static ThreadLocal<List<ErrorReport>> errorSet;

    static int clToType2JCasSize() {
        return cl_to_type2JCas.size();
    }

    private static void loadBuiltins(TypeImpl ti, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, ArrayList<MutableCallSite> callSites_toSync) {
        String typeName = ti.getName();
        if (BuiltinTypeKinds.creatableBuiltinJCas.contains(typeName) || typeName.equals("uima.cas.Sofa")) {
            JCasClassInfo jcci = FSClassRegistry.getOrCreateJCasClassInfo(ti, cl, type2jcci, Collections.emptyMap());
            assert (jcci != null);
            FSClassRegistry.updateOrValidateAllCallSitesForJCasClass(jcci.jcasClass, ti, callSites_toSync);
            FSClassRegistry.jcasClassesInfoForBuiltins[ti.getCode()] = jcci;
        }
        for (TypeImpl subType : ti.getDirectSubtypes()) {
            FSClassRegistry.loadBuiltins(subType, cl, type2jcci, callSites_toSync);
        }
    }

    private static synchronized void loadJCasForTSandClassLoader(TypeSystemImpl ts, boolean isDoUserJCasLoading, ClassLoader cl, Map<String, JCasClassInfo> type2jcci) {
        for (int typecode = 1; typecode < jcasClassesInfoForBuiltins.length; ++typecode) {
            JCasClassInfo jcci = jcasClassesInfoForBuiltins[typecode];
            if (jcci == null) continue;
            Class<? extends TOP> jcasClass = jcci.jcasClass;
            type2jcci.putIfAbsent(jcasClass.getCanonicalName(), jcci);
            FSClassRegistry.setTypeFromJCasIDforBuiltIns(jcci, ts, typecode);
        }
        if (isDoUserJCasLoading) {
            Map<String, Class<? extends TOP>> spiJCasClasses = FSClassRegistry.loadJCasClassesFromSPI(cl);
            ArrayList<MutableCallSite> callSites_toSync = new ArrayList<MutableCallSite>();
            FSClassRegistry.maybeLoadJCasAndSubtypes(ts, ts.topType, type2jcci.get(TOP.class.getCanonicalName()), cl, type2jcci, callSites_toSync, spiJCasClasses);
            MutableCallSite[] sync = callSites_toSync.toArray(new MutableCallSite[callSites_toSync.size()]);
            MutableCallSite.syncAll(sync);
            FSClassRegistry.checkConformance(ts, ts.topType, type2jcci);
        }
        FSClassRegistry.reportErrors();
    }

    private static void setTypeFromJCasIDforBuiltIns(JCasClassInfo jcci, TypeSystemImpl tsi, int typeCode) {
        int v = jcci.jcasType;
        if (v >= 0) {
            tsi.setJCasRegisteredType(v, tsi.getTypeForCode(typeCode));
        }
    }

    private static void maybeLoadJCasAndSubtypes(TypeSystemImpl tsi, TypeImpl ti, JCasClassInfo copyDownDefault_jcasClassInfo, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, ArrayList<MutableCallSite> callSites_toSync, Map<String, Class<? extends TOP>> aSpiJCasClasses) {
        JCasClassInfo jcci_or_copyDown;
        JCasClassInfo jcci = FSClassRegistry.getOrCreateJCasClassInfo(ti, cl, type2jcci, aSpiJCasClasses);
        if (null != jcci && tsi.isCommitted()) {
            FSClassRegistry.updateOrValidateAllCallSitesForJCasClass(jcci.jcasClass, ti, callSites_toSync);
        }
        JCasClassInfo jCasClassInfo = jcci_or_copyDown = jcci == null ? copyDownDefault_jcasClassInfo : jcci;
        if (!ti.isPrimitive()) {
            ti.setJavaClass(jcci_or_copyDown.jcasClass);
        }
        for (TypeImpl subType : ti.getDirectSubtypes()) {
            FSClassRegistry.maybeLoadJCasAndSubtypes(tsi, subType, jcci_or_copyDown, cl, type2jcci, callSites_toSync, aSpiJCasClasses);
        }
    }

    @Deprecated(since="3.5.1")
    public static JCasClassInfo getOrCreateJCasClassInfo(TypeImpl aTypeInfo, ClassLoader aClassLoader, Map<String, JCasClassInfo> aType2Jcci, MethodHandles.Lookup aUnusedLookup) {
        return FSClassRegistry.getOrCreateJCasClassInfo(aTypeInfo, aClassLoader, aType2Jcci, FSClassRegistry.loadJCasClassesFromSPI(aClassLoader));
    }

    static JCasClassInfo getOrCreateJCasClassInfo(TypeImpl aTypeInfo, ClassLoader aClassLoader, Map<String, JCasClassInfo> aType2Jcci, Map<String, Class<? extends TOP>> aSpiJCasClasses) {
        JCasClassInfo jcci = aType2Jcci.get(aTypeInfo.getJCasClassName());
        if (jcci == null) {
            jcci = FSClassRegistry.maybeCreateJCasClassInfo(aTypeInfo, aClassLoader, aType2Jcci, aSpiJCasClasses);
        }
        if (jcci != null && jcci.jcasType >= 0) {
            aTypeInfo.getTypeSystem().setJCasRegisteredType(jcci.jcasType, aTypeInfo);
        }
        return jcci;
    }

    @Deprecated(since="3.5.1")
    static JCasClassInfo maybeCreateJCasClassInfo(TypeImpl ti, ClassLoader cl, Map<String, JCasClassInfo> type2jcci, Map<String, Class<? extends TOP>> aSpiJCasClasses) {
        JCasClassInfo jcci = FSClassRegistry.createJCasClassInfo(ti, cl, aSpiJCasClasses);
        if (null != jcci) {
            type2jcci.put(ti.getJCasClassName(), jcci);
        }
        return jcci;
    }

    @Deprecated(since="3.5.1")
    public static JCasClassInfo createJCasClassInfo(TypeImpl aTypeInfo, ClassLoader aClassLoader, MethodHandles.Lookup aUnusedLookup) {
        return FSClassRegistry.createJCasClassInfo(aTypeInfo, aClassLoader, FSClassRegistry.loadJCasClassesFromSPI(aClassLoader));
    }

    private static JCasClassInfo createJCasClassInfo(TypeImpl aTypeInfo, ClassLoader aClassLoader, Map<String, Class<? extends TOP>> aSpiJCasClasses) {
        Class<? extends TOP> jcasClass = FSClassRegistry.maybeJCasWrapperClass(aTypeInfo, aClassLoader, aSpiJCasClasses);
        if (null == jcasClass || !TOP.class.isAssignableFrom(jcasClass)) {
            return null;
        }
        int jcasType = -1;
        if (!Modifier.isAbstract(jcasClass.getModifiers()) && (jcasType = Misc.getStaticIntFieldNoInherit(jcasClass, "typeIndexID")) < 0) {
            FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_MISSING_TYPEINDEX", jcasClass.getName()), false);
            return null;
        }
        MethodHandles.Lookup lookup = FSClassRegistry.getLookup(jcasClass.getClassLoader());
        return FSClassRegistry.createJCasClassInfo(jcasClass, aTypeInfo, jcasType, lookup);
    }

    private static boolean compare_C_T(Class<?> clazz, TypeImpl ti) {
        return ti.getJCasClassName().equals(clazz.getName());
    }

    private static void validateSuperClass(JCasClassInfo jcci, TypeImpl ti) {
        TypeImpl superType;
        Class<? extends TOP> superClass = jcci.jcasClass.getSuperclass();
        if (FSClassRegistry.compare_C_T(superClass, superType = ti.getSuperType())) {
            return;
        }
        for (TypeImpl st : ti.getAllSuperTypes()) {
            if (!FSClassRegistry.compare_C_T(superClass, st)) continue;
            return;
        }
        for (Class<? extends TOP> sc = superClass.getSuperclass(); sc != Object.class && sc != FeatureStructureImplC.class; sc = sc.getSuperclass()) {
            if (!FSClassRegistry.compare_C_T(sc, superType)) continue;
            return;
        }
        throw new CASRuntimeException("JCAS_MISMATCH_SUPERTYPE", jcci.jcasClass.getName(), FSClassRegistry.getAllSuperclassNames(jcci.jcasClass), ti.getName(), FSClassRegistry.getAllSuperTypeNames(ti));
    }

    private static String getAllSuperclassNames(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> sc = clazz.getSuperclass(); sc != null && sc != FeatureStructureImplC.class; sc = sc.getSuperclass()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sc.getName());
        }
        return sb.toString();
    }

    private static String getAllSuperTypeNames(TypeImpl ti) {
        StringBuilder sb = new StringBuilder();
        TypeImpl st = ti.getSuperType();
        while (st.getCode() != 1) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(st.getName());
            st = st.getSuperType();
        }
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("uima.cas.TOP");
        return sb.toString();
    }

    private static Class<? extends TOP> maybeJCasWrapperClass(TypeImpl ti, ClassLoader cl, Map<String, Class<? extends TOP>> aSpiJCasClasses) {
        String className = ti.getJCasClassName();
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError e) {
            throw new RuntimeException("Exception while loading " + className, e);
        }
        return aSpiJCasClasses.get(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Class<? extends TOP>> loadJCasClassesFromSPI(ClassLoader cl) {
        WeakIdentityMap<ClassLoader, Map<String, Class<? extends TOP>>> weakIdentityMap = cl_to_spiJCas;
        synchronized (weakIdentityMap) {
            Map<String, Class<? extends TOP>> spiJCas = cl_to_spiJCas.get(cl);
            if (spiJCas != null) {
                return spiJCas;
            }
            LinkedHashMap<String, Class<? extends TOP>> spiJCasClasses = new LinkedHashMap<String, Class<? extends TOP>>();
            ServiceLoader.load(JCasClassProvider.class, cl).forEach(provider -> {
                List<Class<? extends TOP>> list = provider.listJCasClasses();
                if (list != null) {
                    list.forEach(item -> spiJCasClasses.put(item.getName(), (Class<? extends TOP>)item));
                }
            });
            ServiceLoader.load(TypeSystemProvider.class, cl).forEach(provider -> {
                List<Class<? extends TOP>> list = provider.listJCasClasses();
                if (list != null) {
                    list.forEach(item -> spiJCasClasses.put(item.getName(), (Class<? extends TOP>)item));
                }
            });
            cl_to_spiJCas.put(cl, spiJCasClasses);
            return spiJCasClasses;
        }
    }

    static synchronized MethodHandle getConstantIntMethodHandle(int i) {
        MethodHandle mh = Misc.getWithExpand(methodHandlesForInt, i);
        if (mh == null) {
            mh = MethodHandles.constant(Integer.TYPE, i);
            methodHandlesForInt.set(i, mh);
        }
        return mh;
    }

    private static FsGenerator3 createGenerator(Class<? extends TOP> aJCasClass, MethodHandles.Lookup aLookup) {
        WeakIdentityMap<Class<? extends TOP>, FsGenerator3> weakIdentityMap = JCAS_TO_GENERATOR;
        synchronized (weakIdentityMap) {
            FsGenerator3 generator = JCAS_TO_GENERATOR.get(aJCasClass);
            if (generator != null) {
                return generator;
            }
            try {
                MethodHandle mh = aLookup.findConstructor(aJCasClass, findConstructorJCasCoverType);
                MethodType mtThisGenerator = MethodType.methodType(aJCasClass, TypeImpl.class, CASImpl.class);
                CallSite callSite = LambdaMetafactory.metafactory(aLookup, "createFS", callsiteFsGenerator, fsGeneratorType, mh, mtThisGenerator);
                generator = callSite.getTarget().invokeExact();
                JCAS_TO_GENERATOR.put(aJCasClass, generator);
                return generator;
            }
            catch (NoSuchMethodException e) {
                String classname = aJCasClass.getName();
                FSClassRegistry.add2errors(errorSet, new CASRuntimeException((Throwable)e, "JCAS_CAS_NOT_V3", new Object[]{classname, aJCasClass.getClassLoader().getResource(classname.replace('.', '/') + ".class").toString()}));
                return null;
            }
            catch (Throwable e) {
                throw new UIMARuntimeException(e, "INTERNAL_ERROR", new Object[0]);
            }
        }
    }

    private static JCasClassInfo createJCasClassInfo(Class<? extends TOP> aJCasClass, TypeImpl aTypeInfo, int aJCasType, MethodHandles.Lookup aLookup) {
        boolean noGenerator = aTypeInfo.getCode() == 33 || Modifier.isAbstract(aJCasClass.getModifiers()) || aTypeInfo.isArray();
        FsGenerator3 generator = noGenerator ? null : FSClassRegistry.createGenerator(aJCasClass, aLookup);
        return new JCasClassInfo(aJCasClass, generator, aJCasType);
    }

    static void checkConformance(ClassLoader cl, TypeSystemImpl ts) {
        Map<String, JCasClassInfo> type2jcci = FSClassRegistry.get_className_to_jcci(cl, false);
        FSClassRegistry.checkConformance(ts, ts.topType, type2jcci);
    }

    private static void checkConformance(TypeSystemImpl ts, TypeImpl ti, Map<String, JCasClassInfo> type2jcci) {
        if (ti.isPrimitive()) {
            return;
        }
        JCasClassInfo jcci = type2jcci.get(ti.getJCasClassName());
        if (null != jcci && !ti.isBuiltIn) {
            FSClassRegistry.checkConformance(jcci.jcasClass, ts, ti, type2jcci);
        }
        for (TypeImpl subtype : ti.getDirectSubtypes()) {
            FSClassRegistry.checkConformance(ts, subtype, type2jcci);
        }
    }

    private static void checkConformance(Class<?> clazz, TypeSystemImpl tsi, TypeImpl ti, Map<String, JCasClassInfo> type2jcci) {
        FSClassRegistry.validateSuperClass(type2jcci.get(ti.getJCasClassName()), ti);
        for (Method method : clazz.getDeclaredMethods()) {
            String mname = method.getName();
            if (mname.length() <= 3 || !mname.startsWith("get")) continue;
            String suffix = mname.length() == 4 ? "" : mname.substring(4);
            String fname = Character.toLowerCase(mname.charAt(3)) + suffix;
            FeatureImpl fi = ti.getFeatureByBaseName(fname);
            if (fi == null && (fi = ti.getFeatureByBaseName(fname = mname.charAt(3) + suffix)) == null) continue;
            Parameter[] p = method.getParameters();
            TypeImpl range = fi.getRangeImpl();
            if (p.length > 1 || p.length == 1 && (!range.isArray() || p[0].getType() != Integer.TYPE)) continue;
            Class<?> returnClass = method.getReturnType();
            Class<?> rangeClass = range.getJavaClass();
            if (range.isArray() && p.length == 1 && p[0].getType() == Integer.TYPE) {
                rangeClass = range.getComponentType().getJavaClass();
            }
            if (rangeClass.isAssignableFrom(returnClass) || rangeClass.getName().equals("org.apache.uima.jcas.cas.Sofa") && returnClass.getName().equals("org.apache.uima.cas.SofaFS") || rangeClass.getClassLoader() instanceof UIMAClassLoader) continue;
            FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_TYPE_RANGE_MISMATCH", ti.getName(), ti.getJavaClass().getClassLoader(), fi.getShortName(), rangeClass, rangeClass.getClassLoader(), returnClass, returnClass.getClassLoader()), false);
        }
        try {
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                String fname = ((Field)accessibleObject).getName();
                if (fname.length() <= 5 || !fname.startsWith("_FC_")) continue;
                String featName = fname.substring(4);
                FeatureImpl fi = ti.getFeatureByBaseName(featName);
                if (fi == null) {
                    FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_FIELD_MISSING_IN_TYPE_SYSTEM", clazz.getName(), featName), false);
                    continue;
                }
                Field mhf = clazz.getDeclaredField("_FH_" + featName);
                mhf.setAccessible(true);
                MethodHandle mh = (MethodHandle)mhf.get(null);
                int staticOffsetInClass = mh.invokeExact();
                if (fi.getAdjustedOffset() == staticOffsetInClass) continue;
                FSClassRegistry.add2errors(errorSet, new CASRuntimeException("JCAS_FIELD_ADJ_OFFSET_CHANGED", clazz.getName(), fi.getName(), staticOffsetInClass, fi.getAdjustedOffset()), staticOffsetInClass != -1);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void add2errors(ThreadLocal<List<ErrorReport>> errors, Exception e) {
        FSClassRegistry.add2errors(errors, e, true);
    }

    private static void add2errors(ThreadLocal<List<ErrorReport>> errors, Exception e, boolean doThrow) {
        List<ErrorReport> es = errors.get();
        if (es == null) {
            es = new ArrayList<ErrorReport>();
            errors.set(es);
        }
        es.add(new ErrorReport(e, doThrow));
    }

    private static void reportErrors() {
        boolean throwWhenDone = false;
        List<ErrorReport> es = errorSet.get();
        if (es != null) {
            StringBuilder msg = new StringBuilder(100);
            for (ErrorReport f : es) {
                msg.append(f.e.getMessage());
                throwWhenDone = throwWhenDone || f.doThrow;
                msg.append('\n');
            }
            errorSet.set(null);
            if (throwWhenDone) {
                throw new CASRuntimeException("JCAS_INIT_ERROR", "\n" + String.valueOf(msg));
            }
            Logger logger = UIMAFramework.getLogger();
            if (null == logger) {
                throw new CASRuntimeException("JCAS_INIT_ERROR", "\n" + String.valueOf(msg));
            }
            logger.log(Level.WARNING, msg.toString());
        }
    }

    static FsGenerator3[] getGeneratorsForClassLoader(ClassLoader aClassLoader, boolean aIsPear, TypeSystemImpl tsi) {
        Map<String, JCasClassInfo> type2jcci = FSClassRegistry.get_className_to_jcci(aClassLoader, aIsPear);
        FSClassRegistry.loadJCasForTSandClassLoader(tsi, true, aClassLoader, type2jcci);
        FsGenerator3[] generators = new FsGenerator3[tsi.getTypeArraySize()];
        FSClassRegistry.getGeneratorsForTypeAndSubtypes(tsi.topType, type2jcci, aIsPear, aClassLoader, generators, tsi);
        return generators;
    }

    private static void getGeneratorsForTypeAndSubtypes(TypeImpl aTypeInfo, Map<String, JCasClassInfo> t2jcci, boolean isPear, ClassLoader cl, FsGenerator3[] r, TypeSystemImpl tsi) {
        TypeImpl typeInfo = aTypeInfo;
        JCasClassInfo jcci = t2jcci.get(typeInfo.getJCasClassName());
        while (jcci == null) {
            typeInfo = typeInfo.getSuperType();
            jcci = t2jcci.get(typeInfo.getJCasClassName());
        }
        if (!isPear || jcci.isPearOverride(tsi)) {
            r[aTypeInfo.getCode()] = jcci.generator;
        }
        for (TypeImpl subType : aTypeInfo.getDirectSubtypes()) {
            FSClassRegistry.getGeneratorsForTypeAndSubtypes(subType, t2jcci, isPear, cl, r, tsi);
        }
    }

    private static void updateOrValidateAllCallSitesForJCasClass(Class<? extends TOP> clazz, TypeImpl type, ArrayList<MutableCallSite> callSites_toSync) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String featureName;
                int index;
                String fieldName = field.getName();
                if (!fieldName.startsWith("_FC_") || (index = TypeSystemImpl.getAdjustedFeatureOffset(type, featureName = fieldName.substring("_FC_".length()))) == -1) continue;
                field.setAccessible(true);
                MutableCallSite c = (MutableCallSite)field.get(null);
                if (c == null) continue;
                int prev = c.getTarget().invokeExact();
                if (prev == -1) {
                    MethodHandle mh_constant = FSClassRegistry.getConstantIntMethodHandle(index);
                    c.setTarget(mh_constant);
                    callSites_toSync.add(c);
                    continue;
                }
                if (prev == index) continue;
                FSClassRegistry.checkConformance(clazz.getClassLoader(), type.getTypeSystem());
                FSClassRegistry.reportErrors();
                throw new UIMA_IllegalStateException("JCAS_INCOMPATIBLE_TYPE_SYSTEMS", new Object[]{type.getName(), featureName});
            }
        }
        catch (Throwable e) {
            Misc.internalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_jcci_classloader(ClassLoader cl) {
        WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> weakIdentityMap = cl_to_type2JCas;
        synchronized (weakIdentityMap) {
            cl_to_type2JCas.remove(cl);
            if (cl_to_type2JCasStacks != null) {
                cl_to_type2JCasStacks.remove(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.5.1")
    public static void log_registered_classloaders(Level aLogLevel) {
        Logger log = UIMAFramework.getLogger(MethodHandles.lookup().lookupClass());
        if (cl_to_type2JCasStacks == null) {
            log.warn("log_registered_classloaders called but classLoader registration stack logging is not turned on. Define the system property [{}] to enable it.", (Object)LOG_JCAS_CLASSLOADERS_ON_SHUTDOWN);
            return;
        }
        LinkedHashMap<ClassLoader, StackTraceElement[]> clToLog = new LinkedHashMap<ClassLoader, StackTraceElement[]>();
        WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> weakIdentityMap = cl_to_type2JCas;
        synchronized (weakIdentityMap) {
            Iterator<ClassLoader> i = cl_to_type2JCas.keyIterator();
            while (i.hasNext()) {
                StackTraceElement[] stack;
                ClassLoader cl = i.next();
                if (cl == TypeSystemImpl.staticTsi.getClass().getClassLoader() || (stack = cl_to_type2JCasStacks.get(cl)) == null) continue;
                clToLog.put(cl, stack);
            }
        }
        if (clToLog.isEmpty()) {
            log.log(aLogLevel, "No classloaders except the system classloader registered.");
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (aLogLevel.isGreaterOrEqual(Level.WARN)) {
            buf.append("On shutdown, there were still " + clToLog.size() + " classloaders registered in the FSClassRegistry. Not destroying ResourceManagers after usage can cause memory leaks.");
        } else {
            buf.append("There are " + clToLog.size() + " classloaders registered in the FSClassRegistry:");
        }
        int i = 1;
        for (Map.Entry clAndStackTraceElements : clToLog.entrySet()) {
            buf.append("[" + i + "] " + String.valueOf(clAndStackTraceElements.getKey()) + " registered through:\n");
            for (StackTraceElement stackTraceElement : (StackTraceElement[])clAndStackTraceElements.getValue()) {
                buf.append("    " + String.valueOf(stackTraceElement) + "\n");
            }
            ++i;
        }
        log.log(aLogLevel, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.5.1")
    static Map<String, JCasClassInfo> get_className_to_jcci(ClassLoader cl, boolean aIsPear) {
        WeakIdentityMap<ClassLoader, Map<String, JCasClassInfo>> weakIdentityMap = cl_to_type2JCas;
        synchronized (weakIdentityMap) {
            Map<String, JCasClassInfo> cl2jcci = cl_to_type2JCas.get(cl);
            if (cl2jcci == null) {
                cl2jcci = new HashMap<String, JCasClassInfo>();
                cl_to_type2JCas.put(cl, cl2jcci);
                if (cl_to_type2JCasStacks != null) {
                    cl_to_type2JCasStacks.put(cl, new RuntimeException().getStackTrace());
                }
            }
            return cl2jcci;
        }
    }

    static MethodHandles.Lookup getLookup(ClassLoader aClassLoader) {
        try {
            UIMAClassLoader ucl = FSClassRegistry.getUimaClassLoader(aClassLoader);
            Class<?> clazz = Class.forName("org.apache.uima.cas.impl.MethodHandlesLookup", true, ucl);
            Method m = clazz.getMethod("getMethodHandlesLookup", new Class[0]);
            return (MethodHandles.Lookup)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UIMARuntimeException((Throwable)e, "INTERNAL_ERROR", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UIMAClassLoader getUimaClassLoader(ClassLoader aClassLoader) {
        if (aClassLoader instanceof UIMAClassLoader) {
            UIMAClassLoader ucl = (UIMAClassLoader)aClassLoader;
            return ucl;
        }
        WeakIdentityMap<ClassLoader, UIMAClassLoader> weakIdentityMap = cl_to_uimaCl;
        synchronized (weakIdentityMap) {
            UIMAClassLoader ucl = cl_to_uimaCl.get(aClassLoader);
            if (ucl == null) {
                ucl = new UIMAClassLoader(aClassLoader);
                cl_to_uimaCl.put(aClassLoader, ucl);
            }
            return ucl;
        }
    }

    static {
        methodHandlesForInt = new ArrayList<MethodHandle>();
        cl_to_type2JCas = WeakIdentityMap.newHashMap();
        cl_to_spiJCas = WeakIdentityMap.newHashMap();
        cl_to_uimaCl = WeakIdentityMap.newHashMap();
        JCAS_TO_GENERATOR = WeakIdentityMap.newHashMap();
        errorSet = new ThreadLocal();
        TypeSystemImpl tsi = TypeSystemImpl.staticTsi;
        jcasClassesInfoForBuiltins = new JCasClassInfo[tsi.getTypeArraySize()];
        ArrayList<MutableCallSite> callSites_toSync = new ArrayList<MutableCallSite>();
        ClassLoader cl = tsi.getClass().getClassLoader();
        FSClassRegistry.loadBuiltins(tsi.topType, cl, FSClassRegistry.get_className_to_jcci(cl, false), callSites_toSync);
        MutableCallSite[] sync = callSites_toSync.toArray(new MutableCallSite[callSites_toSync.size()]);
        MutableCallSite.syncAll(sync);
        FSClassRegistry.reportErrors();
        if (IS_LOG_JCAS_CLASSLOADERS_ON_SHUTDOWN || IS_RECORD_JCAS_CLASSLOADERS) {
            cl_to_type2JCasStacks = WeakIdentityMap.newHashMap();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    FSClassRegistry.log_registered_classloaders(Level.WARN);
                }
            });
        } else {
            cl_to_type2JCasStacks = null;
        }
    }

    public static class JCasClassInfo {
        final FsGenerator3 generator;
        final Class<? extends TOP> jcasClass;
        final int jcasType;
        final JCasClassFeatureInfo[] features;

        JCasClassInfo(Class<? extends TOP> aJCasClass, FsGenerator3 aGenerator, int aJCasType) {
            this.generator = aGenerator;
            this.jcasClass = aJCasClass;
            this.jcasType = aJCasType;
            this.features = JCasClassInfo.getJCasClassFeatureInfo(aJCasClass);
        }

        boolean isCopydown(TypeImpl ti) {
            return this.isCopydown(ti.getJCasClassName());
        }

        boolean isCopydown(String jcasClassName) {
            return !this.jcasClass.getCanonicalName().equals(jcasClassName);
        }

        boolean isPearOverride(TypeSystemImpl tsi) {
            JCasClassInfo baseJcci = tsi.getJcci(this.jcasClass.getName());
            return baseJcci == null || !this.jcasClass.getClassLoader().equals(baseJcci.jcasClass.getClassLoader());
        }

        TypeImpl getUimaType(TypeSystemImpl tsi) {
            return tsi.getType(Misc.javaClassName2UimaTypeName(this.jcasClass.getName()));
        }

        private static JCasClassFeatureInfo[] getJCasClassFeatureInfo(Class<?> jcasClass) {
            try {
                ArrayList<JCasClassFeatureInfo> features = new ArrayList<JCasClassFeatureInfo>();
                for (Field f : jcasClass.getDeclaredFields()) {
                    Method m;
                    String fname = f.getName();
                    if (fname.length() <= 5 || !fname.startsWith("_FC_")) continue;
                    String featName = fname.substring(4);
                    String getterName = "get" + Character.toUpperCase(featName.charAt(0)) + featName.substring(1);
                    try {
                        m = jcasClass.getDeclaredMethod(getterName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Logger logger = UIMAFramework.getLogger(FSClassRegistry.class);
                        logger.warn(() -> logger.rb_ue("JCAS_MISSING_GETTER", jcasClass.getName(), featName));
                        continue;
                    }
                    String rangeClassName = m.getReturnType().getName();
                    String uimaRangeName = Misc.javaClassName2UimaTypeName(rangeClassName);
                    features.add(new JCasClassFeatureInfo(featName, uimaRangeName));
                }
                return (JCasClassFeatureInfo[])features.toArray(JCasClassFeatureInfo[]::new);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ErrorReport {
        final Exception e;
        final boolean doThrow;

        ErrorReport(Exception e, boolean doThrow) {
            this.e = e;
            this.doThrow = doThrow;
        }
    }

    static class JCasClassFeatureInfo {
        final String shortName;
        final String uimaRangeName;

        JCasClassFeatureInfo(String shortName, String uimaRangeName) {
            this.shortName = shortName;
            this.uimaRangeName = uimaRangeName;
        }

        public String toString() {
            return String.format("JCasClassFeatureInfo feature: %s, range: %s", this.shortName == null ? "<null>" : this.shortName, this.uimaRangeName == null ? "<null>" : this.uimaRangeName);
        }
    }
}

