/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.client;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VinciFrame;

public class ResolveResult
extends Frame {
    public int priority = -1;
    public static TransportableFactory factory = new TransportableFactory(){

        public Transportable makeTransportable() {
            return new ResolveResult();
        }
    };
    private List services = new ArrayList();
    private int begin;
    private int current;

    public static String unqualifiedName(String service_name) {
        if (ResolveResult.isQualified(service_name)) {
            service_name = service_name.trim();
            int start = service_name.lastIndexOf(91);
            return service_name.substring(0, start);
        }
        return service_name;
    }

    public static boolean isQualified(String service_name) {
        return service_name.indexOf(91) != -1;
    }

    public static Frame composeQuery(String service_name) {
        int end;
        VinciFrame query = new VinciFrame();
        query.fadd("vinci:COMMAND", "resolve");
        int start = service_name.indexOf(91);
        if (start != -1 && (end = service_name.indexOf(93, start)) != -1) {
            String qualifications = service_name.substring(start + 1, end);
            query.fadd("SERVICE", service_name.substring(0, start));
            StringTokenizer tokenizer = new StringTokenizer(qualifications, ",");
            if (tokenizer.hasMoreTokens()) {
                query.fadd("LEVEL", tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    query.fadd("HOST", tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        query.fadd("INSTANCE", tokenizer.nextToken());
                    }
                }
            }
            return query;
        }
        int at = service_name.indexOf(64);
        if (at == -1) {
            query.fadd("SERVICE", service_name);
        } else {
            query.fadd("SERVICE", service_name.substring(0, at));
        }
        return query;
    }

    public static Frame composeQuery(String service_name, int mypriority) {
        VinciFrame query = (VinciFrame)ResolveResult.composeQuery(service_name);
        query.fadd("LEVEL", mypriority);
        return query;
    }

    public void initializeIterator() {
        this.current = this.begin = (int)(Math.random() * (double)this.services.size());
    }

    public boolean hasMore() {
        return this.current - this.begin < this.services.size();
    }

    public ServiceLocator getNext() {
        ServiceLocator return_me = (ServiceLocator)this.services.get(this.current % this.services.size());
        ++this.current;
        return return_me;
    }

    public void add(String key, FrameComponent val) {
        if (key.equals("SERVER")) {
            Debug.Assert(val instanceof ServiceLocator);
            this.services.add(val);
        } else if (key.equals("LEVEL")) {
            this.priority = ((FrameLeaf)val).toInt();
        }
    }

    public Frame createSubFrame(String key, int capacity) {
        return new ServiceLocator();
    }

    public static class ServiceLocator
    extends Frame {
        public String host;
        public int port;
        public int instance;

        public void add(String key, FrameComponent val) {
            if (key.equals("HOST")) {
                this.host = ((FrameLeaf)val).toString();
            } else if (key.equals("PORT")) {
                this.port = ((FrameLeaf)val).toInt();
            } else if (key.equals("INSTANCE")) {
                this.instance = ((FrameLeaf)val).toInt();
            }
        }
    }
}

