/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.bootstrap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.Join;

public class Archive {
    private final Map<String, String> manifest = new HashMap<String, String>();
    private final Map<String, Supplier<byte[]>> entries = new HashMap<String, Supplier<byte[]>>();

    public static Archive archive() {
        return new Archive();
    }

    public Archive manifest(String key, Object value) {
        this.manifest.put(key, value.toString());
        return this;
    }

    public Archive manifest(String key, Class value) {
        this.manifest.put(key, value.getName());
        return this;
    }

    public Archive add(String name, byte[] bytes) {
        this.entries.put(name, () -> bytes);
        return this;
    }

    public Archive add(String name, Supplier<byte[]> content) {
        this.entries.put(name, content);
        return this;
    }

    public Archive add(String name, String content) {
        return this.add(name, content::getBytes);
    }

    public Archive add(String name, File content) {
        if (content.isDirectory()) {
            return this.addDir(name, content);
        }
        return this.add(name, () -> Archive.readBytes(content));
    }

    public Archive add(String name, Archive archive) {
        this.manifest.putAll(archive.manifest);
        for (Map.Entry<String, Supplier<byte[]>> entry : archive.entries.entrySet()) {
            this.entries.put(name + "/" + entry.getKey(), entry.getValue());
        }
        return this;
    }

    private static byte[] readBytes(File content) {
        try {
            return IO.readBytes((File)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Archive add(String name, URL content) {
        try {
            return this.add(name, IO.readBytes((URL)content));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Archive add(Class<?> clazz) {
        String name = clazz.getName().replace('.', '/') + ".class";
        URL resource = this.getClass().getClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalStateException("Cannot find class file for " + clazz.getName());
        }
        this.add(name, resource);
        if (!clazz.isAnonymousClass() && clazz.getDeclaringClass() != null) {
            this.add(clazz.getDeclaringClass());
        }
        Stream.of(clazz.getDeclaredClasses()).filter(Class::isAnonymousClass).forEach(this::add);
        return this;
    }

    public Archive addDir(File dir) {
        return this.addDir(null, dir);
    }

    private Archive addDir(String path, File dir) {
        for (File file : dir.listFiles()) {
            String childPath;
            String string = childPath = path != null ? path + "/" + file.getName() : file.getName();
            if (file.isFile()) {
                this.entries.put(childPath, () -> Archive.readBytes(file));
                continue;
            }
            this.addDir(childPath, file);
        }
        return this;
    }

    public Archive addJar(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                byte[] bytes = IO.readBytes((InputStream)jarFile.getInputStream(entry));
                this.entries.put(entry.getName(), () -> bytes);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File toJar() {
        File file;
        try {
            file = File.createTempFile("archive-", ".jar");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        file.deleteOnExit();
        return this.toJar(file);
    }

    public File toJar(File file) {
        try {
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                for (Map.Entry<String, Supplier<byte[]>> entry : this.entries().entrySet()) {
                    out.putNextEntry(new ZipEntry(entry.getKey()));
                    out.write(entry.getValue().get());
                }
            }
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public File toDir() {
        File classpath = Files.tmpdir();
        this.toDir(classpath);
        return classpath;
    }

    public void toDir(File dir) {
        Files.exists((File)dir);
        Files.dir((File)dir);
        Files.writable((File)dir);
        for (Map.Entry<String, Supplier<byte[]>> entry : this.entries().entrySet()) {
            String key = entry.getKey().replace('/', File.separatorChar);
            File file = new File(dir, key);
            Files.mkparent((File)file);
            try {
                IO.copy((byte[])entry.getValue().get(), (File)file);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot write entry " + entry.getKey(), e);
            }
        }
    }

    private HashMap<String, Supplier<byte[]>> entries() {
        HashMap<String, Supplier<byte[]>> entries = new HashMap<String, Supplier<byte[]>>(this.entries);
        if (this.manifest.size() > 0) {
            entries.put("META-INF/MANIFEST.MF", this.buildManifest()::getBytes);
        }
        return entries;
    }

    private String buildManifest() {
        return Join.join((String)"\r\n", entry -> (String)entry.getKey() + ": " + (String)entry.getValue(), this.manifest.entrySet());
    }
}

