/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;

public interface AnnotatedParameter<X>
extends Annotated {
    public int getPosition();

    public AnnotatedCallable<X> getDeclaringCallable();

    default public Parameter getJavaParameter() {
        Member javaMember = this.getDeclaringCallable().getJavaMember();
        if (!Executable.class.isInstance(javaMember)) {
            throw new IllegalStateException("Parameter does not belong to a Constructor or Method: " + javaMember);
        }
        return ((Executable)javaMember).getParameters()[this.getPosition()];
    }

    @Override
    default public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        return new LinkedHashSet<Annotation>(Arrays.asList(this.getJavaParameter().getAnnotationsByType(annotationType)));
    }
}

