/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver persistenceResolver = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return persistenceResolver;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        if (persistenceResolver != null) {
            persistenceResolver.clearCachedProviders();
            persistenceResolver = null;
        }
        persistenceResolver = resolver != null ? resolver : new DefaultPersistenceProviderResolver();
    }

    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private static final String SERVICES_FILENAME = "META-INF/services/" + PersistenceProvider.class.getName();
        private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providerCache = new WeakHashMap();

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            List<PersistenceProvider> providers;
            ClassLoader cl = PrivClassLoader.get(null);
            if (cl == null) {
                cl = PrivClassLoader.get(DefaultPersistenceProviderResolver.class);
            }
            if ((providers = this.providerCache.get(cl)) == null) {
                providers = new ArrayList<PersistenceProvider>();
                try {
                    List<Object> serviceProviders = ProviderLocator.getServices(PersistenceProvider.class.getName(), this.getClass(), cl);
                    for (Object o : serviceProviders) {
                        providers.add((PersistenceProvider)o);
                    }
                    this.providerCache.put(cl, providers);
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", e);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", e);
                }
                catch (Exception e) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", e);
                }
            }
            return providers;
        }

        @Override
        public void clearCachedProviders() {
            this.providerCache.clear();
        }

        private static class PrivClassLoader
        implements PrivilegedAction<ClassLoader> {
            private final Class<?> c;

            public static ClassLoader get(Class<?> c) {
                PrivClassLoader action = new PrivClassLoader(c);
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(action);
                }
                return action.run();
            }

            private PrivClassLoader(Class<?> c) {
                this.c = c;
            }

            @Override
            public ClassLoader run() {
                if (this.c != null) {
                    return this.c.getClassLoader();
                }
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }
}

