/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.api.resource.DestroyableResource;
import org.apache.openejb.threads.future.CUFuture;
import org.apache.openejb.threads.task.CUCallable;
import org.apache.openejb.threads.task.CURunnable;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedExecutorServiceImpl
extends AbstractExecutorService
implements ManagedExecutorService,
DestroyableResource {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, ManagedExecutorServiceImpl.class);
    private final ExecutorService delegate;

    public ManagedExecutorServiceImpl(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        throw new IllegalStateException("You can't call shutdown");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException("You can't call shutdownNow");
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public Integer getCorePoolSize() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getCorePoolSize();
        }
        return null;
    }

    public Integer getMaximumPoolSize() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getMaximumPoolSize();
        }
        return null;
    }

    public Integer getPoolSize() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getPoolSize();
        }
        return null;
    }

    public Integer getActiveCount() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getActiveCount();
        }
        return null;
    }

    public Integer getLargestPoolSize() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getLargestPoolSize();
        }
        return null;
    }

    public Integer getQueueSize() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getQueue().size();
        }
        return null;
    }

    public Long getCompletedTaskCount() {
        if (this.delegate instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.delegate).getCompletedTaskCount();
        }
        return null;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        CUCallable<T> wrapper = new CUCallable<T>(task);
        Future<T> future = this.delegate.submit(wrapper);
        wrapper.taskSubmitted(future, this, task);
        return new CUFuture(future, wrapper);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        CURunnable wrapper = new CURunnable(task);
        Future<T> future = this.delegate.submit(wrapper, result);
        wrapper.taskSubmitted(future, this, task);
        return new CUFuture(future, wrapper);
    }

    @Override
    public Future<?> submit(Runnable task) {
        CURunnable wrapper = new CURunnable(task);
        Future<?> future = this.delegate.submit(wrapper);
        wrapper.taskSubmitted(future, this, task);
        return new CUFuture((Future)Future.class.cast(future), wrapper);
    }

    @Override
    public void execute(Runnable command) {
        CURunnable wrapper = new CURunnable(command);
        this.delegate.execute(wrapper);
        wrapper.taskSubmitted(null, this, command);
    }

    public ExecutorService getDelegate() {
        return this.delegate;
    }

    public void destroyResource() {
        List<Runnable> runnables = this.delegate.shutdownNow();
        if (runnables.size() > 0) {
            LOGGER.warning(runnables.size() + " tasks to execute");
            for (Runnable runnable : runnables) {
                try {
                    LOGGER.info("Executing " + runnable);
                    runnable.run();
                }
                catch (Throwable th) {
                    LOGGER.error(th.getMessage(), th);
                }
            }
        }
    }
}

