/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Map;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.util.PriorityQueue;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IndirectionException;

public abstract class ObjectReader
extends ObjectInputStream {
    int recursionDepth = 0;
    final Serializable object;
    PriorityQueue callbacks;
    private ValueDescriptor desc;
    private byte streamFormatVersion;

    ObjectReader(Serializable obj) throws IOException {
        this.object = obj;
    }

    final void setCurrentValueDescriptor(ValueDescriptor desc) {
        this.desc = desc;
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.desc == null) {
            throw new NotActiveException();
        }
        this.desc.defaultReadValue(this, this.object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final java.lang.Object readObjectOverride() throws ClassNotFoundException, IOException {
        try {
            this.enterRecursion();
            java.lang.Object object = this.readAbstractObject();
            return object;
        }
        finally {
            this.exitRecursion();
        }
    }

    protected void enterRecursion() {
        ++this.recursionDepth;
    }

    protected void exitRecursion() throws InvalidObjectException {
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.callbacks != null) {
            while (this.callbacks.size() != 0) {
                Validation val = (Validation)this.callbacks.dequeue();
                val.validate();
            }
        }
    }

    public synchronized void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (obj == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        Validation val = new Validation(obj, prio);
        if (this.callbacks == null) {
            this.callbacks = new PriorityQueue();
        }
        this.callbacks.enqueue(val);
    }

    public abstract java.lang.Object readAbstractObject() throws IndirectionException;

    public abstract java.lang.Object readAny() throws IndirectionException;

    public abstract java.lang.Object readValueObject() throws IndirectionException;

    public abstract java.lang.Object readValueObject(Class var1) throws IndirectionException;

    public abstract Object readCorbaObject(Class var1);

    public abstract Remote readRemoteObject(Class var1);

    public void close() throws IOException {
    }

    public ObjectInputStream.GetField readFields() throws IOException {
        if (this.desc == null) {
            throw new NotActiveException();
        }
        Map fieldMap = this.desc.readFields(this);
        return new GetFieldImpl(fieldMap);
    }

    public void readFully(byte[] arr) throws IOException {
        this.readFully(arr, 0, arr.length);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        short val = this.readShort();
        return val & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readExternal(Externalizable ext) throws IOException, ClassNotFoundException {
        byte old = this.streamFormatVersion;
        try {
            this.streamFormatVersion = this.readByte();
            ext.readExternal(this);
        }
        finally {
            this.streamFormatVersion = old;
        }
    }

    static class GetFieldImpl
    extends ObjectInputStream.GetField {
        Map fieldMap;

        GetFieldImpl(Map map) {
            this.fieldMap = map;
        }

        public boolean defaulted(String name) throws IOException {
            return !this.fieldMap.containsKey(name);
        }

        public boolean get(String name, boolean val) throws IOException {
            Boolean value = (Boolean)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public byte get(String name, byte val) throws IOException {
            Byte value = (Byte)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public char get(String name, char val) throws IOException {
            Character value = (Character)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value.charValue();
        }

        public double get(String name, double val) throws IOException {
            Double value = (Double)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public float get(String name, float val) throws IOException {
            Float value = (Float)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value.floatValue();
        }

        public int get(String name, int val) throws IOException {
            Integer value = (Integer)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public long get(String name, long val) throws IOException {
            Long value = (Long)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public java.lang.Object get(String name, java.lang.Object val) throws IOException {
            java.lang.Object value = this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public short get(String name, short val) throws IOException {
            Short value = (Short)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }
    }

    private class Validation
    implements Comparable {
        ObjectInputValidation validator;
        int pri;

        Validation(ObjectInputValidation val, int pri) {
            this.validator = val;
            this.pri = pri;
        }

        public int compareTo(java.lang.Object other) {
            Validation o = (Validation)other;
            return this.pri - o.pri;
        }

        void validate() throws InvalidObjectException {
            this.validator.validateObject();
        }
    }
}

