/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweJsonDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweException;

@PreMatching
@Priority(value=1001)
public class JweJsonContainerRequestFilter
extends AbstractJweJsonDecryptingFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        if (this.isMethodWithNoContent(context.getMethod()) || this.isCheckEmptyStream() && !context.hasEntity()) {
            return;
        }
        byte[] encryptedContent = IOUtils.readBytesFromStream(context.getEntityStream());
        if (encryptedContent.length == 0) {
            return;
        }
        try {
            JweDecryptionOutput out = this.decrypt(encryptedContent);
            byte[] bytes = out.getContent();
            context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
            context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
            String ct = JoseUtils.checkContentType(out.getHeaders().getContentType(), this.getDefaultMediaType());
            if (ct != null) {
                context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
            }
            if (super.isValidateHttpHeaders()) {
                super.validateHttpHeadersIfNeeded((MultivaluedMap<String, String>)context.getHeaders(), out.getHeaders());
            }
        }
        catch (JweException ex) {
            context.abortWith(JAXRSUtils.toResponse(400));
            return;
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoRequestContent(method);
    }
}

