/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.nio.ParallelNioSender;

public class PooledParallelSender
extends PooledSender
implements MultiPointSender {
    protected boolean connected = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Member[] destination, ChannelMessage message) throws ChannelException {
        if (!this.connected) {
            throw new ChannelException("Sender not connected.");
        }
        ParallelNioSender sender = (ParallelNioSender)this.getSender();
        try {
            sender.sendMessage(destination, message);
            sender.keepalive();
        }
        finally {
            if (!this.connected) {
                this.disconnect();
            }
            this.returnSender(sender);
        }
    }

    public DataSender getNewDataSender() {
        try {
            ParallelNioSender sender = new ParallelNioSender();
            ParallelNioSender.transferProperties(this, sender);
            return sender;
        }
        catch (IOException x) {
            throw new RuntimeException("Unable to open NIO selector.", x);
        }
    }

    public synchronized void disconnect() {
        this.connected = false;
        super.disconnect();
    }

    public synchronized void connect() throws IOException {
        this.connected = true;
        super.connect();
    }
}

