/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.Serializable;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicatedMap
extends AbstractReplicatedMap
implements RpcCallback,
ChannelListener,
MembershipListener {
    protected static Log log = LogFactory.getLog(ReplicatedMap.class);

    public ReplicatedMap(Object owner, Channel channel, long timeout, String mapContextName, int initialCapacity, float loadFactor, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, loadFactor, 2, cls);
    }

    public ReplicatedMap(Object owner, Channel channel, long timeout, String mapContextName, int initialCapacity, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, 0.75f, 2, cls);
    }

    public ReplicatedMap(Object owner, Channel channel, long timeout, String mapContextName, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, 16, 0.75f, 2, cls);
    }

    protected int getStateMessageType() {
        return 10;
    }

    protected Member[] publishEntryInfo(Object key, Object value) throws ChannelException {
        if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
            return new Member[0];
        }
        Member[] backup = this.getMapMembers();
        if (backup == null || backup.length == 0) {
            return null;
        }
        AbstractReplicatedMap.MapMessage msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 9, false, (Serializable)key, (Serializable)value, null, backup);
        this.getChannel().send(this.getMapMembers(), msg, this.getChannelSendOptions());
        return backup;
    }
}

