/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.javatuples.Pair;

@Deprecated
public final class TinkerIoRegistry
extends AbstractIoRegistry {
    private static final TinkerIoRegistry INSTANCE = new TinkerIoRegistry();

    private TinkerIoRegistry() {
        this.register(GryoIo.class, TinkerGraph.class, (Object)new TinkerGraphGryoSerializer());
        this.register(GraphSONIo.class, null, (Object)new TinkerModule());
    }

    @Deprecated
    public static TinkerIoRegistry getInstance() {
        return TinkerIoRegistry.instance();
    }

    public static TinkerIoRegistry instance() {
        return INSTANCE;
    }

    static class TinkerGraphJacksonDeserializer
    extends StdDeserializer<TinkerGraph> {
        public TinkerGraphJacksonDeserializer() {
            super(TinkerGraph.class);
        }

        public TinkerGraph deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedVertex detached;
            List edges;
            List vertices;
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
            TinkerGraph graph = TinkerGraph.open((Configuration)conf);
            if (!jsonParser.getCurrentToken().isStructStart()) {
                if (!jsonParser.getCurrentName().equals("vertices")) {
                    throw new IOException(String.format("Expected a '%s' key", "vertices"));
                }
                jsonParser.nextToken();
                vertices = (List)deserializationContext.readValue(jsonParser, ArrayList.class);
                jsonParser.nextToken();
                if (!jsonParser.getCurrentName().equals("edges")) {
                    throw new IOException(String.format("Expected a '%s' key", "edges"));
                }
                jsonParser.nextToken();
                edges = (List)deserializationContext.readValue(jsonParser, ArrayList.class);
            } else {
                Map graphData = (Map)deserializationContext.readValue(jsonParser, HashMap.class);
                vertices = (List)graphData.get("vertices");
                edges = (List)graphData.get("edges");
            }
            for (Map vertexData : vertices) {
                detached = new DetachedVertex(vertexData.get("id"), vertexData.get("label").toString(), (Map)vertexData.get("properties"));
                detached.attach(Attachable.Method.getOrCreate((Host)graph));
            }
            for (Map edgeData : edges) {
                detached = new DetachedEdge(edgeData.get("id"), edgeData.get("label").toString(), (Map)edgeData.get("properties"), Pair.with(edgeData.get("outV"), (Object)edgeData.get("outVLabel").toString()), Pair.with(edgeData.get("inV"), (Object)edgeData.get("inVLabel").toString()));
                detached.attach(Attachable.Method.getOrCreate((Host)graph));
            }
            return graph;
        }
    }

    static final class TinkerGraphJacksonSerializer
    extends StdSerializer<TinkerGraph> {
        public TinkerGraphJacksonSerializer() {
            super(TinkerGraph.class);
        }

        public void serialize(TinkerGraph graph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("vertices");
            jsonGenerator.writeStartArray();
            Iterator<Vertex> vertices = graph.vertices(new Object[0]);
            while (vertices.hasNext()) {
                serializerProvider.defaultSerializeValue((Object)vertices.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("edges");
            jsonGenerator.writeStartArray();
            Iterator<Edge> edges = graph.edges(new Object[0]);
            while (edges.hasNext()) {
                serializerProvider.defaultSerializeValue((Object)edges.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }

        public void serializeWithType(TinkerGraph graph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("@class", TinkerGraph.class.getName());
            jsonGenerator.writeFieldName("vertices");
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(ArrayList.class.getName());
            jsonGenerator.writeStartArray();
            Iterator<Vertex> vertices = graph.vertices(new Object[0]);
            while (vertices.hasNext()) {
                GraphSONUtil.writeWithType((Object)vertices.next(), (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("edges");
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(ArrayList.class.getName());
            jsonGenerator.writeStartArray();
            Iterator<Edge> edges = graph.edges(new Object[0]);
            while (edges.hasNext()) {
                GraphSONUtil.writeWithType((Object)edges.next(), (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }

    static final class TinkerModule
    extends SimpleModule {
        public TinkerModule() {
            super("tinkergraph-1.0");
            this.addSerializer(TinkerGraph.class, (JsonSerializer)new TinkerGraphJacksonSerializer());
            this.addDeserializer(TinkerGraph.class, (JsonDeserializer)new TinkerGraphJacksonDeserializer());
        }
    }

    static final class TinkerGraphGryoSerializer
    extends Serializer<TinkerGraph> {
        TinkerGraphGryoSerializer() {
        }

        public void write(Kryo kryo, Output output, TinkerGraph graph) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                GryoWriter.build().mapper(() -> kryo).create().writeGraph((OutputStream)stream, (Graph)graph);
                byte[] bytes = stream.toByteArray();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        }

        public TinkerGraph read(Kryo kryo, Input input, Class<TinkerGraph> tinkerGraphClass) {
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
            TinkerGraph graph = TinkerGraph.open((Configuration)conf);
            int len = input.readInt();
            byte[] bytes = input.readBytes(len);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                GryoReader.build().mapper(() -> kryo).create().readGraph((InputStream)stream, (Graph)graph);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
            return graph;
        }
    }
}

